/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes;

import java.util.List;
import java.util.Map;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.PipesReporter;
import org.apache.tika.pipes.PipesResult;

public class CompositePipesReporter
extends PipesReporter
implements Initializable {
    private List<PipesReporter> pipesReporters;

    @Override
    public void report(FetchEmitTuple t, PipesResult result, long elapsed) {
        for (PipesReporter reporter : this.pipesReporters) {
            reporter.report(t, result, elapsed);
        }
    }

    @Field
    public void setPipesReporters(List<PipesReporter> pipesReporters) {
        this.pipesReporters = pipesReporters;
    }

    public List<PipesReporter> getPipesReporters() {
        return this.pipesReporters;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (this.pipesReporters == null) {
            throw new TikaConfigException("must specify 'pipesReporters'");
        }
        if (this.pipesReporters.size() == 0) {
            throw new TikaConfigException("must specify at least one pipes reporter");
        }
    }
}

