/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.api.search.SearchCommunicator;
import ancestris.core.TextOptions;
import ancestris.core.resources.Images;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.util.swing.SelectEntityPanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.time.PointInTime;
import genj.option.Option;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.ImageIcon;
import java.awt.Component;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import org.openide.filesystems.FileObject;

public abstract class Report
implements Cloneable,
Resources.ResourcesProvider {
    private static final PrintWriter NUL = new PrintWriter(new OutputStream(){

        @Override
        public void write(int b) {
        }
    });
    protected static final Logger LOG = Logger.getLogger("ancestris.report");
    protected TextOptions OPTIONS = TextOptions.getInstance();
    protected static final int OPTION_YESNO = 0;
    protected static final int OPTION_OKCANCEL = 1;
    protected static final int OPTION_OK = 2;
    private static final int[] OPTION_TYPE = new int[]{0, 2, 10};
    protected static final int ALIGN_LEFT = 0;
    protected static final int ALIGN_CENTER = 1;
    protected static final int ALIGN_RIGHT = 2;
    protected Registry registry;
    private static final Resources COMMON_RESOURCES = Resources.get(Report.class);
    private final Map<Locale, Resources> LOCALE_2_RESOURCES = new HashMap<Locale, Resources>(3);
    private List<Option> options;
    private Icon icon;
    private PrintWriter out = NUL;
    private Component owner = null;
    private static final Pattern PATTERN_CVS_DATE = Pattern.compile("\\$Date: (\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d)( \\d\\d:\\d\\d:\\d\\d) *\\$");

    protected Report() {
        this.registry = new Registry(Registry.get(this.getClass()), this.getClass().getName());
    }

    protected void log(String txt) {
        this.getOut().println(txt);
    }

    public PrintWriter getOut() {
        return this.out;
    }

    void setOut(PrintWriter set) {
        this.out = set;
    }

    void setOwner(Component set) {
        this.owner = set;
    }

    public void saveOptions() {
        if (this.options == null) {
            return;
        }
        for (Option option : this.options) {
            if (option instanceof PropertyOption) {
                PropertyOption propertyOption = (PropertyOption)option;
                propertyOption.persist(this.registry);
                continue;
            }
            option.persist();
        }
    }

    protected Registry getRegistry() {
        return this.registry;
    }

    public final List<? extends Option> getOptions() {
        return this.getOptions(false);
    }

    public final List<? extends Option> getOptions(boolean forceRead) {
        if (forceRead) {
            this.options = null;
        }
        if (this.options != null) {
            return this.options;
        }
        this.options = new ArrayList<Option>();
        List props = PropertyOption.introspect((Object)this, (boolean)true);
        for (PropertyOption prop : props) {
            String toolTipKey;
            String toolTip;
            prop.restore(this.registry);
            String oname = this.translateOption(prop.getProperty());
            if (oname.length() > 0) {
                prop.setName(oname);
            }
            if ((toolTip = this.translateOption(toolTipKey = prop.getProperty() + ".tip")).length() > 0 && !toolTip.equals(toolTipKey)) {
                prop.setToolTip(toolTip);
            }
            if (prop.getCategory() == null) {
                prop.setCategory(this.getName());
            } else {
                prop.setCategory(this.translateOption(prop.getCategory()));
            }
            this.options.add((Option)prop);
        }
        return this.options;
    }

    public void setOptions(FileObject fo) {
        if (this.options == null) {
            return;
        }
        for (Option option : this.options) {
            Class<?> clazz;
            Class<?> foclazz;
            if (!(option instanceof PropertyOption)) continue;
            PropertyOption pOption = (PropertyOption)option;
            String key = pOption.getProperty();
            Object value = pOption.getValue();
            Object foValue = fo.getAttribute("option." + key);
            if (foValue == null || !(foclazz = foValue.getClass()).equals(clazz = value.getClass()) || foValue.equals(value)) continue;
            pOption.setValue(foValue);
        }
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        this.icon = this.getCategory().getImage();
        return this.icon;
    }

    public Category getCategory() {
        String name = this.translateGUI("category");
        if (name.equals("category") || name.length() == 0) {
            return Category.DEFAULT_CATEGORY;
        }
        return Category.get(name);
    }

    public final void flush() {
        this.getOut().flush();
    }

    public final void println() {
        this.println("");
    }

    public final void println(Object o) {
        if (o == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        this.log(o.toString());
    }

    public final void println(Throwable t) {
        CharArrayWriter awriter = new CharArrayWriter(256);
        t.printStackTrace(new PrintWriter(awriter));
        this.log(awriter.toString());
    }

    public File getFileFromUser(String title, String button) {
        return this.getFileFromUser(title, button, false);
    }

    public File getFileFromUser(String title, String button, boolean askForOverwrite) {
        return this.getFileFromUser(title, button, askForOverwrite, null, "");
    }

    public File getFileFromUser(String title, String button, boolean askForOverwrite, String extension, String selectedFile) {
        File file;
        if (selectedFile.isBlank()) {
            selectedFile = Utilities.removeDiacriticsUnderscore((String)this.getName()).replaceAll("_$", "");
        }
        if ((file = new FileChooserBuilder(Report.class.getCanonicalName() + "file").setFilesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(button).setDefaultExtension(extension != null && !extension.isEmpty() ? extension : FileChooserBuilder.getTextFilter().getExtensions()[0]).setFileFilter((FileFilter)new FileExtensionFilter(extension)).setAcceptAllFileFilterUsed(true).setFileHiding(true).setParent(this.owner).setDefaultDirAsReportDirectory().setSelectedFile(new File(selectedFile)).showSaveDialog(askForOverwrite)) != null) {
            this.registry.put("file", file.getParent());
        }
        return file;
    }

    public File getDirectoryFromUser(String title, String button) {
        File file = new FileChooserBuilder(Report.class.getCanonicalName() + "dir").setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(title).setApproveText(button).setFileHiding(true).setParent(this.owner).setDefaultDirAsReportDirectory().showOpenDialog();
        if (file != null) {
            this.registry.put("dir", file.toString());
        }
        return file;
    }

    public final Entity getEntityFromUser(String msg, Gedcom gedcom, String tag) {
        return this.getEntityFromUser(msg, gedcom, tag, null);
    }

    public final Entity getEntityFromUser(String msg, Gedcom gedcom, String tag, Entity defaultEntity) {
        if (defaultEntity == null) {
            defaultEntity = gedcom.getEntity(this.registry.get("select." + tag, (String)null));
        }
        SelectEntityPanel select = new SelectEntityPanel(gedcom, tag, COMMON_RESOURCES.getString("choose.entity", new Object[]{Gedcom.getName((String)tag), msg}), defaultEntity);
        if (DialogManager.OK_OPTION != DialogManager.create((String)this.getName(), (JComponent)select).setMessageType(3).setOptionType(2).setDialogId("report.entityfromuser").show()) {
            return null;
        }
        Entity result = select.getSelection();
        if (result == null) {
            return null;
        }
        this.registry.put("select." + result.getTag(), result.getId());
        return result;
    }

    public final Object getValueFromUser(String msg, Object[] choices, Object selected) {
        ChoiceWidget choice = new ChoiceWidget(choices, selected);
        choice.setEditable(false);
        if (DialogManager.create((String)this.getName(), (JComponent[])new JComponent[]{new JLabel(msg), choice}).setMessageType(3).setOptionType(2).setDialogId("report.valuefromuser").show() != DialogManager.OK_OPTION) {
            return null;
        }
        return choice.getSelectedItem();
    }

    public final String getValueFromUser(String key, String msg) {
        return this.getValueFromUser(key, msg, new String[0]);
    }

    public final String getValueFromUser(String key, String msg, String[] defaultChoices) {
        String[] presets;
        if (key != null && (presets = this.registry.get(key, (String[])null)) != null) {
            defaultChoices = presets;
        }
        ChoiceWidget choice = new ChoiceWidget((Object[])defaultChoices, (Object)(defaultChoices.length > 0 ? defaultChoices[0] : ""));
        if (DialogManager.create((String)this.getName(), (JComponent[])new JComponent[]{new JLabel(msg), choice}).setMessageType(3).setOptionType(2).setDialogId("report.valuefromuser").show() != DialogManager.OK_OPTION) {
            return null;
        }
        String result = choice.getText();
        if (key != null && result != null && result.length() > 0) {
            ArrayList<String> values = new ArrayList<String>(defaultChoices.length + 1);
            values.add(result);
            for (int d = 0; d < defaultChoices.length && d < 20; ++d) {
                if (result.equalsIgnoreCase(defaultChoices[d])) continue;
                values.add(defaultChoices[d]);
            }
            this.registry.put(key, values);
        }
        return result;
    }

    public final boolean getOptionsFromUser(String title, Object options) {
        List os = PropertyOption.introspect((Object)options);
        String prefix = options.getClass().getName();
        int i = prefix.lastIndexOf(46);
        if (i > 0) {
            prefix = prefix.substring(i + 1);
        }
        if ((i = prefix.lastIndexOf(36)) > 0) {
            prefix = prefix.substring(i + 1);
        }
        for (PropertyOption option2 : os) {
            option2.restore(this.registry);
            String oname = this.translateGUI(prefix + "." + option2.getName());
            if (oname.length() <= 0) continue;
            option2.setName(oname);
        }
        OptionsWidget widget = new OptionsWidget(title, os);
        Object rc = DialogManager.create((String)this.getName(), (JComponent)widget).setOptionType(2).setDialogId("report.optionsfromuser").show();
        if (rc != DialogManager.OK_OPTION) {
            return false;
        }
        widget.stopEditing();
        os.forEach(option -> option.persist(this.registry));
        return true;
    }

    public final boolean getOptionFromUser(String msg, int option) {
        Object result = DialogManager.create((String)this.getName(), (String)msg).setMessageType(3).setOptionType(OPTION_TYPE[option]).setDialogId("report.optionsfromuser").show();
        return result == DialogManager.OK_OPTION || result == DialogManager.YES_OPTION;
    }

    public String translateOption(String key) {
        String optionKey;
        String optionName;
        String result = this.translateGUI(key);
        if (result.equals(key)) {
            Resources parentResources;
            String optionName2;
            String parentPackage = this.getClass().getPackageName();
            int last = parentPackage.lastIndexOf(46);
            if (last >= 0) {
                parentPackage = parentPackage.substring(0, last);
            }
            if (!(optionName2 = (parentResources = Resources.get((String)parentPackage, (Locale)this.OPTIONS.getOutputLocale())).getString(key)).equals(key)) {
                result = optionName2;
            }
        }
        if (result.equals(key) && !(optionName = COMMON_RESOURCES.getString(optionKey = "option." + key)).equals(optionKey)) {
            result = optionName;
        }
        return result;
    }

    public final String translate(String key) {
        return this.translate(key, (Object[])null);
    }

    public final String translateGUI(String key) {
        return this.translateGUI(key, null);
    }

    public final String translate(String key, Object ... values) {
        return this.translate(key, null, values);
    }

    public final String translateGUI(String key, Object ... values) {
        return this.translate(key, Locale.getDefault(), values);
    }

    public final String translate(String key, Locale locale, Object ... values) {
        Resources resources;
        if (locale == null) {
            locale = this.OPTIONS.getOutputLocale();
        }
        if ((resources = this.getResources(locale)) == null) {
            return key;
        }
        return resources.getString(key, values);
    }

    private String getTypeName() {
        String rtype = this.getClass().getName();
        while (rtype.indexOf(46) >= 0) {
            rtype = rtype.substring(rtype.indexOf(46) + 1);
        }
        return rtype;
    }

    public Resources getResources() {
        return this.getResources(this.OPTIONS.getOutputLocale());
    }

    public Resources getResources(Locale locale) {
        Resources resources = this.LOCALE_2_RESOURCES.get(locale);
        if (resources == null) {
            resources = Resources.get(this.getClass(), (Locale)locale);
            this.LOCALE_2_RESOURCES.put(locale, resources);
        }
        return resources;
    }

    public static String getIndent(int level, int spacesPerLevel, String prefix) {
        StringBuilder oneLevel = new StringBuilder();
        while (oneLevel.length() != spacesPerLevel) {
            oneLevel.append(" ");
        }
        StringBuilder buffer = new StringBuilder(256);
        while (--level > 0) {
            buffer.append((CharSequence)oneLevel);
        }
        if (prefix != null) {
            buffer.append(prefix);
        }
        return buffer.toString();
    }

    public final String getIndent(int level) {
        return Report.getIndent(level, this.OPTIONS.getIndentPerLevel(), null);
    }

    public static String align(String txt, int length, int alignment) {
        int i;
        int n = txt.length();
        if (n > length) {
            return txt.substring(0, length);
        }
        n = length - n;
        StringBuilder buffer = new StringBuilder(length);
        int before = switch (alignment) {
            default -> 0;
            case 1 -> (int)((float)n * 0.5f);
            case 2 -> n;
        };
        int after = n - before;
        for (i = 0; i < before; ++i) {
            buffer.append(' ');
        }
        buffer.append(txt);
        for (i = 0; i < after; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String getName() {
        String name = this.translateGUI("name");
        if (name.length() == 0 || name.equals("name")) {
            name = this.getTypeName();
        }
        return name;
    }

    public String getShortName() {
        String name = this.translateGUI("name.short");
        if (name.length() == 0 || name.equals("name.short")) {
            name = this.getName();
        }
        return name;
    }

    public String getAuthor() {
        return this.translateGUI("author");
    }

    public String getVersion() {
        return this.translateGUI("version");
    }

    public String getLastUpdate() {
        Object result = this.translateGUI("updated");
        if ("updated".equals(result)) {
            return null;
        }
        Matcher cvsdata = PATTERN_CVS_DATE.matcher((CharSequence)result);
        if (cvsdata.matches()) {
            try {
                result = new PointInTime(cvsdata.group(1) + cvsdata.group(2) + cvsdata.group(3)) + cvsdata.group(4);
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getInfo() {
        return this.translateGUI("info");
    }

    public int getPosition() {
        String position = this.translateGUI("position");
        if (position.isBlank() || position.equals("position")) {
            position = "0";
        }
        return Integer.parseInt(position);
    }

    public Object start(Object context) throws Throwable {
        try {
            return this.getStartMethod(context).invoke((Object)this, context);
        }
        catch (InvocationTargetException t) {
            throw t.getTargetException();
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public String accepts(Object context) {
        return this.getStartMethod(context) != null ? this.getName() : null;
    }

    Method getStartMethod(Object context) {
        try {
            Method[] methods;
            for (Method method : methods = this.getClass().getDeclaredMethods()) {
                Class<?> param;
                Class<?>[] params;
                if (!method.getName().equals("start") || (params = method.getParameterTypes()).length != 1 || !(param = params[0]).isAssignableFrom(context.getClass())) continue;
                return method;
            }
        }
        catch (SecurityException t) {
            LOG.log(Level.FINEST, "Error with report", t);
        }
        return null;
    }

    public boolean isHidden() {
        return false;
    }

    public List<Entity> getSearchEntities(Gedcom gedcom) {
        return SearchCommunicator.getResultEntities((Gedcom)gedcom);
    }

    public Indi getActiveIndi(Gedcom gedcom) {
        Indi indi;
        Fam f;
        Entity activeEntity = this.getActiveEntity(gedcom);
        if (activeEntity instanceof Fam && (activeEntity = (f = (Fam)activeEntity).getHusband()) == null) {
            activeEntity = f.getWife();
        }
        if (activeEntity instanceof Indi) {
            indi = (Indi)activeEntity;
            return indi;
        }
        indi = gedcom.getDeCujusIndi();
        if (indi == null) {
            indi = (Indi)gedcom.getFirstEntity("INDI");
        }
        return indi;
    }

    public Entity getActiveEntity(Gedcom gedcom) {
        List gedcontexts = GedcomDirectory.getDefault().getContexts();
        for (Context ctx : gedcontexts) {
            if (ctx.getGedcom() != gedcom || ctx.getEntity() == null) continue;
            return ctx.getEntity();
        }
        return null;
    }

    public boolean isEntryId(String id) {
        return false;
    }

    public boolean processAction(String command) {
        return false;
    }

    public static class Category {
        private static final Map<String, Integer> CAT_POSITIONS = new HashMap<String, Integer>();
        private static final ImageIcon DEFAULT_ICON;
        private static final Category DEFAULT_CATEGORY;
        private String name;
        private String displayName;
        private final ImageIcon image;
        private static final TreeMap<String, Category> CATEGORIES;

        public static Comparator<String> getComparator() {
            Comparator comparator = (o1, o2) -> CAT_POSITIONS.get(o1).compareTo(CAT_POSITIONS.get(o2));
            return comparator;
        }

        private Category(String name, ImageIcon image) {
            this.name = name.toLowerCase();
            this.image = image;
            String result = COMMON_RESOURCES.getString("category." + this.name, false);
            if (result != null) {
                this.displayName = result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Category createCategory(String name) {
            ImageIcon image;
            if (name == null) {
                return DEFAULT_CATEGORY;
            }
            String file = "Category" + Category.UcFirst(name) + ".png";
            InputStream in = null;
            try {
                in = Report.class.getResourceAsStream(file);
                image = new ImageIcon(file, in);
            }
            catch (Throwable t) {
                image = DEFAULT_ICON;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return new Category(name, image);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                return this.name;
            }
            return this.displayName;
        }

        public ImageIcon getImage() {
            return this.image == null ? new ImageIcon((Icon)DEFAULT_ICON) : this.image;
        }

        public String getImageResourceName(String name) {
            return "Category" + Category.UcFirst(name) + ".png";
        }

        private static String UcFirst(String s) {
            Object out = s;
            if (s != null && !s.isEmpty()) {
                out = Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
            }
            return out;
        }

        private static Category get(String name) {
            Category category = CATEGORIES.get(name);
            if (category == null) {
                category = Category.createCategory(name);
                CATEGORIES.put(name, category);
            }
            return category;
        }

        static {
            CAT_POSITIONS.put("tree", 10);
            CAT_POSITIONS.put("chart", 20);
            CAT_POSITIONS.put("lineage", 30);
            CAT_POSITIONS.put("list", 40);
            CAT_POSITIONS.put("sheets", 50);
            CAT_POSITIONS.put("statistics", 60);
            CAT_POSITIONS.put("research", 70);
            CAT_POSITIONS.put("analysis", 80);
            CAT_POSITIONS.put("utility", 90);
            DEFAULT_ICON = Images.imgQuestion;
            DEFAULT_CATEGORY = Category.createCategory("Other");
            CATEGORIES = new TreeMap();
            CATEGORIES.put(Category.DEFAULT_CATEGORY.name, DEFAULT_CATEGORY);
        }
    }

    private static class FileExtensionFilter
    extends FileFilter {
        private final String extension;

        public FileExtensionFilter(String extension) {
            this.extension = extension != null ? extension.toLowerCase() : FileChooserBuilder.getHtmlFilter().getExtensions()[0];
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            return this.extension;
        }
    }
}

