/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.gedcom.PropertyFinder;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractPropertyFinder
implements PropertyFinder {
    @Override
    public PropertyFinder or(PropertyFinder finder) {
        return new Or(this, finder);
    }

    @Override
    public PropertyFinder and(PropertyFinder finder) {
        return new And(this, finder);
    }

    @Override
    public PropertyFinder sex(int sex) {
        return new SexPathFinder(this, sex);
    }

    @Override
    public Collection<Entity> find(Collection<Entity> roots) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity indi : roots) {
            result.addAll(this.find(indi));
        }
        return result;
    }

    public static class Or
    extends AbstractPropertyFinder {
        PropertyFinder pf1;
        PropertyFinder pf2;

        Or(PropertyFinder pf1, PropertyFinder pf2) {
            this.pf1 = pf1;
            this.pf2 = pf2;
        }

        @Override
        public Collection<Entity> find(Entity entity) {
            ArrayList<Entity> result = new ArrayList<Entity>();
            result.addAll(this.pf1.find(entity));
            result.addAll(this.pf2.find(entity));
            return result;
        }
    }

    public static class And
    extends AbstractPropertyFinder {
        PropertyFinder pf1;
        PropertyFinder pf2;

        And(PropertyFinder pf1, PropertyFinder pf2) {
            this.pf1 = pf1;
            this.pf2 = pf2;
        }

        @Override
        public Collection<Entity> find(Entity entity) {
            return this.pf2.find(this.pf1.find(entity));
        }
    }

    public static class SexPathFinder
    extends AbstractPropertyFinder {
        PropertyFinder finder;
        int sex;

        SexPathFinder(PropertyFinder finder, int sex) {
            this.finder = finder;
            this.sex = sex;
        }

        @Override
        public Collection<Entity> find(Entity entity) {
            ArrayList<Entity> result = new ArrayList<Entity>();
            for (Entity found : this.finder.find(entity)) {
                if (!(found instanceof Indi) || ((Indi)found).getSex() != this.sex) continue;
                result.add(found);
            }
            return result;
        }
    }

    public static class TagPathFinder
    extends AbstractPropertyFinder {
        Class<? extends Entity> applyOn;
        TagPath path;

        public TagPathFinder(Class<? extends Entity> applyOn, TagPath path) {
            this.applyOn = applyOn;
            this.path = path;
        }

        public TagPathFinder(Class<? extends Entity> applyOn, String path) {
            this.applyOn = applyOn;
            this.path = new TagPath(path);
        }

        @Override
        public Collection<Entity> find(Entity entity) {
            ArrayList<Entity> result = new ArrayList<Entity>();
            if (entity.getClass().isAssignableFrom(this.applyOn)) {
                for (Property p : entity.getProperties(this.path)) {
                    if (entity.equals(p.getEntity())) continue;
                    result.add(p.getEntity());
                }
            }
            return result;
        }
    }
}

