/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisContextAction;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.Resources;
import java.awt.event.ActionEvent;
import org.openide.util.LookupEvent;

public class RunExternal
extends AbstractAncestrisContextAction {
    private PropertyFile pFile;
    private InputSource fi;
    private static final Resources RESOURCES = Resources.get(RunExternal.class);

    public RunExternal() {
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        if (this.lkpInfo != null) {
            this.pFile = null;
            this.fi = null;
            for (Property prop : this.lkpInfo.allInstances()) {
                if (!(prop instanceof PropertyFile)) continue;
                this.pFile = (PropertyFile)prop;
                if (!this.pFile.getInput().isPresent()) continue;
                this.fi = this.pFile.getInput().get();
            }
            super.resultChanged(ev);
        }
    }

    @Override
    protected void contextChanged() {
        super.contextChanged();
        this.setImage(PropertyFile.DEFAULT_IMAGE);
        this.setText(RESOURCES.getString("file.open"));
        this.setTip(RESOURCES.getString("file.open.tip"));
        this.setEnabled(this.pFile != null && this.pFile.isOpenable());
    }

    public RunExternal(InputSource fi) {
        this.fi = fi;
        this.pFile = null;
        super.setImage(PropertyFile.DEFAULT_IMAGE);
        super.setText(RESOURCES.getString("file.open"));
        super.setTip(RESOURCES.getString("file.open.tip"));
        this.setEnabled(this.isAvailable());
    }

    private final boolean isAvailable() {
        if (this.fi == null) {
            return false;
        }
        if (this.fi instanceof FileInput) {
            return ((FileInput)this.fi).getFile().exists();
        }
        return this.fi instanceof URLInput;
    }

    @Override
    public boolean isDefault(Property prop) {
        return prop instanceof PropertyFile;
    }

    @Override
    protected void actionPerformedImpl(ActionEvent event) {
        if (this.pFile != null) {
            this.pFile.openFile();
            return;
        }
        if (this.fi != null) {
            if (this.fi instanceof FileInput) {
                FileAssociation.getDefault().execute(((FileInput)this.fi).getFile().getAbsolutePath());
            } else if (this.fi instanceof URLInput) {
                FileAssociation.getDefault().execute(((URLInput)this.fi).getURL());
            }
        }
    }
}

