/*
 * Decompiled with CFR 0.152.
 */
package ancestris.awt;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

public class FilteredMouseAdapter
extends MouseAdapter
implements ActionListener {
    private static final int CLICK_INTERVAL = FilteredMouseAdapter.click_interval();
    private Timer timer;
    private MouseEvent lastEvent;

    private static int click_interval() {
        Integer result = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        return result == null ? 400 : result;
    }

    public FilteredMouseAdapter() {
        Logger.getLogger("ancestris.util").log(Level.FINER, "doubleclic interval: {0}", CLICK_INTERVAL);
        this.timer = new Timer(CLICK_INTERVAL, this);
        this.timer.setRepeats(false);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.lastEvent = me;
        if (me.getClickCount() == 2) {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.mouseClickedFiltered(me);
        } else {
            this.timer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mouseClickedFiltered(this.lastEvent);
    }

    public void mouseClickedFiltered(MouseEvent me) {
        super.mouseClicked(me);
    }
}

