/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.table;

import ancestris.modules.releve.merge.SelectionManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.FieldSex;
import ancestris.modules.releve.model.FieldSimpleValue;
import ancestris.modules.releve.model.GedcomLink;
import ancestris.modules.releve.table.ReleveTableListener;
import ancestris.modules.releve.table.TableModelRecordAbstract;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openide.util.NbPreferences;

public class ReleveTable
extends JTable {
    private ReleveTableListener releveTableListener = null;
    private final Color selectedRowBackgroundColor;
    private final Color selectedCellBackgroundColor;
    private final Color selectedCellForegroundColor;
    private final Color selectedRowForegroundColor;
    private final List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();

    public ReleveTable() {
        this.selectedCellForegroundColor = new Color(UIManager.getColor("Tree.selectionForeground").getRGB());
        this.selectedCellBackgroundColor = new Color(UIManager.getColor("Tree.selectionBackground").getRGB());
        this.selectedRowForegroundColor = new Color(UIManager.getColor("Tree.foreground").getRGB());
        this.selectedRowBackgroundColor = new Color(UIManager.getColor("Tree.dropLineColor").getRGB());
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setDefaultRenderer(Object.class, new Renderer());
        this.setDefaultRenderer(Integer.class, new Renderer());
        Renderer r = new Renderer();
        r.setFont(this.getFont());
        this.getSelectionModel().setSelectionMode(0);
        this.setFillsViewportHeight(true);
        this.getInputMap(0).remove(KeyStroke.getKeyStroke(40, 192));
        this.getInputMap(0).put(KeyStroke.getKeyStroke(40, 192), "shortCutKeyDown");
        this.getActionMap().put("shortCutKeyDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReleveTable.this.releveTableListener.swapRecordNext();
            }
        });
        this.getInputMap(0).remove(KeyStroke.getKeyStroke(38, 192));
        this.getInputMap(0).put(KeyStroke.getKeyStroke(38, 192), "shortCutKeyUp");
        this.getActionMap().put("shortCutKeyUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReleveTable.this.releveTableListener.swapRecordPrevious();
            }
        });
        this.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.getTableHeader().setDefaultRenderer(new SortableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && ReleveTable.this.getSelectedRowCount() > 0) {
                    int viewColumn = ReleveTable.this.columnModel.getColumnIndexAtX(e.getX());
                    Rectangle cellRect = ReleveTable.this.getCellRect(ReleveTable.this.getSelectedRows()[0], viewColumn, false);
                    if (cellRect != null) {
                        ReleveTable.this.scrollRectToVisible(cellRect);
                    }
                }
            }
        });
    }

    public void setModel(TableModelRecordAbstract tableModel) {
        TableRowSorter<TableModelRecordAbstract> tableRowSorter = new TableRowSorter<TableModelRecordAbstract>(tableModel);
        tableRowSorter.setRowFilter(tableModel.getRecordFilter());
        tableRowSorter.setSortsOnUpdates(true);
        this.setRowSorter(tableRowSorter);
        super.setModel(tableModel);
        this.loadColumnLayout(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GedcomLink gedcomLink;
                JTable target = (JTable)e.getSource();
                int row = target.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                int column = target.columnAtPoint(e.getPoint());
                if (column == 0 && (gedcomLink = (GedcomLink)ReleveTable.this.getModel().getValueAt(ReleveTable.this.convertRowIndexToModel(row), -1)) != null) {
                    Property property = gedcomLink.getProperty();
                    Entity entity = gedcomLink.getEntity();
                    if (entity != null) {
                        if (e.getClickCount() == 2) {
                            SelectionManager.setRootEntity(property);
                        } else {
                            SelectionManager.showEntity(property);
                        }
                    }
                }
            }
        });
    }

    public void componentClosed() {
        this.saveColumnLayout();
    }

    public void dropRecord(AbstractRecord record) {
        ((TableModelRecordAbstract)this.getModel()).addRecord(record);
    }

    public void selectRecord(int recordIndex) {
        int currentRow;
        if (recordIndex != -1 && (currentRow = this.convertRowIndexToView(recordIndex)) != -1) {
            this.repaint();
            currentRow = this.convertRowIndexToView(recordIndex);
            this.setRowSelectionInterval(currentRow, currentRow);
            Rectangle cellRect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
            if (cellRect != null) {
                this.scrollRectToVisible(cellRect);
            }
        }
    }

    public int getSelectedRecordIndex() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            return this.convertRowIndexToModel(selectedRow);
        }
        return -1;
    }

    public void setTableSelectionListener(ReleveTableListener listener) {
        this.releveTableListener = listener;
    }

    public void fireTableSelectionListener(int recordIndex, boolean isNewRecord) {
        if (this.releveTableListener != null) {
            this.releveTableListener.tableRecordSelected(recordIndex, isNewRecord);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.releveTableListener.verifyCurrentRecord()) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            if (!toggle && !extend) {
                final int recordIndex = this.convertRowIndexToModel(rowIndex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReleveTable.this.fireTableSelectionListener(recordIndex, false);
                    }
                });
            }
        }
    }

    public void loadColumnLayout(boolean forceRecalc) {
        Object columnLayout = NbPreferences.forModule(ReleveTable.class).get(((TableModelRecordAbstract)this.getModel()).getModelName() + "ColumnLayout", "");
        TableColumnModel columns = this.getColumnModel();
        if (((String)columnLayout).isEmpty() || forceRecalc) {
            columnLayout = "";
            columnLayout = (String)columnLayout + columns.getColumnCount();
            for (int col = 0; col < columns.getColumnCount(); ++col) {
                TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
                Component comp = headerRenderer.getTableCellRendererComponent(this, columns.getColumn(col).getHeaderValue(), false, false, -1, col);
                int width = Math.max(comp.getPreferredSize().width + 10, 10);
                for (int row = 0; row < this.getRowCount(); ++row) {
                    TableCellRenderer renderer = this.getCellRenderer(row, col);
                    comp = this.prepareRenderer(renderer, row, col);
                    width = Math.max(comp.getPreferredSize().width + 1, width);
                }
                columnLayout = (String)columnLayout + "," + width;
            }
        }
        StringTokenizer tokens = new StringTokenizer((String)columnLayout, ",");
        int n = Integer.parseInt(tokens.nextToken());
        for (int i = 0; i < n && i < columns.getColumnCount(); ++i) {
            TableColumn col = columns.getColumn(i);
            int w = Integer.parseInt(tokens.nextToken());
            this.getTableHeader().setResizingColumn(col);
            col.setWidth(w);
            col.setPreferredWidth(w);
        }
        if (forceRecalc) {
            NbPreferences.forModule(ReleveTable.class).put(((TableModelRecordAbstract)this.getModel()).getModelName() + "ColumnLayout", (String)columnLayout);
        }
    }

    public void saveColumnLayout() {
        TableColumnModel columns = this.getColumnModel();
        String columnLayout = "" + columns.getColumnCount();
        for (int c = 0; c < columns.getColumnCount(); ++c) {
            columnLayout = columnLayout + "," + columns.getColumn(c).getWidth();
        }
        NbPreferences.forModule(ReleveTable.class).put(((TableModelRecordAbstract)this.getModel()).getModelName() + "ColumnLayout", columnLayout);
    }

    public void setSortingStatus(int column, SortOrder sortOrder) {
        RowSorter.SortKey directive = this.getSortKey(column);
        if (directive != null) {
            this.sortKeys.remove(directive);
        }
        if (sortOrder != SortOrder.UNSORTED) {
            this.sortKeys.add(new RowSorter.SortKey(column, sortOrder));
        }
        this.sortingStatusChanged();
    }

    public void cancelSorting() {
        this.sortKeys.clear();
        this.sortingStatusChanged();
    }

    private void sortingStatusChanged() {
        this.getRowSorter().setSortKeys(this.sortKeys);
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    private RowSorter.SortKey getSortKey(int column) {
        for (int i = 0; i < this.sortKeys.size(); ++i) {
            RowSorter.SortKey sortKey = this.sortKeys.get(i);
            if (sortKey.getColumn() != column) continue;
            return sortKey;
        }
        return null;
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        RowSorter.SortKey sortKey = this.getSortKey(column);
        if (sortKey == null) {
            return null;
        }
        return new Arrow(sortKey.getSortOrder() == SortOrder.DESCENDING, size, this.sortKeys.indexOf(sortKey));
    }

    private class Renderer
    extends DefaultTreeCellRenderer
    implements TableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
            GedcomLink gedcomLink;
            this.setFont(table.getFont());
            if (value != null) {
                if (value instanceof FieldDate) {
                    this.setText(((FieldDate)value).getDisplayValue());
                    this.setHorizontalAlignment(4);
                } else if (value instanceof FieldSex) {
                    this.setText(((FieldSex)value).toString());
                    this.setHorizontalAlignment(0);
                } else if (value instanceof FieldSimpleValue) {
                    this.setText(((FieldSimpleValue)value).toString());
                    this.setHorizontalAlignment(2);
                } else {
                    this.setText(value.toString());
                    this.setHorizontalAlignment(2);
                }
            } else {
                this.setText("");
                this.setHorizontalAlignment(2);
            }
            boolean gedcomLinked = false;
            if (col == 0 && (gedcomLink = (GedcomLink)table.getModel().getValueAt(table.convertRowIndexToModel(row), -1)) != null) {
                gedcomLinked = true;
            }
            if (selected) {
                if (gedcomLinked) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(Color.MAGENTA);
                    this.setOpaque(true);
                } else {
                    this.setBackground(ReleveTable.this.selectedRowBackgroundColor);
                    this.setForeground(ReleveTable.this.selectedRowForegroundColor);
                    this.setOpaque(true);
                }
            } else if (gedcomLinked) {
                this.setForeground(table.getForeground());
                this.setBackground(Color.PINK);
                this.setOpaque(true);
            } else {
                this.setForeground(table.getForeground());
                this.setOpaque(false);
            }
            return this;
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SortOrder sortOrder;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn < 0) {
                return;
            }
            int column = columnModel.getColumn(viewColumn).getModelIndex();
            if (column < 0) {
                return;
            }
            RowSorter.SortKey sortKey = ReleveTable.this.getSortKey(column);
            if (!e.isControlDown()) {
                ReleveTable.this.sortKeys.clear();
            }
            if (sortKey != null) {
                sortOrder = sortKey.getSortOrder();
                if (e.isShiftDown()) {
                    if (null == sortOrder) {
                        sortOrder = SortOrder.UNSORTED;
                    } else {
                        switch (sortOrder) {
                            case UNSORTED: {
                                sortOrder = SortOrder.ASCENDING;
                                break;
                            }
                            case ASCENDING: {
                                sortOrder = SortOrder.DESCENDING;
                                break;
                            }
                            default: {
                                sortOrder = SortOrder.UNSORTED;
                                break;
                            }
                        }
                    }
                } else {
                    sortOrder = sortOrder == SortOrder.DESCENDING ? SortOrder.ASCENDING : SortOrder.DESCENDING;
                }
            } else {
                sortOrder = SortOrder.ASCENDING;
            }
            ReleveTable.this.setSortingStatus(column, sortOrder);
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                if (value instanceof ImageIcon) {
                    l.setIcon((Icon)((ImageIcon)value));
                    l.setText(null);
                    l.setHorizontalAlignment(0);
                } else {
                    l.setIcon(null);
                    l.setText(value.toString());
                    l.setHorizontalAlignment(2);
                }
                int modelColumn = table.convertColumnIndexToModel(column);
                Icon indicator = ReleveTable.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize());
                if (indicator != null) {
                    l.setHorizontalTextPosition(2);
                    l.setIcon(indicator);
                }
            }
            return c;
        }
    }

    private static class Arrow
    implements Icon {
        private final boolean descending;
        private final int size;
        private final int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)(Math.pow(0.8, this.priority) * (double)this.size / 2.0);
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

