/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.swing.UndoTextPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class TextPanel
extends JPanel {
    private final StyledDocument doc;
    private final Style style;
    private int fontSize = 12;
    private JButton growFont;
    private JTextPane noteText;
    private JScrollPane scrollPane;
    private JButton shrinkFont;
    private JPanel textPanel;

    public TextPanel(String text) {
        this.initComponents();
        this.noteText.setText(text);
        this.doc = (StyledDocument)this.noteText.getDocument();
        this.style = this.doc.addStyle("StyleName", null);
    }

    private void redisplayText() {
        String selText = this.noteText.getSelectedText();
        int start = this.noteText.getSelectionStart();
        int end = this.noteText.getSelectionEnd();
        String tmpText = this.noteText.getText();
        StyleConstants.setFontSize(this.style, this.fontSize);
        try {
            this.doc.remove(0, tmpText.length());
            this.doc.insertString(0, tmpText, this.style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.noteText.setSelectionStart(start);
        this.noteText.setSelectionEnd(end);
        this.noteText.scrollToReference(selText != null ? selText : tmpText.substring(start, start));
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                TextPanel.this.noteText.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.growFont = new JButton();
        this.shrinkFont = new JButton();
        this.textPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.noteText = new UndoTextPane();
        this.setPreferredSize(new Dimension(500, 400));
        this.growFont.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Growfont.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.growFont, (String)NbBundle.getMessage(TextPanel.class, (String)"TextPanel.growFont.text"));
        this.growFont.setPreferredSize(new Dimension(32, 32));
        this.growFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.growFontActionPerformed(evt);
            }
        });
        this.shrinkFont.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Shrinkfont.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.shrinkFont, (String)NbBundle.getMessage(TextPanel.class, (String)"TextPanel.shrinkFont.text"));
        this.shrinkFont.setPreferredSize(new Dimension(32, 32));
        this.shrinkFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.shrinkFontActionPerformed(evt);
            }
        });
        this.textPanel.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setViewportView(this.noteText);
        GroupLayout textPanelLayout = new GroupLayout(this.textPanel);
        this.textPanel.setLayout(textPanelLayout);
        textPanelLayout.setHorizontalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 484, Short.MAX_VALUE));
        textPanelLayout.setVerticalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, textPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane, -1, 346, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.growFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shrinkFont, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.growFont, -2, -1, -2).addComponent(this.shrinkFont, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void growFontActionPerformed(ActionEvent evt) {
        ++this.fontSize;
        this.redisplayText();
    }

    private void shrinkFontActionPerformed(ActionEvent evt) {
        --this.fontSize;
        this.redisplayText();
    }

    public void setText(String text) {
        this.noteText.setText(text);
        this.noteText.setCaretPosition(0);
        this.redisplayText();
    }

    public String getText() {
        return this.noteText.getText();
    }
}

