/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.util.TimingUtility;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.TagPath;
import java.io.IOException;

public class ImportElie
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importelie_name();
    }

    protected String getImportComment() {
        return Bundle.importelie_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void init() {
        super.init();
        this.invalidPaths.add("INDI:_CRE:DATE");
        this.invalidPaths.add("INDI:_GED:DATE");
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        TimingUtility.getInstance().reset();
        if ("HEAD:GEDC:VERS".equalsIgnoreCase(pathBefore)) {
            String valueAfter = this.GEDCOM_VERSION;
            if (!valueBefore.equals(valueAfter)) {
                this.output.writeLine(2, "VERS", this.GEDCOM_VERSION);
                this.fixes.add(new ImportFix(this.currentXref, "header.Version", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            return false;
        }
        if (path.toString().contains("DATE:TIME") && !path.toString().contains("CHAN") && !this.currentXref.equals("HEAD")) {
            this.output.writeLine(this.input.getLevel() - 1, "_TIME", this.input.getValue());
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getParent().getShortName() + ":_TIME", valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.processEntities(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        Property prop = null;
        Property file = null;
        Property titl = null;
        for (Entity entity : gedcom.getEntities("OBJE")) {
            Note note;
            String valueBefore;
            Entity target;
            prop = entity.getProperty("NOTE", false);
            if (prop == null || !(prop instanceof PropertyNote) || (target = (Entity)((PropertyNote)prop).getTargetEntity().orElse(null)) == null || (valueBefore = (note = (Note)target).getValue()).isEmpty() || (file = entity.getProperty("FILE", false)) == null || (titl = file.getProperty("TITL", false)) != null) continue;
            String pathBefore = prop.getPath(true).getShortName();
            titl = file.addProperty("TITL", valueBefore);
            String pathAfter = titl.getPath(true).getShortName();
            entity.delProperty(prop);
            this.fixes.add(new ImportFix(entity.getId(), "invalidFileStructure.1", pathBefore, pathAfter, valueBefore, valueBefore));
            hasErrors = true;
        }
        return hasErrors;
    }
}

