/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;

public abstract class GraphicElement
extends AbstractElement {
    private static final Logger logger = Logger.getLogger(GraphicElement.class.getSimpleName());
    protected GraphicGraph mygraph;
    public String label;
    public StyleGroup style;
    public Object component;
    public boolean hidden = false;
    protected static Pattern acceptedAttribute = Pattern.compile("(ui[.].*)|(layout[.].*)|x|y|z|xy|xyz|label|stylesheet");

    public GraphicElement(String id, GraphicGraph graph) {
        super(id);
        this.mygraph = graph;
    }

    public GraphicGraph myGraph() {
        return this.mygraph;
    }

    public abstract Selector.Type getSelectorType();

    public StyleGroup getStyle() {
        return this.style;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public Object getComponent() {
        return this.component;
    }

    protected abstract void removed();

    public abstract void move(double var1, double var3, double var5);

    public void setComponent(Object component) {
        this.component = component;
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        if (event == AbstractElement.AttributeChangeEvent.ADD || event == AbstractElement.AttributeChangeEvent.CHANGE) {
            if (attribute.charAt(0) == 'u' && attribute.charAt(1) == 'i') {
                if (attribute.equals("ui.class")) {
                    this.mygraph.styleGroups.checkElementStyleGroup(this);
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.label")) {
                    this.label = StyleConstants.convertLabel(newValue);
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.style")) {
                    if (newValue instanceof String) {
                        try {
                            this.mygraph.styleSheet.parseStyleFromString(new Selector(this.getSelectorType(), this.getId(), null), (String)newValue);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, String.format("Error while parsing style for %S '%s' :", new Object[]{this.getSelectorType(), this.getId()}), e);
                        }
                        this.mygraph.graphChanged = true;
                    } else {
                        logger.warning("Unknown value for style [" + newValue + "].");
                    }
                } else if (attribute.equals("ui.hide")) {
                    this.hidden = true;
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.clicked")) {
                    this.style.pushEventFor(this, "clicked");
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.selected")) {
                    this.style.pushEventFor(this, "selected");
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.color")) {
                    this.style.pushElementAsDynamic(this);
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.size")) {
                    this.style.pushElementAsDynamic(this);
                    this.mygraph.graphChanged = true;
                } else if (attribute.equals("ui.icon")) {
                    this.mygraph.graphChanged = true;
                }
            } else if (attribute.equals("label")) {
                this.label = StyleConstants.convertLabel(newValue);
                this.mygraph.graphChanged = true;
            }
        } else if (attribute.charAt(0) == 'u' && attribute.charAt(1) == 'i') {
            if (attribute.equals("ui.class")) {
                Object o = this.attributes.remove("ui.class");
                this.mygraph.styleGroups.checkElementStyleGroup(this);
                this.attributes.put("ui.class", o);
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.label")) {
                this.label = "";
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.hide")) {
                this.hidden = false;
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.clicked")) {
                this.style.popEventFor(this, "clicked");
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.selected")) {
                this.style.popEventFor(this, "selected");
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.color")) {
                this.style.popElementAsDynamic(this);
                this.mygraph.graphChanged = true;
            } else if (attribute.equals("ui.size")) {
                this.style.popElementAsDynamic(this);
                this.mygraph.graphChanged = true;
            }
        } else if (attribute.equals("label")) {
            this.label = "";
            this.mygraph.graphChanged = true;
        }
    }

    @Override
    public void setAttribute(String attribute, Object ... values) {
        Matcher matcher = acceptedAttribute.matcher(attribute);
        if (matcher.matches()) {
            super.setAttribute(attribute, values);
        }
    }

    public static interface SwingElementRenderer {
    }
}

