/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFMeta
implements GEXFElement {
    String creator;
    String keywords;
    String description;

    public GEXFMeta() {
        this.creator = "GraphStream using " + this.getClass().getName();
        this.keywords = "";
        this.description = "";
    }

    public GEXFMeta(String creator, String keywords, String description) {
        this.creator = creator;
        this.keywords = keywords;
        this.description = description;
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        stream.startElement("meta");
        stream.stream.writeAttribute("lastmodifieddate", df.format(date));
        stream.leafWithText("creator", this.creator);
        stream.leafWithText("keywords", this.keywords);
        stream.leafWithText("description", this.description);
        stream.endElement();
    }
}

