/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.ActionOpen;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.gedcom.RecentFiles;
import genj.gedcom.Gedcom;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ActionOpenRecent
extends AbstractAncestrisAction
implements Presenter.Menu,
ChangeListener,
PropertyChangeListener {
    private JMenu menu;
    private boolean recreate = true;

    public ActionOpenRecent() {
        this.setImage("ancestris/view/images/OpenRecent.png");
        this.setTip(NbBundle.getMessage(ActionOpenRecent.class, (String)"HINT_ActionOpenRecent"));
        this.setText(NbBundle.getMessage(ActionOpenRecent.class, (String)"CTL_ActionOpenRecent"));
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new UpdatingMenu((Action)((Object)this));
            this.menu.getModel().addChangeListener(this);
            this.fillSubMenu();
            RecentFiles.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.menu;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if ("RecentFiletInformation".equals(pce.getPropertyName())) {
            this.recreate = true;
            this.fillSubMenu();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.menu.getModel().isSelected()) {
            this.fillSubMenu();
        }
    }

    private void fillSubMenu() {
        List files = RecentFiles.getDefault().getAll();
        if (this.recreate && !files.isEmpty()) {
            this.menu.removeAll();
            for (FileObject fo : files) {
                try {
                    JMenuItem jmi = this.newSubMenuItem(fo);
                    jmi.setIcon((Icon)Gedcom.getImage());
                    this.menu.add(jmi);
                }
                catch (Exception ex) {}
            }
            this.menu.addSeparator();
            AbstractAction emptyListAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RecentFiles.getDefault().clearList();
                }
            };
            JMenuItem jmi = new JMenuItem(emptyListAction){

                @Override
                public void menuSelectionChanged(boolean isIncluded) {
                    super.menuSelectionChanged(isIncluded);
                }
            };
            jmi.setIcon((Icon)new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcom/history/ClearHistoryIcon.png", (boolean)true)));
            jmi.setText(NbBundle.getMessage(ActionOpenRecent.class, (String)"ClearRecentList.text"));
            this.menu.add(jmi);
            this.recreate = false;
        }
    }

    private JMenuItem newSubMenuItem(FileObject fo) {
        final String path = fo.getPath();
        JMenuItem jmi = new JMenuItem((Action)((Object)new ActionOpen(fo))){

            @Override
            public void menuSelectionChanged(boolean isIncluded) {
                super.menuSelectionChanged(isIncluded);
                if (isIncluded) {
                    StatusDisplayer.getDefault().setStatusText(path);
                }
            }
        };
        return jmi;
    }

    private class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] content;

        public UpdatingMenu(Action action) {
            super(action);
            this.content = new JComponent[]{this};
        }

        public JComponent[] getMenuPresenters() {
            return this.content;
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        @Override
        public boolean isEnabled() {
            return !RecentFiles.getDefault().getAll().isEmpty();
        }
    }
}

