/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedcomstatistics;

import ancestris.reports.gedcomstatistics.ReportGenealogyStatistics;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;
import genj.util.ReferenceSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FamStat {
    private final ReferenceSet<Integer, Property> children = new ReferenceSet();
    private final SpouseStat husbandStat = new SpouseStat();
    private final SpouseStat wifeStat = new SpouseStat();
    private int totalFamilies = 0;

    public void increment(Fam fam) {
        Indi wife;
        int nbChildren = fam.getNoOfChildren();
        this.children.add((Object)nbChildren, (Object)fam);
        ++this.totalFamilies;
        Indi husb = fam.getHusband();
        if (husb != null) {
            this.husbandStat.increment(fam, husb);
        }
        if ((wife = fam.getWife()) != null) {
            this.wifeStat.increment(fam, wife);
        }
    }

    public String[][] getSpouseTable(ReportGenealogyStatistics report) {
        this.husbandStat.calculate();
        this.wifeStat.calculate();
        String[][] table = new String[6][5];
        table[0][0] = "ageAtMarriage";
        table[0][1] = Gedcom.getName((String)"HUSB");
        table[0][2] = Gedcom.getName((String)"WIFE");
        table[0][3] = "";
        table[0][4] = "";
        table[1][0] = "minAge";
        table[1][1] = this.husbandStat.minAgeDelta.toReportString();
        table[1][2] = this.wifeStat.minAgeDelta.toReportString();
        table[1][3] = "";
        table[1][4] = "";
        table[2][0] = "minAgeNb";
        table[2][1] = String.valueOf(this.husbandStat.counterMinAge);
        table[2][2] = String.valueOf(this.wifeStat.counterMinAge);
        table[2][3] = report.getLinkId(this.husbandStat.minAgeSet);
        table[2][4] = report.getLinkId(this.wifeStat.minAgeSet);
        table[3][0] = "averageAge";
        table[3][1] = this.husbandStat.avgAgeDelta.toReportString();
        table[3][2] = this.wifeStat.avgAgeDelta.toReportString();
        table[3][3] = "";
        table[3][4] = "";
        table[4][0] = "maxAge";
        table[4][1] = this.husbandStat.maxAgeDelta.toReportString();
        table[4][2] = this.wifeStat.maxAgeDelta.toReportString();
        table[4][3] = "";
        table[4][4] = "";
        table[5][0] = "maxAgeNb";
        table[5][1] = String.valueOf(this.husbandStat.counterMaxAge);
        table[5][2] = String.valueOf(this.wifeStat.counterMaxAge);
        table[5][3] = report.getLinkId(this.husbandStat.maxAgeSet);
        table[5][4] = report.getLinkId(this.wifeStat.maxAgeSet);
        return table;
    }

    public String[][] getChildrenTable(ReportGenealogyStatistics report) {
        if (this.children.getKeys().isEmpty()) {
            return null;
        }
        String[][] table = new String[this.children.getKeys().size() + 2][4];
        table[0][0] = "nbChildren";
        table[0][1] = "nbChildFams";
        table[0][2] = "percentage";
        table[0][3] = "";
        int row = 1;
        List keys = this.children.getKeys();
        Collections.sort(keys);
        for (Integer key : keys) {
            table[row][0] = String.valueOf(key);
            table[row][1] = String.valueOf(this.children.getReferences((Object)key).size());
            table[row][2] = String.valueOf((double)(10000 * this.children.getReferences((Object)key).size() / this.totalFamilies) / 100.0) + "%";
            table[row][3] = report.getLinkId(this.children.getReferences((Object)key));
            ++row;
        }
        table[row][0] = "totals";
        table[row][1] = String.valueOf(this.totalFamilies);
        table[row][2] = "100%";
        table[row][3] = "";
        return table;
    }

    private class SpouseStat {
        public Delta minAgeDelta = new Delta(0, 0, 0);
        public Delta maxAgeDelta = new Delta(0, 0, 0);
        public Delta avgAgeDelta = new Delta(0, 0, 0);
        private final ReferenceSet<Integer, Property> agesAtMarriage = new ReferenceSet();
        private int counter = 0;
        public int counterMinAge = 0;
        public int counterMaxAge = 0;
        public Set<Property> minAgeSet = new HashSet<Property>();
        public Set<Property> maxAgeSet = new HashSet<Property>();
        public long sumAgeDays = 0L;
        public int minAgeDays = Integer.MAX_VALUE;
        public int maxAgeDays = Integer.MIN_VALUE;

        private SpouseStat() {
        }

        private void increment(Fam fam, Indi indi) {
            Delta ageDelta;
            PropertyDate pDate = fam.getMarriageDate();
            Delta delta = ageDelta = pDate != null ? indi.getAge(pDate.getStart()) : null;
            if (ageDelta != null) {
                ++this.counter;
                int ageNum = this.delta2days(ageDelta);
                this.sumAgeDays += (long)ageNum;
                if (ageNum < this.minAgeDays) {
                    this.minAgeDays = ageNum;
                    this.minAgeDelta = ageDelta;
                }
                if (ageNum > this.maxAgeDays) {
                    this.maxAgeDays = ageNum;
                    this.maxAgeDelta = ageDelta;
                }
                this.agesAtMarriage.add((Object)ageNum, (Object)indi);
            }
        }

        private void calculate() {
            this.avgAgeDelta = this.counter == 0 ? new Delta(0, 0, 0) : this.days2Delta((int)(this.sumAgeDays / (long)this.counter));
            List keys = this.agesAtMarriage.getKeys();
            if (!keys.isEmpty()) {
                Collections.sort(keys);
                this.minAgeSet = this.agesAtMarriage.getReferences((Object)((Integer)keys.get(0)));
                this.counterMinAge = this.minAgeSet.size();
                this.maxAgeSet = this.agesAtMarriage.getReferences((Object)((Integer)keys.get(keys.size() - 1)));
                this.counterMaxAge = this.maxAgeSet.size();
            }
        }

        private int delta2days(Delta age) {
            return age.getYears() * 360 + age.getMonths() * 30 + age.getDays();
        }

        private Delta days2Delta(int age) {
            int years = age / 360;
            int months = (age %= 360) / 30;
            int days = age % 30;
            return new Delta(days, months, years);
        }
    }
}

