/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;

public class HebrewCalendar
extends Calendar {
    private static final String[] MONTHS = new String[]{"TSH", "CSH", "KSL", "TVT", "SHV", "ADR", "ADS", "NSN", "IYR", "SVN", "TMZ", "AAV", "ELL"};
    private static final String[] WEEKDAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAB"};
    private static final int HALAKIM_PER_HOUR = 1080;
    private static final int HALAKIM_PER_DAY = 25920;
    private static final int HALAKIM_PER_LUNAR_CYCLE = 765433;
    private static final int HALAKIM_PER_METONIC_CYCLE = 179876755;
    private static final int SDN_OFFSET = 347997;
    private static final int NEW_MOON_OF_CREATION = 31524;
    private static final int SUNDAY = 0;
    private static final int MONDAY = 1;
    private static final int TUESDAY = 2;
    private static final int WEDNESDAY = 3;
    private static final int THURSDAY = 4;
    private static final int FRIDAY = 5;
    private static final int SATURDAY = 6;
    private static final int NOON = 19440;
    private static final int AM3_11_20 = 9924;
    private static final int AM9_32_43 = 16789;
    private static int[] monthsPerYear = new int[]{12, 12, 13, 12, 12, 13, 12, 13, 12, 12, 13, 12, 12, 13, 12, 12, 13, 12, 13};
    private static int[] yearOffset = new int[]{0, 12, 24, 37, 49, 61, 74, 86, 99, 111, 123, 136, 148, 160, 173, 185, 197, 210, 222};

    protected HebrewCalendar() {
        super("@#DHEBREW@", "HEBREW", "hebrew", "images/Hebrew", MONTHS, WEEKDAYS);
    }

    @Override
    protected PointInTime toPointInTime(int julianDay) throws GedcomException {
        if (julianDay <= 347997) {
            throw new GedcomException(resources.getString("hebrew.bef"));
        }
        return this.SdnToJewish(julianDay);
    }

    @Override
    protected int toJulianDay(int day, int month, int year) throws GedcomException {
        if (year < 1) {
            throw new GedcomException(resources.getString("hebrew.one"));
        }
        return this.JewishToSdn(year, month + 1, day + 1);
    }

    @Override
    public int getDays(int month, int year) {
        switch (month) {
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                return 29;
            }
            case 1: {
                if (this.getDays(year) % 10 == 5) break;
                return 29;
            }
            case 2: {
                if (this.getDays(year) % 10 != 3) break;
                return 29;
            }
        }
        return 30;
    }

    private int getDays(int year) {
        try {
            return this.toJulianDay(1, 1, year + 1) - this.toJulianDay(1, 1, year);
        }
        catch (Throwable t) {
            throw new RuntimeException();
        }
    }

    private PointInTime wrap(int day, int month, int year) {
        return new PointInTime(day - 1, month - 1, year, this);
    }

    private int getTishri1(int metonicYear, Molad molad) {
        boolean lastWasLeapYear;
        int tishri1 = molad.day;
        int dow = tishri1 % 7;
        boolean leapYear = metonicYear == 2 || metonicYear == 5 || metonicYear == 7 || metonicYear == 10 || metonicYear == 13 || metonicYear == 16 || metonicYear == 18;
        boolean bl = lastWasLeapYear = metonicYear == 3 || metonicYear == 6 || metonicYear == 8 || metonicYear == 11 || metonicYear == 14 || metonicYear == 17 || metonicYear == 0;
        if (molad.halakim >= 19440 || !leapYear && dow == 2 && molad.halakim >= 9924 || lastWasLeapYear && dow == 1 && molad.halakim >= 16789) {
            ++tishri1;
            if (++dow == 7) {
                dow = 0;
            }
        }
        if (dow == 3 || dow == 5 || dow == 0) {
            ++tishri1;
        }
        return tishri1;
    }

    private void getMoladOfMetonicCycle(int metonicCycle, Molad molad) {
        int r1 = 31524;
        int r2 = (r1 += metonicCycle * 45971) >> 16;
        int d2 = (r2 += metonicCycle * 2744) / 25920;
        r1 = (r2 -= d2 * 25920) << 16 | r1 & 0xFFFF;
        int d1 = r1 / 25920;
        molad.day = d2 << 16 | d1;
        molad.halakim = r1 -= d1 * 25920;
    }

    private void FindTishriMolad(int inputDay, Metonic metonic, Molad molad) {
        int metonicYear;
        int metonicCycle = (inputDay + 310) / 6940;
        this.getMoladOfMetonicCycle(metonicCycle, molad);
        while (molad.day < inputDay - 6940 + 310) {
            ++metonicCycle;
            molad.halakim += 179876755;
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
        }
        for (metonicYear = 0; metonicYear < 18 && molad.day <= inputDay - 74; ++metonicYear) {
            molad.halakim += 765433 * monthsPerYear[metonicYear];
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
        }
        metonic.cycle = metonicCycle;
        metonic.year = metonicYear;
    }

    private int FindStartOfYear(int year, Metonic metonic, Molad molad) {
        metonic.cycle = (year - 1) / 19;
        metonic.year = (year - 1) % 19;
        this.getMoladOfMetonicCycle(metonic.cycle, molad);
        molad.halakim += 765433 * yearOffset[metonic.year];
        molad.day += molad.halakim / 25920;
        molad.halakim %= 25920;
        return this.getTishri1(metonic.year, molad);
    }

    private PointInTime SdnToJewish(int sdn) {
        int day;
        int month;
        int tishri1After;
        int year;
        Molad molad = new Molad();
        Metonic metonic = new Metonic();
        if (sdn <= 347997) {
            return null;
        }
        int inputDay = sdn - 347997;
        this.FindTishriMolad(inputDay, metonic, molad);
        int tishri1 = this.getTishri1(metonic.year, molad);
        if (inputDay >= tishri1) {
            year = metonic.cycle * 19 + metonic.year + 1;
            if (inputDay < tishri1 + 59) {
                int day2;
                int month2;
                if (inputDay < tishri1 + 30) {
                    month2 = 1;
                    day2 = inputDay - tishri1 + 1;
                } else {
                    month2 = 2;
                    day2 = inputDay - tishri1 - 29;
                }
                return this.wrap(day2, month2, year);
            }
            molad.halakim += 765433 * monthsPerYear[metonic.year];
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
            tishri1After = this.getTishri1((metonic.year + 1) % 19, molad);
        } else {
            year = metonic.cycle * 19 + metonic.year;
            if (inputDay >= tishri1 - 177) {
                int day3;
                int month3;
                if (inputDay > tishri1 - 30) {
                    month3 = 13;
                    day3 = inputDay - tishri1 + 30;
                } else if (inputDay > tishri1 - 60) {
                    month3 = 12;
                    day3 = inputDay - tishri1 + 60;
                } else if (inputDay > tishri1 - 89) {
                    month3 = 11;
                    day3 = inputDay - tishri1 + 89;
                } else if (inputDay > tishri1 - 119) {
                    month3 = 10;
                    day3 = inputDay - tishri1 + 119;
                } else if (inputDay > tishri1 - 148) {
                    month3 = 9;
                    day3 = inputDay - tishri1 + 148;
                } else {
                    month3 = 8;
                    day3 = inputDay - tishri1 + 178;
                }
                return this.wrap(day3, month3, year);
            }
            if (monthsPerYear[(year - 1) % 19] == 13) {
                month = 7;
                day = inputDay - tishri1 + 207;
                if (day > 0) {
                    return this.wrap(day, month, year);
                }
                --month;
                if ((day += 30) > 0) {
                    return this.wrap(day, month, year);
                }
                --month;
                day += 30;
            } else {
                month = 6;
                day = inputDay - tishri1 + 207;
                if (day > 0) {
                    return this.wrap(day, month, year);
                }
                --month;
                day += 30;
            }
            if (day > 0) {
                return this.wrap(day, month, year);
            }
            --month;
            if ((day += 29) > 0) {
                return this.wrap(day, month, year);
            }
            tishri1After = tishri1;
            this.FindTishriMolad(molad.day - 365, metonic, molad);
            tishri1 = this.getTishri1(metonic.year, molad);
        }
        int yearLength = tishri1After - tishri1;
        day = inputDay - tishri1 - 29;
        if (yearLength == 355 || yearLength == 385) {
            if (day <= 30) {
                month = 2;
                return this.wrap(day, month, year);
            }
            day -= 30;
        } else {
            if (day <= 29) {
                month = 2;
                return this.wrap(day, month, year);
            }
            day -= 29;
        }
        month = 3;
        return this.wrap(day, month, year);
    }

    private int JewishToSdn(int year, int month, int day) {
        int sdn;
        Molad molad = new Molad();
        Metonic metonic = new Metonic();
        if (year <= 0 || day <= 0 || day > 30) {
            return 0;
        }
        block0 : switch (month) {
            case 1: 
            case 2: {
                int tishri1 = this.FindStartOfYear(year, metonic, molad);
                if (month == 1) {
                    sdn = tishri1 + day - 1;
                    break;
                }
                sdn = tishri1 + day + 29;
                break;
            }
            case 3: {
                int tishri1 = this.FindStartOfYear(year, metonic, molad);
                molad.halakim += 765433 * monthsPerYear[metonic.year];
                molad.day += molad.halakim / 25920;
                molad.halakim %= 25920;
                int tishri1After = this.getTishri1((metonic.year + 1) % 19, molad);
                int yearLength = tishri1After - tishri1;
                if (yearLength == 355 || yearLength == 385) {
                    sdn = tishri1 + day + 59;
                    break;
                }
                sdn = tishri1 + day + 58;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                int tishri1After = this.FindStartOfYear(year + 1, metonic, molad);
                int lengthOfAdarIAndII = monthsPerYear[(year - 1) % 19] == 12 ? 29 : 59;
                if (month == 4) {
                    sdn = tishri1After + day - lengthOfAdarIAndII - 237;
                    break;
                }
                if (month == 5) {
                    sdn = tishri1After + day - lengthOfAdarIAndII - 208;
                    break;
                }
                sdn = tishri1After + day - lengthOfAdarIAndII - 178;
                break;
            }
            default: {
                int tishri1After = this.FindStartOfYear(year + 1, metonic, molad);
                switch (month) {
                    case 7: {
                        sdn = tishri1After + day - 207;
                        break block0;
                    }
                    case 8: {
                        sdn = tishri1After + day - 178;
                        break block0;
                    }
                    case 9: {
                        sdn = tishri1After + day - 148;
                        break block0;
                    }
                    case 10: {
                        sdn = tishri1After + day - 119;
                        break block0;
                    }
                    case 11: {
                        sdn = tishri1After + day - 89;
                        break block0;
                    }
                    case 12: {
                        sdn = tishri1After + day - 60;
                        break block0;
                    }
                    case 13: {
                        sdn = tishri1After + day - 30;
                        break block0;
                    }
                }
                return 0;
            }
        }
        return sdn + 347997;
    }

    private class Molad {
        int day;
        int halakim;

        private Molad() {
        }
    }

    private class Metonic {
        int cycle;
        int year;

        private Metonic() {
        }
    }
}

