/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;

final class OrthogonalSearchRouterRegion
extends Rectangle {
    public static final int MIN_INT_REGION = -20000;
    public static final int MAX_INT_REGION = 20000;
    private Anchor.Direction direction;
    private boolean horizontal;
    private int depth;

    public OrthogonalSearchRouterRegion(int x, int y, int width, int height, Anchor.Direction direction, int depth) {
        super(x, y, width, height);
        this.direction = direction;
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                this.horizontal = true;
                break;
            }
            case TOP: 
            case BOTTOM: {
                this.horizontal = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.depth = depth;
    }

    public Anchor.Direction getDirection() {
        return this.direction;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getDepth() {
        return this.depth;
    }

    public void extendToInfinity() {
        switch (this.direction) {
            case LEFT: {
                this.width = this.x - -20000;
                this.x = -20000;
                break;
            }
            case RIGHT: {
                this.width = 20000 - this.x;
                break;
            }
            case TOP: {
                this.height = this.y - -20000;
                this.y = -20000;
                break;
            }
            case BOTTOM: {
                this.height = 20000 - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int compareImportant(Rectangle collisionToCheck, Rectangle currentMostImportant) {
        if (!this.intersectsZero(collisionToCheck)) {
            return Integer.MAX_VALUE;
        }
        if (currentMostImportant == null) {
            return Integer.MIN_VALUE;
        }
        switch (this.direction) {
            case LEFT: {
                return currentMostImportant.x + currentMostImportant.width - (collisionToCheck.x + collisionToCheck.width);
            }
            case RIGHT: {
                return collisionToCheck.x - currentMostImportant.x;
            }
            case TOP: {
                return currentMostImportant.y + currentMostImportant.height - (collisionToCheck.y + collisionToCheck.height);
            }
            case BOTTOM: {
                return collisionToCheck.y - currentMostImportant.y;
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean intersectsZero(Rectangle r) {
        int tx = this.x;
        int ty = this.y;
        int rx = r.x;
        int ry = r.y;
        int tw = this.width + tx;
        int th = this.height + ty;
        int rw = r.width + rx;
        int rh = r.height + ry;
        return rw > tx && rh > ty && tw > rx && th > ry;
    }

    private void parseIntervalsBy(ArrayList<OrthogonalSearchRouterRegion> intervals, Rectangle collision) {
        int colEnd;
        int colStart;
        if (this.horizontal) {
            colStart = collision.y;
            colEnd = collision.y + collision.height;
        } else {
            colStart = collision.x;
            colEnd = collision.x + collision.width;
        }
        int i = 0;
        while (i < intervals.size()) {
            int difference;
            int regEnd;
            int regStart;
            OrthogonalSearchRouterRegion region = intervals.get(i);
            if (this.horizontal) {
                regStart = region.y;
                regEnd = region.y + region.height;
            } else {
                regStart = region.x;
                regEnd = region.x + region.width;
            }
            if (colEnd <= regStart || colStart >= regEnd) {
                ++i;
                continue;
            }
            if (colStart <= regStart && colEnd >= regEnd) {
                intervals.remove(i);
                continue;
            }
            if (colStart > regStart && colEnd < regEnd) {
                OrthogonalSearchRouterRegion clonedRegion = region.cloneExactly();
                int len1 = colStart - regStart;
                int len2 = regEnd - colEnd;
                if (this.horizontal) {
                    region.height = len1;
                    clonedRegion.y = regEnd - len2;
                    clonedRegion.height = len2;
                    intervals.add(i + 1, clonedRegion);
                } else {
                    region.width = len1;
                    clonedRegion.x = regEnd - len2;
                    clonedRegion.width = len2;
                    intervals.add(i + 1, clonedRegion);
                }
                return;
            }
            if (colStart <= regStart && colEnd > regStart && colEnd < regEnd) {
                difference = colEnd - regStart;
                if (this.horizontal) {
                    region.y += difference;
                    region.height -= difference;
                } else {
                    region.x += difference;
                    region.width -= difference;
                }
                ++i;
                continue;
            }
            if (colEnd >= regEnd && colStart > regStart && colStart < regEnd) {
                difference = regEnd - colStart;
                if (this.horizontal) {
                    region.height -= difference;
                } else {
                    region.width -= difference;
                }
                ++i;
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public OrthogonalSearchRouterRegion cloneExactly() {
        return new OrthogonalSearchRouterRegion(this.x, this.y, this.width, this.height, this.direction, this.depth);
    }

    public ArrayList<OrthogonalSearchRouterRegion> parseSubRegions(List<Rectangle> collisions) {
        ArrayList<Rectangle> importantCollisions = new ArrayList<Rectangle>();
        Rectangle importantCollision = null;
        for (Rectangle collision : collisions) {
            int howMuch = this.compareImportant(collision, importantCollision);
            if (howMuch > 0) continue;
            if (howMuch < 0) {
                importantCollisions.clear();
                importantCollision = collision;
            }
            importantCollisions.add(collision);
        }
        ArrayList<OrthogonalSearchRouterRegion> subRegions = new ArrayList<OrthogonalSearchRouterRegion>();
        if (importantCollisions.size() > 0) {
            this.cutLengthBy(importantCollision);
            subRegions.add(this.cloneWithForwardEdge());
            for (Rectangle collision : importantCollisions) {
                this.parseIntervalsBy(subRegions, collision);
            }
        }
        return subRegions;
    }

    public OrthogonalSearchRouterRegion cloneWithForwardEdge() {
        return this.cloneWithEdge(this.direction, this.depth);
    }

    public OrthogonalSearchRouterRegion cloneWithCounterClockwiseEdge() {
        return this.cloneWithEdge(OrthogonalSearchRouterRegion.getCounterClockWiseDirection(this.direction), this.depth + 1);
    }

    public OrthogonalSearchRouterRegion cloneWithClockwiseEdge() {
        return this.cloneWithEdge(OrthogonalSearchRouterRegion.getClockWiseDirection(this.direction), this.depth + 1);
    }

    private OrthogonalSearchRouterRegion cloneWithEdge(Anchor.Direction dir, int depth) {
        switch (dir) {
            case LEFT: {
                return new OrthogonalSearchRouterRegion(this.x, this.y, 0, this.height, dir, depth);
            }
            case RIGHT: {
                return new OrthogonalSearchRouterRegion(this.x + this.width, this.y, 0, this.height, dir, depth);
            }
            case TOP: {
                return new OrthogonalSearchRouterRegion(this.x, this.y, this.width, 0, dir, depth);
            }
            case BOTTOM: {
                return new OrthogonalSearchRouterRegion(this.x, this.y + this.height, this.width, 0, dir, depth);
            }
        }
        throw new IllegalArgumentException();
    }

    private void cutLengthBy(Rectangle collision) {
        switch (this.direction) {
            case LEFT: {
                int toBeMin = collision.x + collision.width;
                int currently = this.x;
                if (toBeMin > this.x + this.width) {
                    this.x += this.width;
                    this.width = 0;
                    break;
                }
                if (toBeMin <= currently) break;
                this.width = this.x + this.width - toBeMin;
                this.x = toBeMin;
                break;
            }
            case RIGHT: {
                int toBeMax = collision.x;
                int currently = this.x + this.width;
                if (toBeMax < this.x) {
                    this.width = 0;
                    break;
                }
                if (toBeMax >= currently) break;
                this.width = toBeMax - this.x;
                break;
            }
            case TOP: {
                int toBeMin = collision.y + collision.height;
                int currently = this.y;
                if (toBeMin > this.y + this.height) {
                    this.y += this.height;
                    this.height = 0;
                    break;
                }
                if (toBeMin <= currently) break;
                this.height = this.y + this.height - toBeMin;
                this.y = toBeMin;
                break;
            }
            case BOTTOM: {
                int toBeMax = collision.y;
                int currently = this.y + this.height;
                if (toBeMax < this.y) {
                    this.height = 0;
                    break;
                }
                if (toBeMax >= currently) break;
                this.height = toBeMax - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getLength() {
        return this.horizontal ? this.width : this.height;
    }

    public int getDistance(Point point) {
        return this.horizontal ? Math.abs(point.y - this.y) : Math.abs(point.x - this.x);
    }

    public boolean containsInsideEdges(Point point) {
        return point.x >= this.x && point.x <= this.x + this.width && point.y >= this.y && point.y <= this.y + this.height;
    }

    @Override
    public String toString() {
        return "pos: " + this.x + "," + this.y + " size: " + this.width + "," + this.height + " dir: " + (Object)((Object)this.direction) + " depth: " + this.depth;
    }

    public static Anchor.Direction getCounterClockWiseDirection(Anchor.Direction direction) {
        switch (direction) {
            case LEFT: {
                return Anchor.Direction.BOTTOM;
            }
            case RIGHT: {
                return Anchor.Direction.TOP;
            }
            case TOP: {
                return Anchor.Direction.LEFT;
            }
            case BOTTOM: {
                return Anchor.Direction.RIGHT;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Anchor.Direction getClockWiseDirection(Anchor.Direction direction) {
        switch (direction) {
            case LEFT: {
                return Anchor.Direction.TOP;
            }
            case RIGHT: {
                return Anchor.Direction.BOTTOM;
            }
            case TOP: {
                return Anchor.Direction.RIGHT;
            }
            case BOTTOM: {
                return Anchor.Direction.LEFT;
            }
        }
        throw new IllegalArgumentException();
    }
}

