/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.table.NumberEditorNumberFormat;
import org.jdesktop.swingx.table.NumberFormatExt;
import org.jdesktop.swingx.table.StrictNumberFormatter;

public class NumberEditorExt
extends DefaultCellEditor {
    private static Class<?>[] argTypes = new Class[]{String.class};
    Constructor<?> constructor;
    private boolean useStrictFormatter;

    public NumberEditorExt() {
        this((NumberFormat)null);
    }

    public NumberEditorExt(NumberFormat format) {
        this(format, false);
    }

    public NumberEditorExt(boolean useStrictFormatter) {
        this(null, useStrictFormatter);
    }

    public NumberEditorExt(NumberFormat format, boolean useStrictFormatter) {
        super(useStrictFormatter ? NumberEditorExt.createFormattedTextFieldX(format) : NumberEditorExt.createFormattedTextField(format));
        this.useStrictFormatter = useStrictFormatter;
        JFormattedTextField textField = this.getComponent();
        textField.setName("Table.editor");
        textField.setHorizontalAlignment(4);
        textField.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object value) {
                NumberEditorExt.this.getComponent().setValue(value);
            }

            public Object getCellEditorValue() {
                try {
                    NumberEditorExt.this.getComponent().commitEdit();
                    return NumberEditorExt.this.getComponent().getValue();
                }
                catch (ParseException ex) {
                    return null;
                }
            }
        };
        textField.addActionListener(this.delegate);
    }

    public boolean stopCellEditing() {
        if (!this.isValid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean isValid() {
        if (!this.getComponent().isEditValid()) {
            return false;
        }
        try {
            if (!this.useStrictFormatter) {
                this.getNumber();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Number getNumber() throws Exception {
        Number number = (Number)super.getCellEditorValue();
        if (number == null) {
            return null;
        }
        return this.useStrictFormatter ? (Number)number : (Number)((Number)this.constructor.newInstance(number.toString()));
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.getComponent().setBorder(new LineBorder(Color.black));
        try {
            Class<?> type = table.getColumnClass(column);
            if (!Number.class.isAssignableFrom(type)) {
                throw new IllegalStateException("NumberEditor can only handle subclasses of java.lang.Number");
            }
            if (this.useStrictFormatter) {
                ((NumberFormatter)this.getComponent().getFormatter()).setValueClass(type);
            } else {
                this.constructor = type.getConstructor(argTypes);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Number subclass must have a constructor which takes a string", ex);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Number getCellEditorValue() throws IllegalStateException {
        try {
            return this.getNumber();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Number conversion not possible from current string " + this.getComponent().getText());
        }
    }

    public JFormattedTextField getComponent() {
        return (JFormattedTextField)super.getComponent();
    }

    private static JFormattedTextField createFormattedTextFieldX(NumberFormat format) {
        StrictNumberFormatter formatter = new StrictNumberFormatter(new NumberFormatExt(format));
        JFormattedTextField textField = new JFormattedTextField(formatter);
        for (InputMap map = textField.getInputMap(); map != null; map = map.getParent()) {
            map.remove(KeyStroke.getKeyStroke("pressed ESCAPE"));
        }
        textField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        textField.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.black));
                } else {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.red));
                }
            }
        });
        return textField;
    }

    private static JFormattedTextField createFormattedTextField(NumberFormat formatter) {
        JFormattedTextField textField = new JFormattedTextField(new NumberEditorNumberFormat(formatter));
        for (InputMap map = textField.getInputMap(); map != null; map = map.getParent()) {
            map.remove(KeyStroke.getKeyStroke("pressed ESCAPE"));
        }
        textField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        textField.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.black));
                } else {
                    ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.red));
                }
            }
        });
        return textField;
    }
}

