/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.inditimeline;

import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.utils.SvgUtils;
import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.timeline.TimelineView;
import genj.util.Registry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.batik.svggen.SVGGraphics2D;

public class ReportIndiTimeLine
extends Report {
    public FormatOptions formattingOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public MyContent content = new MyContent();
    public FormatPlaceOptions dataFormatOptions = new FormatPlaceOptions();
    public MyColor colorOptions = new MyColor();
    private static final int BEGINX = 260;
    private static final Registry REGISTRY = Registry.get(TimelineView.class);
    private SVGGraphics2D svgGenerator;
    private double anneeDebut;
    private double anneeFin;
    private double anneeOffset;
    private int backgroundBegin;
    private int maxWidth;
    private int titleX;
    private int titleY;
    private String titleValue;
    private Font currentFont;

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public File start(Indi indi) {
        File file;
        this.maxWidth = 0;
        this.currentFont = new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, this.formattingOptions.fontSize);
        if (indi.getBirthDateOption() == null) {
            this.println(this.translate("birt.error"));
            return null;
        }
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        this.svgGenerator = SvgUtils.createSvgGenerator();
        this.svgGenerator.setFont(this.currentFont);
        int nextHeight = 0;
        try {
            nextHeight = this.createTitle(indi);
            this.backgroundBegin = nextHeight = this.createTimeLine(indi, nextHeight);
            nextHeight = this.createIndividualEvents(indi, nextHeight);
            this.createBackground(this.backgroundBegin, nextHeight, this.translate("individual.event"), this.colorOptions.birtColor);
            this.backgroundBegin = nextHeight;
            nextHeight = this.createFamilyEvents(indi, nextHeight);
            this.createBackground(this.backgroundBegin, nextHeight, this.translate("family.event"), this.colorOptions.weddingColor);
            if (this.content.displayOccupation) {
                this.backgroundBegin = nextHeight;
                nextHeight = this.createOccupationEvents(indi, nextHeight);
                this.createBackground(this.backgroundBegin, nextHeight, this.translate("occupation"), this.colorOptions.occupationColor);
            }
            if (this.content.displayOccupation) {
                this.backgroundBegin = nextHeight;
                nextHeight = this.createResidencyEvents(indi, nextHeight);
                this.createBackground(this.backgroundBegin, nextHeight, this.translate("residences"), this.colorOptions.residenceColor);
            }
            if (this.content.displayAlmanach) {
                this.backgroundBegin = nextHeight;
                nextHeight = this.createAlmanacEvents(nextHeight);
                this.createBackground(this.backgroundBegin, nextHeight, this.translate("almanac"), this.colorOptions.almanachColor);
            }
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontTitles[this.formattingOptions.fontTitle], 0, this.formattingOptions.fontTitleSize));
            this.svgGenerator.setColor(this.colorOptions.textColor);
            FontMetrics metrics = this.svgGenerator.getFontMetrics();
            Rectangle2D boundary = metrics.getStringBounds(this.titleValue, (Graphics)this.svgGenerator);
            if ((double)this.maxWidth < boundary.getWidth()) {
                this.maxWidth = (int)boundary.getWidth() + 25;
            }
            this.svgGenerator.drawRect(10, 10, this.maxWidth - 10, nextHeight + 20);
            this.svgGenerator.setColor(Color.WHITE);
            this.svgGenerator.fillRect(0, nextHeight + 31, this.maxWidth + 10, 9);
            this.svgGenerator.setSVGCanvasSize(new Dimension(this.maxWidth + 10, nextHeight + 40));
            this.svgGenerator.setColor(this.colorOptions.textColor);
            this.titleX = (int)((long)(this.maxWidth / 2) - Math.round(boundary.getWidth() / 2.0));
            this.svgGenerator.drawString(this.titleValue, this.titleX, this.titleY);
        }
        catch (GedcomException e) {
            LOG.log(Level.INFO, this.translate("error.date"), e);
            this.println(this.translate("error.date"));
            return null;
        }
        this.flush();
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));){
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, this.translate("output.error"), ioe);
            return null;
        }
        return file;
    }

    private int createTimeLine(Indi indi, int height) throws GedcomException {
        PropertyDate deathDate;
        this.svgGenerator.setFont(this.currentFont);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        int anneeNaissance = this.getDateGreg(indi.getBirthDateOption(), true).getYear();
        this.anneeDebut = Math.floor(anneeNaissance / 10) * 10.0;
        if (this.anneeDebut == (double)anneeNaissance) {
            this.anneeDebut -= 10.0;
        }
        if ((deathDate = indi.getDeathDateOption()) != null && deathDate.isValid()) {
            int anneeDeces = this.getDateGreg(deathDate, true).getYear();
            this.anneeFin = Math.floor(anneeDeces / 10) * 10.0 + 40.0;
        } else {
            this.anneeFin = this.anneeDebut + 140.0;
        }
        Rectangle2D boundary = metrics.getStringBounds(String.format("%.0f", this.anneeDebut), (Graphics)this.svgGenerator);
        this.anneeOffset = boundary.getWidth() / 2.0 - boundary.getHeight() / 3.0;
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{Color.white, this.colorOptions.timelineColor};
        int debutY = Math.max(100, height);
        int width = (int)(this.anneeFin - this.anneeDebut) * 12;
        Rectangle2D.Double rect = new Rectangle2D.Double(260.0, debutY += (int)(boundary.getHeight() / 2.0), width, boundary.getHeight());
        Point2D.Double start = new Point2D.Double(100.0, 100.0);
        Point2D.Double end = new Point2D.Double(260 + width, 100.0);
        this.svgGenerator.setPaint((Paint)new LinearGradientPaint(start, end, dist, colors));
        this.svgGenerator.fill((Shape)rect);
        this.svgGenerator.setPaint((Paint)this.colorOptions.timelineColor);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(260 + width, (double)debutY - boundary.getHeight() / 3.0);
        ((Path2D)path).lineTo(260 + width + 50, (double)debutY + boundary.getHeight() / 2.0);
        ((Path2D)path).lineTo(260 + width, (double)debutY + boundary.getHeight() + boundary.getHeight() / 3.0);
        path.closePath();
        this.svgGenerator.fill((Shape)path);
        int retour = debutY + (int)boundary.getHeight() + (int)(boundary.getHeight() / 3.0) + 10;
        this.maxWidth = Math.max(this.maxWidth, 260 + width + 50);
        this.svgGenerator.setPaint((Paint)this.colorOptions.textColor);
        BasicStroke ligne = new BasicStroke(1.0f);
        float[] dashedpattern = new float[]{(float)(boundary.getHeight() / 2.0), (float)boundary.getHeight()};
        BasicStroke dashed = new BasicStroke(1.0f, 2, 0, 10.0f, dashedpattern, 0.0f);
        int i = 0;
        while ((double)i < this.anneeFin - this.anneeDebut) {
            String value = String.format("%.0f", this.anneeDebut + (double)i);
            boundary = metrics.getStringBounds(value, (Graphics)this.svgGenerator);
            this.svgGenerator.setStroke((Stroke)dashed);
            this.svgGenerator.setColor(Color.GRAY);
            this.svgGenerator.drawLine((int)((double)(260 + i * 12) + boundary.getWidth() / 2.0), (int)((double)debutY - boundary.getHeight() / 2.0), (int)((double)(260 + i * 12) + boundary.getWidth() / 2.0), 5000);
            this.svgGenerator.setStroke((Stroke)ligne);
            this.svgGenerator.setColor(this.colorOptions.textColor);
            this.svgGenerator.drawString(value, 260 + i * 12, (int)((double)debutY + 4.0 * boundary.getHeight() / 5.0));
            i += 10;
        }
        this.anneeFin -= 20.0;
        return retour;
    }

    private int createTitle(Indi indi) {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontTitles[this.formattingOptions.fontTitle], 0, this.formattingOptions.fontTitleSize));
        this.svgGenerator.setColor(this.colorOptions.textColor);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        this.titleValue = this.format(this.formattingOptions.title, indi);
        Rectangle2D boundary = metrics.getStringBounds(this.titleValue, (Graphics)this.svgGenerator);
        this.titleY = 10 + (int)boundary.getHeight();
        return this.titleY + 10;
    }

    private String format(String value, Indi indi) {
        value = value.replaceAll("\\$i", indi.getId());
        value = value.replaceAll("\\$s", indi.getSosaString());
        value = value.replaceAll("\\$n", indi.getName());
        value = value.replaceAll("\\$f", indi.getFirstName());
        value = value.replaceAll("\\$l", indi.getLastName());
        value = value.replaceAll("\\$d", indi.getBirthDateOption().getDisplayValue() + " - " + (indi.getDeathDateOption() != null ? indi.getDeathDateOption().getDisplayValue() : ""));
        Property pTitle = indi.getProperty(new TagPath("INDI:TITL"));
        String titleStr = "";
        if (pTitle != null) {
            titleStr = pTitle.getDisplayValue();
        }
        value = value.replaceAll("\\$t", titleStr);
        value = value.replaceAll("\\s+", " ");
        return value;
    }

    private int createIndividualEvents(Indi indi, int height) throws GedcomException {
        Property buri;
        Property crem;
        Property chr;
        double currentHeight = height;
        PropertyDate birtDate = indi.getBirthDate();
        if (birtDate != null && birtDate.isValid()) {
            currentHeight = this.addEvent(indi.getBirthDateOption(), height, this.colorOptions.birtColor, "");
        }
        if ((chr = indi.getProperty("CHR")) != null) {
            chrDate = chr.getWhen();
            if (chrDate != null && chrDate.isValid()) {
                currentHeight = this.addEvent(chrDate, currentHeight, this.colorOptions.baptismColor, "");
            }
        } else {
            chr = indi.getProperty("BAPM");
            if (chr != null && (chrDate = chr.getWhen()) != null && chrDate.isValid()) {
                currentHeight = this.addEvent(chrDate, currentHeight, this.colorOptions.baptismColor, "");
            }
        }
        if (this.content.displayOtherEvents) {
            HashSet<String> usedTags = new HashSet<String>(Arrays.asList("BIRT", "CHR", "BAPM", "DEAT", "BURI", "OCCU", "RESI", "CREM", "CENS"));
            Property[] propertyArray = indi.getProperties();
            int n = propertyArray.length;
            for (int i = 0; i < n; ++i) {
                PropertyDate date;
                Property event = propertyArray[i];
                String tag = event.getTag();
                if (usedTags.contains(tag) || (date = event.getWhen()) == null || !date.isValid()) continue;
                Object complement = "";
                Property type = event.getProperty("TYPE");
                if (event.getValue() != null && !"".equals(event.getValue())) {
                    complement = " : " + event.getValue();
                } else if (type != null) {
                    complement = " : " + type.getDisplayValue();
                }
                currentHeight = this.addEvent(date, currentHeight, this.colorOptions.defaultEventColor, (String)complement);
            }
        }
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            PropertyDate marriage = fam.getMarriageDate();
            if (marriage == null || !marriage.isValid()) continue;
            currentHeight = this.addMarriage(indi, fam, currentHeight, false);
        }
        PropertyDate death = indi.getDeathDate();
        if (death != null && death.isValid()) {
            currentHeight = this.addEvent(death, currentHeight, this.colorOptions.deathColor, "");
        }
        if ((crem = indi.getProperty("CREM")) != null && (death = crem.getWhen()) != null && death.isValid()) {
            currentHeight = this.addEvent(death, currentHeight, this.colorOptions.deathColor, "");
        }
        if ((buri = indi.getProperty("BURI")) != null && (death = buri.getWhen()) != null && death.isValid()) {
            currentHeight = this.addEvent(death, currentHeight, this.colorOptions.deathColor, "");
        }
        return (int)currentHeight;
    }

    private int createFamilyEvents(Indi indi, int height) throws GedcomException {
        double currentHeight = height;
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            PropertyDate mDeath;
            Indi mother;
            PropertyDate fDeath;
            currentHeight = this.addMarriage(indi, fam, currentHeight, true);
            Indi father = fam.getHusband();
            if (father != null && (fDeath = father.getDeathDateOption()) != null && fDeath.isValid() && (double)this.getDateGreg(fDeath, true).getYear() < this.anneeFin) {
                currentHeight = this.addEvent(fDeath, currentHeight, this.colorOptions.deathColor, " " + this.translate("father") + " (" + this.getNamewithSosa(father, false) + ")");
            }
            if ((mother = fam.getWife()) != null && (mDeath = mother.getDeathDateOption()) != null && mDeath.isValid() && (double)this.getDateGreg(mDeath, true).getYear() < this.anneeFin) {
                currentHeight = this.addEvent(mDeath, currentHeight, this.colorOptions.deathColor, " " + this.translate("mother") + " (" + this.getNamewithSosa(mother, false) + ")");
            }
        }
        for (Fam fSpouse : indi.getFamiliesWhereSpouse()) {
            PropertyDate osdeath;
            Indi otherSpouse = fSpouse.getOtherSpouse(indi);
            if (otherSpouse != null && (osdeath = otherSpouse.getDeathDateOption()) != null && osdeath.isValid() && (double)this.getDateGreg(osdeath, true).getYear() < this.anneeFin) {
                currentHeight = this.addEvent(otherSpouse.getDeathDateOption(), currentHeight, this.colorOptions.deathColor, " " + this.translate("spouse") + " (" + this.getNamewithSosa(otherSpouse, false) + ")");
            }
            for (Indi child : fSpouse.getChildren(true)) {
                PropertyDate chDeath;
                PropertyDate chBirt = child.getBirthDateOption();
                if (chBirt != null && chBirt.isValid() && (double)this.getDateGreg(chBirt, true).getYear() < this.anneeFin) {
                    currentHeight = this.addEvent(chBirt, currentHeight, this.colorOptions.birtColor, " " + this.translate("child") + " (" + this.getNamewithSosa(child, true) + ")");
                    for (Fam cFam : child.getFamiliesWhereSpouse()) {
                        PropertyDate cmDate = cFam.getMarriageDate();
                        if (cmDate == null || !cmDate.isValid() || !((double)this.getDateGreg(cmDate, true).getYear() < this.anneeFin)) continue;
                        currentHeight = this.addEvent(cmDate, currentHeight, this.colorOptions.weddingColor, " " + this.translate("child") + " (" + this.getNamewithSosa(child, true) + ")");
                    }
                }
                if ((chDeath = child.getDeathDateOption()) == null || !chDeath.isValid() || !((double)this.getDateGreg(chDeath, true).getYear() < this.anneeFin)) continue;
                currentHeight = this.addEvent(chDeath, currentHeight, this.colorOptions.deathColor, " " + this.translate("child") + " (" + this.getNamewithSosa(child, true) + ")");
            }
        }
        return (int)currentHeight;
    }

    private double addMarriage(Indi indi, Fam fam, double currentHeight, boolean parents) throws GedcomException {
        Indi mother;
        PropertyDate marriageDate = fam.getMarriageDate();
        Property div = fam.getProperty("DIV");
        PropertyDate fDeath = null;
        PropertyDate mDeath = null;
        Indi father = fam.getHusband();
        if (father != null) {
            fDeath = father.getDeathDateOption();
        }
        if ((mother = fam.getWife()) != null) {
            mDeath = mother.getDeathDateOption();
        }
        if (marriageDate != null && marriageDate.isValid()) {
            String marriageText;
            String weddingText = parents ? this.translate("parents.wedding") : " (" + this.getNamewithSosa(fam.getOtherSpouse(indi), false) + ")";
            String string = marriageText = parents ? this.translate("parents.marriage") : Gedcom.getReportName((String)marriageDate.getParent().getTag()) + " (" + this.getNamewithSosa(fam.getOtherSpouse(indi), false) + ")";
            if (div != null) {
                PropertyDate divDate = div.getWhen();
                if (divDate != null && divDate.isValid()) {
                    PropertyDate theDate = new PropertyDate();
                    theDate.setValue(PropertyDate.FROM_TO, this.getDateGreg(marriageDate, true), this.getDateGreg(divDate, true), "");
                    currentHeight = this.addLongEvent(theDate, currentHeight, this.colorOptions.weddingColor, this.colorOptions.divorceColor, marriageText, false);
                }
            } else if (fDeath != null && fDeath.isValid() || mDeath != null && mDeath.isValid()) {
                PropertyDate theDate = new PropertyDate();
                if (fDeath != null && mDeath != null) {
                    theDate.setValue(PropertyDate.FROM_TO, this.getDateGreg(marriageDate, true), fDeath.compareTo((Property)mDeath) < 0 ? this.getDateGreg(fDeath, true) : this.getDateGreg(mDeath, true), "");
                } else if (fDeath != null && fDeath.isValid()) {
                    theDate.setValue(PropertyDate.FROM_TO, this.getDateGreg(marriageDate, true), this.getDateGreg(fDeath, true), "");
                } else if (mDeath != null && mDeath.isValid()) {
                    theDate.setValue(PropertyDate.FROM_TO, this.getDateGreg(marriageDate, true), this.getDateGreg(mDeath, true), "");
                }
                currentHeight = this.addLongEvent(theDate, currentHeight, this.colorOptions.weddingColor, this.colorOptions.deathColor, marriageText, false);
            } else {
                currentHeight = this.addEvent(marriageDate, currentHeight, this.colorOptions.weddingColor, weddingText, !parents);
            }
        }
        return currentHeight;
    }

    private int createOccupationEvents(Indi indi, int height) throws GedcomException {
        double currentHeight = height;
        for (Property occu : indi.getProperties("OCCU")) {
            String description = occu.getDisplayValue();
            Object type = occu.getPropertyValue("TYPE");
            type = !"".equals(description) && !"".equals(type) ? (String)type + " : " + description : (String)type + description;
            PropertyDate oDate = occu.getWhen();
            if (oDate != null && oDate.isValid()) {
                currentHeight = this.addEvent(oDate, currentHeight, this.colorOptions.occupationColor, (String)type, false);
                continue;
            }
            double debutX = (this.maxWidth + 210) / 2;
            double debutY = currentHeight + 5.0;
            this.svgGenerator.setFont(this.currentFont);
            this.svgGenerator.setColor(this.colorOptions.textColor);
            FontMetrics metrics = this.svgGenerator.getFontMetrics();
            Rectangle2D boundary = metrics.getStringBounds((String)type, (Graphics)this.svgGenerator);
            int textHeight = (int)boundary.getHeight();
            this.svgGenerator.drawString((String)type, (int)(debutX - boundary.getWidth() / 2.0), (int)(debutY + (double)(4 * textHeight / 5)));
            currentHeight = debutY + (double)textHeight;
        }
        return (int)currentHeight;
    }

    private int createResidencyEvents(Indi indi, int height) throws GedcomException {
        PropertyDate rDate;
        double currentHeight = height;
        for (Property resi : indi.getProperties("RESI")) {
            rDate = resi.getWhen();
            if (rDate == null || !rDate.isValid()) continue;
            currentHeight = this.addEvent(rDate, currentHeight, this.colorOptions.residenceColor, this.getPlace(resi), false);
        }
        for (Property cens : indi.getProperties("CENS")) {
            rDate = cens.getWhen();
            if (rDate == null || !rDate.isValid()) continue;
            currentHeight = this.addEvent(rDate, currentHeight, this.colorOptions.residenceColor, " : " + this.getPlace(cens), true);
        }
        return (int)currentHeight;
    }

    private String getPlace(Property prop) {
        StringBuilder result = new StringBuilder();
        Property addr = prop.getProperty("ADDR");
        if (addr != null) {
            this.appendToPlace(result, addr);
            this.appendToPlace(result, addr.getProperty("ADR1"));
            this.appendToPlace(result, addr.getProperty("ADR2"));
            this.appendToPlace(result, addr.getProperty("CITY"));
            this.appendToPlace(result, addr.getProperty("STAE"));
            this.appendToPlace(result, addr.getProperty("CTRY"));
        } else if (prop.getProperty("PLAC") != null) {
            PropertyPlace place = (PropertyPlace)prop.getProperty("PLAC");
            String placeFormatted = this.dataFormatOptions.getPlace((Property)place);
            placeFormatted = !"".equals(placeFormatted) ? placeFormatted.replaceAll("\\(\\)", " ").trim() : "";
            result.append(placeFormatted);
        }
        if (result.length() == 0) {
            return "";
        }
        return result.toString();
    }

    private void appendToPlace(StringBuilder result, Property prop) {
        if (prop != null && !prop.getValue().isEmpty()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(prop.getValue());
        }
    }

    private int createAlmanacEvents(int height) throws GedcomException {
        String[] ignoredNames = REGISTRY.get("almanac.ignorenames", new String[0]);
        ArrayList<String> ignoredAlmanacsList = new ArrayList<String>(Arrays.asList(ignoredNames));
        String[] ignored = REGISTRY.get("almanac.ignore", new String[0]);
        ArrayList<String> ignoredAlmanacCategories = new ArrayList<String>(Arrays.asList(ignored));
        int almanacSigLevel = REGISTRY.get("almanac.siglevel", 9);
        double currentHeight = height;
        Almanac alma = Almanac.getInstance();
        alma.waitLoaded();
        List almanacs = alma.getAlmanacs();
        almanacs.removeAll(ignoredAlmanacsList);
        List categories = alma.getCategories();
        categories.removeAll(ignoredAlmanacCategories);
        PointInTime from = new PointInTime(0, 0, (int)this.anneeDebut);
        PointInTime to = new PointInTime(30, 11, (int)this.anneeFin - 10);
        Iterator events = alma.getEvents(from, to, almanacs, categories, almanacSigLevel);
        while (events.hasNext()) {
            Event event = (Event)events.next();
            String texte = event.getTitle();
            if ("".equals(texte) && (texte = event.getDescription()).length() > 45) {
                texte = texte.substring(0, 45);
            }
            currentHeight = this.addEvent(event.getDate(), currentHeight, this.colorOptions.almanachColor, texte, false);
        }
        return (int)currentHeight;
    }

    private double addEvent(PropertyDate date, double currentHeight, Color color, String complement) throws GedcomException {
        return this.addEvent(date, currentHeight, color, complement, true);
    }

    private double addEvent(PropertyDate date, double currentHeight, Color color, String complement, boolean isDisplayTag) throws GedcomException {
        if (date.isRange() && this.getDateGreg(date, true).getYear() != this.getDateGreg(date, false).getYear()) {
            return this.addLongEvent(date, currentHeight, color, color, complement, isDisplayTag);
        }
        int year = this.getDateGreg(date, true).getYear();
        double debutX = 260.0 + ((double)year - this.anneeDebut) * 12.0 + this.anneeOffset;
        double debutY = currentHeight + 5.0;
        String text = (isDisplayTag ? Gedcom.getReportName((String)date.getParent().getTag()) : "") + complement;
        this.svgGenerator.setFont(this.currentFont);
        this.svgGenerator.setColor(color);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Rectangle2D boundary = metrics.getStringBounds(text, (Graphics)this.svgGenerator);
        int textHeight = (int)boundary.getHeight();
        this.svgGenerator.fillOval((int)debutX, (int)debutY, textHeight - 2, textHeight - 2);
        this.svgGenerator.setColor(this.colorOptions.textColor);
        this.svgGenerator.drawString(text, (int)debutX + textHeight + 2, (int)(debutY + (double)(4 * textHeight / 5)));
        return debutY + (double)textHeight;
    }

    private double addLongEvent(PropertyDate date, double currentHeight, Color colorB, Color colorE, String complement, boolean isDisplayTag) throws GedcomException {
        int year = this.getDateGreg(date, true).getYear();
        int yearE = this.getDateGreg(date, false).getYear();
        if ((double)year < this.anneeDebut && (double)yearE > this.anneeFin - 10.0) {
            return currentHeight;
        }
        if ((double)yearE > this.anneeFin - 10.0) {
            yearE = year + 1;
        }
        double debutX = 260.0 + ((double)year - this.anneeDebut) * 12.0 + this.anneeOffset;
        if ((double)year < this.anneeDebut) {
            debutX = 250.0;
        }
        double debutY = currentHeight + 5.0;
        double finX = 260.0 + ((double)yearE - this.anneeDebut) * 12.0 + this.anneeOffset;
        String text = (isDisplayTag ? Gedcom.getReportName((String)date.getParent().getTag()) : "") + complement;
        this.svgGenerator.setFont(this.currentFont);
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{colorB, colorE};
        Point2D.Double start = new Point2D.Double(debutX, 100.0);
        Point2D.Double close = new Point2D.Double(finX, 100.0);
        this.svgGenerator.setPaint((Paint)new LinearGradientPaint(start, close, dist, colors));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Rectangle2D boundary = metrics.getStringBounds(text, (Graphics)this.svgGenerator);
        int textHeight = (int)boundary.getHeight();
        this.svgGenerator.fillRoundRect((int)debutX, (int)debutY, (int)(finX - debutX + (double)(textHeight / 2)), textHeight, textHeight, textHeight);
        this.svgGenerator.setColor(this.colorOptions.textColor);
        this.svgGenerator.drawString(text, (int)(finX + (double)(textHeight / 2)) + 2, (int)(debutY + (double)(4 * textHeight / 5)));
        return debutY + (double)textHeight;
    }

    private void createBackground(int begin, int end, String legende, Color bar) {
        if (begin == end) {
            return;
        }
        this.svgGenerator.setFont(this.currentFont);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(192, 192, 192, 100), new Color(255, 255, 255, 100)};
        Point2D.Double start = new Point2D.Double(100.0, begin);
        Point2D.Double close = new Point2D.Double(100.0, end);
        this.svgGenerator.setPaint((Paint)new LinearGradientPaint(start, close, dist, colors));
        Rectangle2D.Double rect = new Rectangle2D.Double(260.0, begin, this.maxWidth - 310, end - begin);
        this.svgGenerator.fill((Shape)rect);
        this.svgGenerator.setPaint((Paint)bar);
        rect = new Rectangle2D.Double(250.0, begin, 10.0, end - begin);
        this.svgGenerator.fill((Shape)rect);
        this.svgGenerator.setPaint((Paint)this.colorOptions.textColor);
        Rectangle2D boundary = metrics.getStringBounds(legende, (Graphics)this.svgGenerator);
        this.svgGenerator.drawString(legende, 235 - (int)boundary.getWidth(), begin + (end - begin) / 2);
    }

    private String getNamewithSosa(Indi indi, boolean firstname) {
        String name;
        if (indi == null) {
            return " ";
        }
        String string = name = firstname ? indi.getFirstName() : indi.getName();
        if (this.content.displaySosa) {
            String sosa = indi.getSosaString();
            if (name != null && sosa != null && !"".equals(sosa)) {
                return name + " - " + sosa;
            }
            return name + sosa;
        }
        return name;
    }

    private PointInTime getDateGreg(PropertyDate date, boolean start) throws GedcomException {
        if (start) {
            return date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
        }
        return date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN);
    }

    public class FormatOptions {
        public String title = "$n ($i)";
        public int fontTitle = 0;
        public String[] fontTitles = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public int fontTitleSize = 40;
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public int fontSize = 14;
    }

    public class MyContent {
        public boolean displaySosa = false;
        public boolean displayOtherEvents = true;
        public boolean displayOccupation = true;
        public boolean displayResidences = true;
        public boolean displayAlmanach = true;
    }

    public class MyColor {
        public Color textColor = Color.BLACK;
        public Color timelineColor = Color.CYAN;
        public Color birtColor = Color.BLUE;
        public Color baptismColor = Color.PINK;
        public Color deathColor = Color.BLACK;
        public Color weddingColor = Color.GREEN;
        public Color divorceColor = Color.GRAY;
        public Color defaultEventColor = Color.GRAY;
        public Color occupationColor = Color.MAGENTA;
        public Color residenceColor = Color.ORANGE;
        public Color almanachColor = Color.YELLOW;
    }
}

