/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util.copy;

import java.io.InputStream;
import java.io.OutputStream;
import org.oxbow.swingbits.util.copy.FastByteArrayInputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buf = null;
    protected int size = 0;

    public FastByteArrayOutputStream() {
        this(5120);
    }

    public FastByteArrayOutputStream(int n) {
        this.buf = new byte[n];
    }

    private void verifyBufferSize(int n) {
        if (n > this.buf.length) {
            byte[] byArray = this.buf;
            this.buf = new byte[Math.max(n, 2 * this.buf.length)];
            System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        }
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public final void write(byte[] byArray) {
        this.verifyBufferSize(this.size + byArray.length);
        System.arraycopy(byArray, 0, this.buf, this.size, byArray.length);
        this.size += byArray.length;
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.verifyBufferSize(this.size + n2);
        System.arraycopy(byArray, n, this.buf, this.size, n2);
        this.size += n2;
    }

    public final void write(int n) {
        this.verifyBufferSize(this.size + 1);
        this.buf[this.size++] = (byte)n;
    }

    public void reset() {
        this.size = 0;
    }

    public InputStream getInputStream() {
        return new FastByteArrayInputStream(this.buf, this.size);
    }
}

