/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.action;

import java.awt.Component;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.oxbow.swingbits.action.ActionDropDownMenu;
import org.oxbow.swingbits.action.ActionGroup;
import org.oxbow.swingbits.action.Actions;
import org.oxbow.swingbits.action.CheckAction;
import org.oxbow.swingbits.action.RadioAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionBuilderHelper {
    ActionBuilderHelper() {
    }

    protected <T> T createGroup(MenuAdapter<T> menuAdapter, Collection<Action> collection) {
        int n = 1;
        int n2 = collection.size();
        for (Action action : collection) {
            this.createAction(menuAdapter, action, n++ == n2);
        }
        return menuAdapter.get();
    }

    private <T> T createAction(MenuAdapter<T> menuAdapter, Action action, boolean bl) {
        if (action instanceof Collection) {
            if (this.isCollapsed(action)) {
                JMenu jMenu = this.createGroup(new JMenuAdapter(new JMenu(action)), (Collection)((Object)action));
                menuAdapter.add(jMenu);
            } else {
                menuAdapter.addSeparator();
                this.createGroup(menuAdapter, (Collection)((Object)action));
                if (!bl) {
                    menuAdapter.addSeparator();
                }
            }
        } else if (Actions.isSeparator(action)) {
            if (!bl) {
                menuAdapter.addSeparator();
            }
        } else if (this.isCheckAction(action)) {
            menuAdapter.add(new JCheckBoxMenuItem(this.prepareCheckAction(action)));
        } else if (this.isRadioAction(action)) {
            JMenuItem jMenuItem = menuAdapter.add(new JRadioButtonMenuItem(this.prepareCheckAction(action)));
            menuAdapter.getButtonGroup().add(jMenuItem);
        } else {
            menuAdapter.add(new JMenuItem(action));
        }
        return menuAdapter.get();
    }

    private Action prepareCheckAction(Action action) {
        if (action.getValue("SwingSelectedKey") == null) {
            action.putValue("SwingSelectedKey", Boolean.FALSE);
        }
        return action;
    }

    private boolean isCheckAction(Action action) {
        return action.getClass().getAnnotation(CheckAction.class) != null;
    }

    private boolean isRadioAction(Action action) {
        return action.getClass().getAnnotation(RadioAction.class) != null;
    }

    private boolean isCollapsed(Action action) {
        return action instanceof ActionGroup && ((ActionGroup)action).isCollapsed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JMenuAdapter
    extends MenuAdapter<JMenu> {
        public JMenuAdapter(JMenu jMenu) {
            super(jMenu);
        }

        @Override
        public JMenuItem add(JMenuItem jMenuItem) {
            ((JMenu)this.target).add(jMenuItem);
            return jMenuItem;
        }

        @Override
        public void addSeparator() {
            boolean bl;
            int n = ((JMenu)this.target).getMenuComponentCount();
            boolean bl2 = bl = n != 0 && ((JMenu)this.target).getMenuComponent(n - 1).getClass() != JPopupMenu.Separator.class;
            if (bl) {
                ((JMenu)this.target).addSeparator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JPopupMenuAdapter
    extends MenuAdapter<JPopupMenu> {
        public JPopupMenuAdapter(JPopupMenu jPopupMenu) {
            super(jPopupMenu);
        }

        @Override
        public JMenuItem add(JMenuItem jMenuItem) {
            ((JPopupMenu)this.target).add(jMenuItem);
            return jMenuItem;
        }

        @Override
        public void addSeparator() {
            boolean bl;
            int n = ((JPopupMenu)this.target).getComponentCount();
            boolean bl2 = bl = n != 0 && ((JPopupMenu)this.target).getComponent(n - 1).getClass() != JPopupMenu.Separator.class;
            if (bl) {
                ((JPopupMenu)this.target).addSeparator();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JToolBarAdapter
    extends MenuAdapter<JToolBar> {
        public JToolBarAdapter(JToolBar jToolBar) {
            super(jToolBar);
        }

        @Override
        public JMenuItem add(JMenuItem jMenuItem) {
            Action action = jMenuItem.getAction();
            AbstractButton abstractButton = this.add(action, jMenuItem);
            abstractButton.setHorizontalTextPosition(10);
            abstractButton.putClientProperty("hideActionText", action.getValue("SmallIcon") != null);
            return jMenuItem;
        }

        private AbstractButton add(Action action, JMenuItem jMenuItem) {
            if (jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JRadioButtonMenuItem) {
                return (AbstractButton)((JToolBar)this.target).add(new JToggleButton(action));
            }
            if (jMenuItem instanceof JMenu) {
                return ((JToolBar)this.target).add(new ActionDropDownMenu((ActionGroup)action));
            }
            return ((JToolBar)this.target).add(action);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JMenuBarAdapter
    extends MenuAdapter<JMenuBar> {
        public JMenuBarAdapter(JMenuBar jMenuBar) {
            super(jMenuBar);
        }

        @Override
        public JMenuItem add(JMenuItem jMenuItem) {
            Component component = ((JMenuBar)this.target).add(jMenuItem);
            if (component instanceof JMenu) {
                ((JMenu)component).setIcon(null);
            }
            return jMenuItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class MenuAdapter<T> {
        protected T target;
        private ButtonGroup bg;

        public MenuAdapter(T t) {
            this.target = t;
        }

        public T get() {
            return this.target;
        }

        public void addSeparator() {
        }

        public ButtonGroup getButtonGroup() {
            if (this.bg == null) {
                this.bg = new ButtonGroup();
            }
            return this.bg;
        }

        public abstract JMenuItem add(JMenuItem var1);
    }
}

