/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import genj.fo.Document;
import genj.fo.HTMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public abstract class Format {
    protected static final Logger LOG = Logger.getLogger("ancestris.fo");
    private static Format[] formats;
    public static final Format DEFAULT;
    private String format;
    private String extension;
    private boolean isExternalizedFiles;
    private Map<String, TemplatesCache> xslCache = new HashMap<String, TemplatesCache>();

    protected Format(String format, String extension, boolean isExternalizedFiles) {
        this.format = format;
        this.extension = extension;
        this.isExternalizedFiles = isExternalizedFiles;
    }

    public String getFileExtension() {
        return this.extension;
    }

    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return this.format;
    }

    public boolean equals(Object that) {
        return that instanceof Format ? this.format.equals(((Format)that).format) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalizeFiles(Document doc, File out) throws IOException {
        File[] files = doc.getImages();
        if (files.length > 0) {
            File dir = new File(out.getParentFile(), out.getName() + ".images");
            if (!dir.mkdirs()) {
                throw new IOException("cannot create directory " + dir);
            }
            if (dir.exists()) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    File copy = new File(dir, file.getName());
                    FileChannel from = null;
                    AbstractInterruptibleChannel to = null;
                    long count = -1L;
                    try {
                        from = new FileInputStream(file).getChannel();
                        count = from.size();
                        to = new FileOutputStream(copy).getChannel();
                        from.transferTo(0L, count, (WritableByteChannel)((Object)to));
                        doc.setImage(file, dir.getName() + "/" + copy.getName());
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Copying '" + file + "' to '" + copy + "' failed (size=" + count + ")", t);
                        continue;
                    }
                    finally {
                        try {
                            to.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            from.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    public boolean supports(Document doc) {
        return true;
    }

    public void format(Document doc, File file) throws IOException {
        FileOutputStream out = null;
        if (this.getFileExtension() != null) {
            if (file == null) {
                throw new IOException("Formatter requires output file");
            }
            out = new FileOutputStream(file);
            if (this.isExternalizedFiles) {
                this.externalizeFiles(doc, file);
            }
        }
        this.format(doc, out);
    }

    public void format(Document doc, OutputStream out) throws IOException {
        doc.close();
        try {
            this.formatImpl(doc, out);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "unexpected expection formatting " + doc.getTitle(), t);
            if (t instanceof OutOfMemoryError) {
                throw new IOException("out of memory");
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected abstract void formatImpl(Document var1, OutputStream var2) throws Throwable;

    private Templates getTemplatesFromResource(String filename) {
        InputStream in;
        if (filename.startsWith(".")) {
            filename = filename.substring(1);
        }
        if ((in = this.getClass().getResourceAsStream(filename)) == null) {
            return null;
        }
        TemplatesCache cache = this.xslCache.get(filename);
        if (cache != null) {
            return cache.templates;
        }
        cache = new TemplatesCache();
        cache.timestamp = 0L;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            cache.templates = factory.newTemplates(new StreamSource(in));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Exception reading templates from " + filename + ": " + e.getMessage());
        }
        this.xslCache.put(filename, cache);
        return cache.templates;
    }

    protected Templates getTemplates(String filename) {
        Templates resourceTemplates = this.getTemplatesFromResource(filename);
        if (resourceTemplates != null) {
            return resourceTemplates;
        }
        File file = new File(filename);
        long lastModified = file.lastModified();
        TemplatesCache cache = this.xslCache.get(filename);
        if (cache != null && cache.timestamp == lastModified) {
            return cache.templates;
        }
        cache = new TemplatesCache();
        cache.timestamp = lastModified;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            cache.templates = factory.newTemplates(new StreamSource(file));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Exception reading templates from " + filename + ": " + e.getMessage());
        }
        this.xslCache.put(filename, cache);
        return cache.templates;
    }

    public static Format getFormat(String format) {
        Format[] fs = Format.getFormats();
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].getFormat().equals(format)) continue;
            return fs[i];
        }
        return DEFAULT;
    }

    public static Format getFormatFromExtension(String extension) {
        Format[] fs = Format.getFormats();
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].getFileExtension().equals(extension)) continue;
            return fs[i];
        }
        return DEFAULT;
    }

    public static Format[] getFormats() {
        if (formats != null) {
            return formats;
        }
        ArrayList<Format> list = new ArrayList<Format>(10);
        list.add(DEFAULT);
        Iterator<Format> it = ServiceRegistry.lookupProviders(Format.class);
        while (it.hasNext()) {
            try {
                Format f = it.next();
                if (list.contains(f)) continue;
                list.add(f);
            }
            catch (Throwable t) {
                if (t.getCause() != t) {
                    t = t.getCause();
                }
                LOG.log(Level.WARNING, "Encountered exception loading Format: " + t.getMessage());
            }
        }
        formats = list.toArray(new Format[list.size()]);
        return formats;
    }

    static {
        DEFAULT = new HTMLFormat();
    }

    private class TemplatesCache {
        Templates templates;
        long timestamp;

        private TemplatesCache() {
        }
    }
}

