/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.api.place.SearchPlace;
import ancestris.libs.geonames.GeonamesOptions;
import ancestris.modules.place.geonames.GeonamesPlace;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.Style;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class GeonamesPlacesList
implements SearchPlace {
    private static final Logger logger = Logger.getLogger(GeonamesPlacesList.class.getName(), null);
    private List<Place> mPlacesList = new ArrayList<Place>();
    private RequestProcessor.Task theTask;
    private static String KEYMAP = "geonamesPlaceConversionMap";

    public RequestProcessor.Task getTask() {
        return this.theTask;
    }

    public void searchPlace(final String searchedPlace, final List<Place> placesList) {
        this.mPlacesList.clear();
        RequestProcessor RP = new RequestProcessor("interruptible tasks", 1, true);
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                if (!searchedPlace.isEmpty()) {
                    HashSet<String> tmpListDedup = new HashSet<String>();
                    GeonamesPlace place = null;
                    try {
                        logger.log(Level.FINE, "   ");
                        logger.log(Level.FINE, "Start searching {0} ...", searchedPlace.replaceAll(",", " ").replaceAll(" +", " "));
                        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
                        ToponymSearchCriteria toponymSearchCriteria = new ToponymSearchCriteria();
                        toponymSearchCriteria.setStyle(Style.FULL);
                        toponymSearchCriteria.setLanguage(Locale.getDefault().toString());
                        toponymSearchCriteria.setQ(searchedPlace.replaceAll(",", " ").replaceAll(" +", " "));
                        logger.log(Level.FINE, "Call to WebService.search for toponym - " + TimingUtility.getInstance().getTime());
                        ToponymSearchResult toponymSearchResult = WebService.search((ToponymSearchCriteria)toponymSearchCriteria);
                        logger.log(Level.FINE, "Answer from WebService.search for toponym- " + TimingUtility.getInstance().getTime());
                        for (Toponym toponym : toponymSearchResult.getToponyms()) {
                            String str;
                            logger.log(Level.FINE, "toponym: Place Name {0} AdminName1 {1} AdminName2 {2} AdminName3 {3} AdminName4 {4} AdminName5 {5}", new Object[]{toponym.getName(), toponym.getAdminName1(), toponym.getAdminName2(), toponym.getAdminName3(), toponym.getAdminName4(), toponym.getAdminName5()});
                            PostalCodeSearchCriteria postalCodeSearchCriteria = new PostalCodeSearchCriteria();
                            postalCodeSearchCriteria.setStyle(Style.FULL);
                            postalCodeSearchCriteria.setPlaceName(toponym.getName());
                            String cc = toponym.getCountryCode();
                            if (cc == null || cc.isEmpty()) continue;
                            postalCodeSearchCriteria.setCountryCode(cc);
                            logger.log(Level.FINE, "Call to WebService.search for postal code - " + TimingUtility.getInstance().getTime());
                            List postalCodeSearchResult = WebService.postalCodeSearch((PostalCodeSearchCriteria)postalCodeSearchCriteria);
                            logger.log(Level.FINE, "Answer from WebService.search for postal code- " + TimingUtility.getInstance().getTime());
                            if (!postalCodeSearchResult.isEmpty()) {
                                for (PostalCode postalCode : postalCodeSearchResult) {
                                    logger.log(Level.FINE, "postalCode AdminName1 {0} AdminName2 {1} AdminName3 {2}", new Object[]{postalCode.getAdminName1(), postalCode.getAdminName2(), postalCode.getAdminName3()});
                                    place = new GeonamesPlace(toponym, postalCode);
                                }
                            } else {
                                place = new GeonamesPlace(toponym, null);
                            }
                            if (tmpListDedup.contains(str = ((Object)place).toString())) continue;
                            GeonamesPlacesList.this.mPlacesList.add(place);
                            tmpListDedup.add(str);
                        }
                        logger.log(Level.FINE, "... search completed.");
                        logger.log(Level.FINE, "   ");
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException("");
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    placesList.addAll(GeonamesPlacesList.this.mPlacesList);
                }
            }
        };
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
            }
        });
        this.theTask.schedule(0);
    }

    public Place searchNearestPlace(double latitude, double longitude) {
        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
        try {
            List results = WebService.findNearbyPlaceName((double)latitude, (double)longitude);
            if (!results.isEmpty()) {
                int geonameId = ((Toponym)results.get(0)).getGeoNameId();
                Toponym toponym = WebService.get((int)geonameId, null, null);
                return new GeonamesPlace(toponym, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getGeonamesMapString(Gedcom gedcom) {
        return gedcom.getRegistry().get(KEYMAP, "");
    }

    public static String[] getGeonamesMap(Gedcom gedcom) {
        String map = "";
        String[] format = null;
        String placeMap = GeonamesPlacesList.getGeonamesMapString(gedcom);
        PlaceFormatConverterPanel pfc = new PlaceFormatConverterPanel(GeonamesPlace.getPlaceFormat(), gedcom.getPlaceFormat(), placeMap);
        pfc.setTextTitle(NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversionTitle"));
        pfc.setLeftTitle(NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversionLeftTitle"));
        pfc.setRightTitle(NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversionRightTitle"));
        Object o = DialogManager.create((String)NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversion"), (JComponent)pfc).setMessageType(-1).show();
        if (o == DialogManager.OK_OPTION) {
            map = pfc.getConversionMapAsString();
            if (!map.replace(",", "").trim().isEmpty()) {
                gedcom.getRegistry().put(KEYMAP, map);
                format = PropertyPlace.getFormat((String)map);
            } else if (placeMap.isEmpty()) {
                DialogManager.create((String)NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesPlacesList.class, (String)"ERR_EmptyConversion")).setMessageType(0).show();
            } else {
                DialogManager.create((String)NbBundle.getMessage(GeonamesPlacesList.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesPlacesList.class, (String)"ERR_NothingSaved")).setMessageType(0).show();
            }
        }
        return format;
    }
}

