/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.util.swing.DialogManager;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openide.util.LookupEvent;

public class TogglePrivate
extends AbstractChange {
    private Collection<? extends Property> properties;
    private boolean makePrivate;

    public TogglePrivate() {
        this.setImageText(MetaProperty.IMG_PRIVATE, resources.getString("private"));
    }

    public TogglePrivate(Collection<? extends Property> properties) {
        this();
        this.properties = properties;
        this.contextChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.properties = this.lkpInfo.allInstances();
        super.resultChanged(ev);
    }

    protected final void contextChanged() {
        if (this.properties.isEmpty()) {
            this.setEnabled(false);
            this.setText(resources.getString("private"));
            this.setTip(resources.getString("private"));
        } else {
            this.setEnabled(true);
            this.makePrivate = true;
            for (Property property : this.properties) {
                if (!property.isPrivate()) continue;
                this.makePrivate = false;
            }
            this.setText(resources.getString(this.makePrivate ? "private" : "public"));
            this.setTip(resources.getString(this.makePrivate ? "private" : "public"));
        }
    }

    @Override
    protected Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        String pwd = gedcom.getPassword();
        if ("unknown".equals(pwd)) {
            DialogManager.createError((String)this.getText(), (String)"This Gedcom file contains encrypted information that has to be decrypted before changing private/public status of other information").setMessageType(2).show();
            return null;
        }
        if (pwd == null && (pwd = DialogManager.create((String)this.getText(), (String)AbstractChange.resources.getString("password", new Object[]{gedcom.getName()}), (String)"").show()) == null) {
            return null;
        }
        boolean recursive = DialogManager.YES_OPTION == DialogManager.createYesNo((String)this.getText(), (String)AbstractChange.resources.getString("recursive"));
        gedcom.setPassword(pwd);
        for (Property property : this.properties) {
            property.setPrivate(this.makePrivate, recursive);
        }
        return null;
    }
}

