/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.Resources;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChoosePropertyBean
extends JComponent {
    private static final Resources RESOURCES = Resources.get(ChoosePropertyBean.class);
    private JRadioButton rbChoose;
    private JRadioButton rbCustom;
    private JTextField tfCustom;
    private JList<MetaProperty> lChoose;
    private JTextPane tpInfo;
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private final Callback callback = new Callback();

    public ChoosePropertyBean(Property parent) {
        MetaProperty[] defs = parent.getNestedMetaProperties(12);
        this.init(defs, true);
    }

    public ChoosePropertyBean(MetaProperty[] defs) {
        this.init(defs, false);
    }

    private void init(MetaProperty[] defs, boolean allowCustom) {
        Arrays.sort(defs, this.callback);
        this.setLayout((LayoutManager)new NestedBlockLayout("<col><label1/><row><tags/><info gx=\"1\" gy=\"1\"/></row><label2/><tag/></col>"));
        this.rbChoose = new JRadioButton(RESOURCES.getString("choose.known"), defs.length > 0);
        this.rbChoose.setEnabled(defs.length > 0);
        this.rbChoose.addItemListener(this.callback);
        this.rbChoose.setAlignmentX(0.0f);
        if (allowCustom) {
            this.add(this.rbChoose);
        } else {
            this.add(new JLabel(RESOURCES.getString("choose.known")));
        }
        this.lChoose = new JList<MetaProperty>(defs);
        this.lChoose.setVisibleRowCount(4);
        this.lChoose.setEnabled(defs.length > 0);
        this.lChoose.setCellRenderer(new MetaDefRenderer());
        this.lChoose.addListSelectionListener(this.callback);
        this.lChoose.addMouseListener(this.callback);
        this.add(new JScrollPane(this.lChoose));
        this.tpInfo = new JTextPane();
        this.tpInfo.setText("");
        this.tpInfo.setEditable(false);
        this.tpInfo.setPreferredSize(new Dimension(256, 256));
        this.add(new JScrollPane(this.tpInfo));
        this.rbCustom = new JRadioButton(RESOURCES.getString("choose.new"), defs.length == 0);
        this.rbCustom.addItemListener(this.callback);
        this.rbCustom.setAlignmentX(0.0f);
        if (allowCustom) {
            this.add(this.rbCustom);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbChoose);
        group.add(this.rbCustom);
        this.tfCustom = new JTextField();
        this.tfCustom.setEnabled(defs.length == 0);
        this.tfCustom.setAlignmentX(0.0f);
        if (allowCustom) {
            this.add(this.tfCustom);
        }
        if (defs.length > 0) {
            this.lChoose.setSelectedIndex(0);
        }
    }

    public void setSingleSelection(boolean set) {
        this.lChoose.setSelectionMode(set ? 0 : 2);
    }

    public String[] getSelectedTags() {
        String[] stringArray;
        if (this.rbChoose.isSelected()) {
            Object[] objs = this.lChoose.getSelectedValues();
            String[] result = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                result[i] = ((MetaProperty)objs[i]).getTag();
            }
            return result;
        }
        String tag = this.tfCustom.getText();
        if (tag != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tag;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private class Callback
    extends MouseAdapter
    implements ItemListener,
    ListSelectionListener,
    Comparator<MetaProperty> {
        private Callback() {
        }

        @Override
        public int compare(MetaProperty m1, MetaProperty m2) {
            return m1.getName().compareTo(m2.getName());
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() > 1) {
                ActionEvent e = new ActionEvent(ChoosePropertyBean.this, 0, null);
                for (ActionListener al : ChoosePropertyBean.this.listeners) {
                    al.actionPerformed(e);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ChoosePropertyBean.this.rbChoose) {
                ChoosePropertyBean.this.lChoose.setEnabled(true);
                ChoosePropertyBean.this.tfCustom.setEnabled(false);
                ChoosePropertyBean.this.lChoose.requestFocusInWindow();
            }
            if (e.getSource() == ChoosePropertyBean.this.rbCustom) {
                ChoosePropertyBean.this.lChoose.clearSelection();
                ChoosePropertyBean.this.lChoose.setEnabled(false);
                ChoosePropertyBean.this.tfCustom.setEnabled(true);
                ChoosePropertyBean.this.tfCustom.requestFocusInWindow();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] selection = ChoosePropertyBean.this.lChoose.getSelectedValues();
            if (selection == null || selection.length == 0) {
                ChoosePropertyBean.this.tpInfo.setText("");
                return;
            }
            MetaProperty meta = (MetaProperty)selection[selection.length - 1];
            ChoosePropertyBean.this.tpInfo.setText(meta.getInfo());
            if (!ChoosePropertyBean.this.rbChoose.isSelected()) {
                ChoosePropertyBean.this.rbChoose.doClick();
            }
        }
    }

    class MetaDefRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer<Object> {
        MetaDefRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            MetaProperty def = (MetaProperty)value;
            this.setText(def.getName() + " (" + def.getTag() + ")");
            this.setIcon((Icon)def.getImage());
            return this;
        }
    }
}

