/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.App;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomFileListener;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.AncestrisViewInterface;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.AncestrisPreferences;
import genj.util.Registry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public final class ActionSaveLayout
implements ActionListener,
GedcomFileListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Context selected = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (selected == null) {
            return;
        }
        Registry prefs = Registry.get(AncestrisTopComponent.class);
        Object date = prefs.get("openViews.date", (String)null) == null ? NbBundle.getMessage(this.getClass(), (String)"TXT_ASL_never") : new Date(new Long(prefs.get("openViews.date", "0")));
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(this.getClass(), (String)"DLG_ActionSaveLayout", (Object)date), NbBundle.getMessage(this.getClass(), (String)"TTL_ActionSaveLayout", (Object)selected.getGedcom().getName()), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (!nd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            return;
        }
        this.saveDefaultLayout(selected.getGedcom(), (AncestrisPreferences)prefs);
    }

    public void saveDefaultLayout(Gedcom gedcom, AncestrisPreferences prefs) {
        ArrayList<String> openedViews = new ArrayList<String>();
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!((AncestrisTopComponent)gjvTc).isOpened() || !gedcom.equals(gjvTc.getGedcom())) continue;
            App.LOG.info(gjvTc.getClass().getName() + ": " + gjvTc.getMode().getName());
            Mode mode = gjvTc.getMode();
            gjvTc.setDefaultMode(mode);
            openedViews.add(gjvTc.getClass().getName());
        }
        prefs.put("openViews", openedViews.toArray());
        prefs.put("openViews.date", System.currentTimeMillis() + "");
    }

    public static void saveLayout(Gedcom gedcom) {
        ArrayList<String> openedViews = new ArrayList<String>();
        ArrayList<String> focusViews = new ArrayList<String>();
        Registry prefs = gedcom.getRegistry();
        TopComponent tcHasFocus = TopComponent.getRegistry().getActivated();
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!((AncestrisTopComponent)gjvTc).isOpened() || !gedcom.equals(gjvTc.getGedcom())) continue;
            App.LOG.info(gjvTc.getClass().getName() + ": " + gjvTc.getMode().getName());
            Mode mode = gjvTc.getMode();
            prefs.put(((AncestrisTopComponent)gjvTc).getPreferencesKey("dockMode"), mode.getName());
            if (gjvTc.equals(mode.getSelectedTopComponent()) && !gjvTc.equals(tcHasFocus)) {
                focusViews.add(gjvTc.getClass().getName());
            }
            openedViews.add(gjvTc.getClass().getName());
        }
        if (tcHasFocus instanceof AncestrisTopComponent) {
            focusViews.add(tcHasFocus.getClass().getName());
        }
        prefs.put("openViews", openedViews);
        prefs.put("focusViews", focusViews);
        prefs.put("openViews.date", System.currentTimeMillis() + "");
    }

    public void commitRequested(Context context) {
    }

    public void gedcomClosed(Gedcom gedcom) {
        ActionSaveLayout.saveLayout(gedcom);
    }

    public void gedcomOpened(Gedcom gedcom) {
    }
}

