/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomFileListener;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.PopupWidget;
import genj.view.SelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.openide.util.actions.Presenter;

public final class ActionHistory
implements Presenter.Toolbar {
    private static HistoryCombo history;

    public Component getToolbarPresenter() {
        if (history == null) {
            history = new HistoryCombo();
        }
        return history;
    }

    private static class HistoryCombo
    extends JPanel {
        private final Icon POPUP = GraphicsHelper.getIcon((Color)Color.BLACK, (double[])new double[]{0.0, 0.0, 8.0, 0.0, 4.0, 4.0});
        private List<Entity> history = new ArrayList<Entity>();
        private int index = -1;
        private EventHandler events = new EventHandler();
        private Back back = new Back();
        private Forward forward = new Forward();
        private Popup pick = new Popup();

        HistoryCombo() {
            this.setLayout(new GridBagLayout());
            this.add((Action)((Object)this.back));
            this.add((Action)((Object)this.forward));
            this.add((Component)((Object)this.pick));
        }

        public Component add(Action a) {
            JButton b = new JButton(a);
            b.setFocusable(false);
            return this.add(b);
        }

        private void fireSelection(Entity e) {
            SelectionDispatcher.fireSelection((Context)new Context(e));
        }

        private void update() {
            this.forward.setEnabled(this.index < this.history.size() - 1);
            this.forward.setTip(this.getEntityText(this.index + 1));
            this.back.setEnabled(this.index > 0);
            this.back.setTip(this.getEntityText(this.index - 1));
            this.pick.setEnabled(this.history.size() > 1);
        }

        private String getEntityText(int i) {
            try {
                Entity e = this.history.get(i);
                return e.toString();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private class EventHandler
        implements SelectionListener,
        GedcomFileListener,
        GedcomListener {
            EventHandler() {
                AncestrisPlugin.register((Object)this);
            }

            public void gedcomClosed(Gedcom gedcom) {
                HistoryCombo.this.history.clear();
                HistoryCombo.this.index = -1;
                HistoryCombo.this.update();
                gedcom.removeGedcomListener((GedcomListener)this);
            }

            public void gedcomOpened(Gedcom gedcom) {
                gedcom.addGedcomListener((GedcomListener)this);
            }

            public void commitRequested(Context context) {
            }

            public void setContext(Context context) {
                Entity e = context.getEntity();
                if (e == null) {
                    return;
                }
                if (!HistoryCombo.this.history.isEmpty() && HistoryCombo.this.history.get(HistoryCombo.this.index) == e) {
                    return;
                }
                while (HistoryCombo.this.history.size() > HistoryCombo.this.index + 1) {
                    HistoryCombo.this.history.remove(HistoryCombo.this.history.size() - 1);
                }
                HistoryCombo.this.history.add(++HistoryCombo.this.index, e);
                while (HistoryCombo.this.history.size() > 16) {
                    HistoryCombo.this.index--;
                    HistoryCombo.this.history.remove(0);
                }
                HistoryCombo.this.update();
            }

            public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            }

            public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
                Entity first;
                int i = HistoryCombo.this.history.indexOf(entity);
                if (i < 0) {
                    return;
                }
                HistoryCombo.this.history.remove(i);
                if (HistoryCombo.this.index >= i) {
                    HistoryCombo.this.index--;
                }
                if (--i < 0 && HistoryCombo.this.history.size() > 0) {
                    ++i;
                }
                if (i >= 0) {
                    HistoryCombo.this.fireSelection((Entity)HistoryCombo.this.history.get(i));
                }
                if (i < 0 && (first = gedcom.getFirstEntity("INDI")) != null) {
                    HistoryCombo.this.fireSelection(first);
                }
                HistoryCombo.this.update();
            }

            public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            }

            public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            }

            public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
            }
        }

        private class Forward
        extends AbstractAncestrisAction {
            public Forward() {
                this.setImage(new ImageIcon(ActionHistory.class.getResource("Forward.png")));
            }

            public void actionPerformed(ActionEvent evt) {
                if (HistoryCombo.this.index == HistoryCombo.this.history.size() - 1) {
                    return;
                }
                HistoryCombo.this.index++;
                HistoryCombo.this.update();
                HistoryCombo.this.fireSelection((Entity)HistoryCombo.this.history.get(HistoryCombo.this.index));
            }
        }

        private class Back
        extends AbstractAncestrisAction {
            public Back() {
                this.setImage(new ImageIcon(ActionHistory.class.getResource("Back.png")));
            }

            public void actionPerformed(ActionEvent evt) {
                if (HistoryCombo.this.index < 1) {
                    return;
                }
                HistoryCombo.this.index--;
                HistoryCombo.this.update();
                HistoryCombo.this.fireSelection((Entity)HistoryCombo.this.history.get(HistoryCombo.this.index));
            }
        }

        private class Jump
        extends AbstractAncestrisAction {
            private int i;

            public Jump(int i) {
                this.i = i;
                Entity entity = (Entity)HistoryCombo.this.history.get(i);
                this.setImage((Icon)entity.getImage());
                this.setText(entity.toString());
            }

            public void actionPerformed(ActionEvent e) {
                HistoryCombo.this.index = this.i;
                HistoryCombo.this.update();
                HistoryCombo.this.fireSelection((Entity)HistoryCombo.this.history.get(this.i));
            }
        }

        private class Popup
        extends PopupWidget {
            Popup() {
                super(HistoryCombo.this.POPUP);
            }

            public void showPopup() {
                this.removeItems();
                for (int i = 0; i < HistoryCombo.this.history.size(); ++i) {
                    JMenuItem item = new JMenuItem((Action)((Object)new Jump(i)));
                    if (HistoryCombo.this.index == i) {
                        item.setFont(item.getFont().deriveFont(1));
                    }
                    this.addItem(item);
                }
                super.showPopup();
            }
        }
    }
}

