/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import ancestris.report.svgtree.output.TreeElements;
import java.awt.Dimension;
import java.awt.Graphics2D;

public abstract class TreeRendererBase
implements GraphicsRenderer {
    protected static final int PAGE_MARGIN = 10;
    protected IndiBox firstIndi;
    protected TreeElements elements;

    public void setFirstIndi(IndiBox firstIndi) {
        this.firstIndi = firstIndi;
    }

    public void setElements(TreeElements elements) {
        this.elements = elements;
    }

    @Override
    public void render(Graphics2D graphics) {
        this.elements.setGraphics(graphics);
        this.render();
    }

    public void render() {
        this.elements.header(this.getImageWidth(), this.getImageHeight());
        this.drawTree(this.firstIndi, this.firstIndi.wMinus + 10, this.firstIndi.hMinus + 10, 0);
        this.elements.footer();
    }

    @Override
    public int getImageWidth() {
        return this.firstIndi.wMinus + this.firstIndi.wPlus + 20;
    }

    @Override
    public int getImageHeight() {
        return this.firstIndi.hMinus + this.firstIndi.hPlus + 20;
    }

    protected abstract void drawLines(IndiBox var1, int var2, int var3);

    protected abstract Dimension getFamboxCoords(IndiBox var1);

    private void drawTree(IndiBox indibox, int baseX, int baseY, int gen) {
        this.drawLines(indibox, baseX += indibox.x, baseY += indibox.y);
        this.elements.drawIndiBox(indibox, baseX, baseY, gen);
        if (indibox.family != null) {
            Dimension coords = this.getFamboxCoords(indibox);
            this.elements.drawFamBox(indibox.family, baseX + coords.width, baseY + coords.height, gen);
        }
        if (indibox.spouse != null) {
            this.drawTree(indibox.spouse, baseX, baseY, gen);
        }
        if (indibox.parent != null) {
            this.drawTree(indibox.parent, baseX, baseY, gen - 1);
        }
        if (indibox.hasChildren()) {
            for (int i = 0; i < indibox.children.length; ++i) {
                this.drawTree(indibox.children[i], baseX, baseY, gen + 1);
            }
        }
        if (indibox.nextMarriage != null) {
            this.drawTree(indibox.nextMarriage, baseX, baseY, gen);
        }
    }
}

