/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.AssociationsTableModel;
import ancestris.modules.editors.genealogyeditor.panels.AssociationEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.ChildrenTablePanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssociationsTablePanel
extends JPanel {
    private Entity mRootEntity;
    private PropertyAssociation mAssociation;
    private final AssociationsTableModel mAssociationsTableModel = new AssociationsTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(AssociationsTablePanel.class);
    private JButton addAssociationButton;
    private EditorTable associationsTable;
    private JScrollPane associationsTableScrollPane;
    private JToolBar associationsToolBar;
    private JButton deleteAssociationButton;
    private JButton editAssociationButton;

    public AssociationsTablePanel() {
        this.initComponents();
        this.associationsTable.setID(AssociationsTablePanel.class.getName());
    }

    private void initComponents() {
        this.associationsToolBar = new JToolBar();
        this.addAssociationButton = new JButton();
        this.editAssociationButton = new JButton();
        this.deleteAssociationButton = new JButton();
        this.associationsTableScrollPane = new JScrollPane();
        this.associationsTable = new EditorTable();
        this.associationsToolBar.setFloatable(false);
        this.associationsToolBar.setRollover(true);
        this.addAssociationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addAssociationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AssociationsTablePanel.addAssociationButton.toolTipText"), new Object[0]));
        this.addAssociationButton.setFocusable(false);
        this.addAssociationButton.setHorizontalTextPosition(0);
        this.addAssociationButton.setVerticalTextPosition(3);
        this.addAssociationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationsTablePanel.this.addAssociationButtonActionPerformed(evt);
            }
        });
        this.associationsToolBar.add(this.addAssociationButton);
        this.editAssociationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editAssociationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AssociationsTablePanel.editAssociationButton.toolTipText"), new Object[0]));
        this.editAssociationButton.setFocusable(false);
        this.editAssociationButton.setHorizontalTextPosition(0);
        this.editAssociationButton.setVerticalTextPosition(3);
        this.editAssociationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationsTablePanel.this.editAssociationButtonActionPerformed(evt);
            }
        });
        this.associationsToolBar.add(this.editAssociationButton);
        this.deleteAssociationButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteAssociationButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("AssociationsTablePanel.deleteAssociationButton.toolTipText"), new Object[0]));
        this.deleteAssociationButton.setFocusable(false);
        this.deleteAssociationButton.setHorizontalTextPosition(0);
        this.deleteAssociationButton.setVerticalTextPosition(3);
        this.deleteAssociationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationsTablePanel.this.deleteAssociationButtonActionPerformed(evt);
            }
        });
        this.associationsToolBar.add(this.deleteAssociationButton);
        this.associationsTable.setModel(this.mAssociationsTableModel);
        this.associationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AssociationsTablePanel.this.associationsTableMouseClicked(evt);
            }
        });
        this.associationsTableScrollPane.setViewportView(this.associationsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationsToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.associationsTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.associationsToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.associationsTableScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addAssociationButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRootEntity.getGedcom();
        int undoNb = gedcom.getUndoNb();
        final AssociationEditorPanel associationEditorPanel = new AssociationEditorPanel();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    AssociationsTablePanel.this.mAssociation = (PropertyAssociation)AssociationsTablePanel.this.mRootEntity.addProperty("ASSO", "@@");
                }
            });
            associationEditorPanel.set(this.mRootEntity, this.mAssociation, null);
            DialogManager.ADialog associationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.create.title"), (JComponent)associationEditorPanel);
            associationEditorDialog.setDialogId(AssociationEditorPanel.class.getName());
            if (associationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            AssociationsTablePanel.this.mAssociationsTableModel.add(associationEditorPanel.commit());
                        }
                    });
                    this.deleteAssociationButton.setEnabled(true);
                    this.editAssociationButton.setEnabled(true);
                    this.changeListner.stateChanged(null);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editAssociationButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.associationsTable.getSelectedRow();
        Gedcom gedcom = this.mRootEntity.getGedcom();
        if (selectedRow != -1) {
            int rowIndex = this.associationsTable.convertRowIndexToModel(selectedRow);
            int undoNb = gedcom.getUndoNb();
            final AssociationEditorPanel associationEditorPanel = new AssociationEditorPanel();
            associationEditorPanel.set(this.mRootEntity, this.mAssociationsTableModel.getValueAt(rowIndex), null);
            DialogManager.ADialog associationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.edit.title"), (JComponent)associationEditorPanel);
            associationEditorDialog.setDialogId(AssociationEditorPanel.class.getName());
            if (associationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            associationEditorPanel.commit();
                        }
                    });
                    this.mAssociationsTableModel.fireTableDataChanged();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
    }

    private void associationsTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int selectedRow = this.associationsTable.getSelectedRow();
            Gedcom gedcom = this.mRootEntity.getGedcom();
            if (selectedRow != -1) {
                int rowIndex = this.associationsTable.convertRowIndexToModel(selectedRow);
                int undoNb = gedcom.getUndoNb();
                final AssociationEditorPanel associationEditorPanel = new AssociationEditorPanel();
                associationEditorPanel.set(this.mRootEntity, this.mAssociationsTableModel.getValueAt(rowIndex), null);
                DialogManager.ADialog associationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(AssociationEditorPanel.class, (String)"AssociationEditorPanel.edit.title"), (JComponent)associationEditorPanel);
                associationEditorDialog.setDialogId(AssociationEditorPanel.class.getName());
                if (associationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                    try {
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                associationEditorPanel.commit();
                            }
                        });
                        this.mAssociationsTableModel.fireTableDataChanged();
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                        gedcom.undoUnitOfWork(false);
                    }
                }
            }
        }
    }

    private void deleteAssociationButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.associationsTable.convertRowIndexToModel(this.associationsTable.getSelectedRow());
        Gedcom gedcom = this.mRootEntity.getGedcom();
        if (rowIndex != -1) {
            final PropertyAssociation individualRef = this.mAssociationsTableModel.getValueAt(rowIndex);
            DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(ChildrenTablePanel.class, (String)"AssociationsTableDialog.deleteAssociation.confirmation.title"), (String)NbBundle.getMessage(ChildrenTablePanel.class, (String)"AssociationsTableDialog.deleteAssociation.confirmation.text", (Object)individualRef.getTargetEntity(), (Object)this.mRootEntity));
            if (createYesNo.show() == DialogManager.YES_OPTION) {
                this.mAssociationsTableModel.remove(rowIndex);
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            AssociationsTablePanel.this.mRootEntity.delProperty((Property)individualRef);
                        }
                    });
                    if (this.mAssociationsTableModel.getRowCount() <= 0) {
                        this.deleteAssociationButton.setEnabled(false);
                        this.editAssociationButton.setEnabled(false);
                    }
                    this.changeListner.stateChanged(null);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void setAssociationsList(Entity rootEntity, List<PropertyAssociation> associationsList) {
        this.mRootEntity = rootEntity;
        this.mAssociationsTableModel.clear();
        this.mAssociationsTableModel.addAll(associationsList);
        if (this.mAssociationsTableModel.getRowCount() > 0) {
            this.deleteAssociationButton.setEnabled(true);
            this.editAssociationButton.setEnabled(true);
        } else {
            this.deleteAssociationButton.setEnabled(false);
            this.editAssociationButton.setEnabled(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            AssociationsTablePanel.this.changeSupport.fireChange();
        }
    }
}

