/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import sun.awt.shell.ShellFolder;

public class MultiMediaObjectCitationsTableModel
extends AbstractTableModel {
    List<Property> multimediaObjectsRefList = new ArrayList<Property>();
    private final String[] columnsName = new String[]{"", NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.ID.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.title.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.fileName.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.title")};

    @Override
    public int getRowCount() {
        return this.multimediaObjectsRefList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.multimediaObjectsRefList.size()) {
            Property multimediaObject = this.multimediaObjectsRefList.get(row);
            switch (column) {
                case 0: {
                    if (multimediaObject instanceof PropertyMedia) {
                        multimediaObject = ((PropertyMedia)multimediaObject).getTargetEntity();
                    }
                    if (multimediaObject instanceof Media && multimediaObject.getGedcom().getGrammar().getVersion().equals("5.5")) {
                        PropertyBlob propertyBlob = (PropertyBlob)multimediaObject.getProperty("BLOB", true);
                        if (propertyBlob != null) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(propertyBlob.getBlobData());
                            try {
                                Image image = ImageIO.read(bais);
                                image = image.getScaledInstance(-1, 16, 1);
                                return new ImageIcon(image);
                            }
                            catch (IOException ex) {
                                return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png"));
                            }
                        }
                        return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png"));
                    }
                    Property propertyfile = multimediaObject.getProperty("FILE", true);
                    if (propertyfile != null && propertyfile instanceof PropertyFile) {
                        File multimediaFile = ((PropertyFile)propertyfile).getFile();
                        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png"));
                        if (multimediaFile != null && multimediaFile.exists()) {
                            try {
                                Image image;
                                try {
                                    image = ImageIO.read(multimediaFile);
                                    if (image != null) {
                                        image = image.getScaledInstance(-1, 16, 1);
                                    }
                                }
                                catch (IOException ex) {
                                    image = ShellFolder.getShellFolder(multimediaFile).getIcon(true);
                                }
                                if (image != null) {
                                    imageIcon = new ImageIcon(image);
                                }
                            }
                            catch (FileNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return imageIcon;
                        }
                        return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png"));
                    }
                    return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png"));
                }
                case 1: {
                    if (multimediaObject instanceof PropertyMedia) {
                        return ((Media)((PropertyMedia)multimediaObject).getTargetEntity()).getId();
                    }
                    return "";
                }
                case 2: {
                    if (multimediaObject instanceof PropertyMedia) {
                        return ((Media)((PropertyMedia)multimediaObject).getTargetEntity()).getTitle();
                    }
                    Property title = multimediaObject.getProperty("TITL", true);
                    if (title != null) {
                        return title.getValue();
                    }
                    return "";
                }
                case 3: {
                    if (multimediaObject instanceof PropertyMedia) {
                        Property propertyFile = ((PropertyMedia)multimediaObject).getTargetEntity().getProperty("FILE", true);
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            File file = ((PropertyFile)propertyFile).getFile();
                            if (file != null) {
                                return file.getAbsolutePath();
                            }
                            return "";
                        }
                        return "";
                    }
                    Property propertyFile = multimediaObject.getProperty("FILE", true);
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        File file = ((PropertyFile)propertyFile).getFile();
                        if (file != null) {
                            return file.getAbsolutePath();
                        }
                        return "";
                    }
                    return "";
                }
                case 4: {
                    if (multimediaObject instanceof PropertyMedia) {
                        if (((PropertyMedia)multimediaObject).getTargetEntity().getProperty("NOTE") != null) {
                            return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.yes");
                        }
                        return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.no");
                    }
                    if (multimediaObject.getProperty("NOTE") != null) {
                        return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.yes");
                    }
                    return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.no");
                }
            }
            return "";
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(Property multimediaObject) {
        this.multimediaObjectsRefList.add(multimediaObject);
        this.fireTableDataChanged();
    }

    public void addAll(List<Property> multimediaObjectsList) {
        this.multimediaObjectsRefList.addAll(multimediaObjectsList);
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.multimediaObjectsRefList.get(row);
    }

    public void remove(int rowIndex) {
        this.multimediaObjectsRefList.remove(rowIndex);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.multimediaObjectsRefList.clear();
    }

    protected ImageIcon createImageIcon(String path, String description) {
        return new ImageIcon(path, description);
    }
}

