/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.beans.ImageBean;
import ancestris.modules.editors.genealogyeditor.beans.SexBean;
import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.genealogyeditor.models.EventsListModel;
import ancestris.modules.editors.genealogyeditor.panels.AliasTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.AssociationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.FamiliesReferenceTreeTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.IndividualEventPanel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NameEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.NamesTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAlias;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertySex;
import genj.gedcom.UnitOfWork;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IndividualEditor
extends EntityEditor {
    private Context context;
    private Context selectedEventContext;
    private Indi mIndividual;
    private Property mEvent = null;
    private Property mMultiMediaObject;
    private boolean updateOnGoing = false;
    private final EventsListModel mEventsListModel = new EventsListModel();
    private static final ArrayList<String> mIndividualEventsTags = new ArrayList<String>(){
        {
            this.add("BIRT");
            this.add("CHR");
            this.add("DEAT");
            this.add("BURI");
            this.add("CREM");
            this.add("ADOP");
            this.add("BAPM");
            this.add("BARM");
            this.add("BASM");
            this.add("BLES");
            this.add("CHRA");
            this.add("CONF");
            this.add("FCOM");
            this.add("ORDN");
            this.add("NATU");
            this.add("EMIG");
            this.add("IMMI");
            this.add("CENS");
            this.add("PROB");
            this.add("WILL");
            this.add("GRAD");
            this.add("RETI");
            this.add("EVEN");
            this.add("CAST");
            this.add("DSCR");
            this.add("EDUC");
            this.add("IDNO");
            this.add("NATI");
            this.add("NCHI");
            this.add("NMR");
            this.add("OCCU");
            this.add("PROP");
            this.add("RELI");
            this.add("RESI");
            this.add("SSN");
            this.add("TITL");
        }
    };
    private DefaultComboBoxModel<String> mEventsModel = new DefaultComboBoxModel<String>(new String[0]);
    private NamesTablePanel namesTablePanel;
    private JLabel SOSALabel;
    private JTextField SOSATextField;
    private AliasTablePanel aliasTablePanel;
    private JPanel associationsPanel;
    private AssociationsTablePanel associationsTablePanel;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JButton deleteEventButton;
    private JComboBox<String> eventTypeComboBox;
    private JList eventsList;
    private JPanel eventsListPanel;
    private JPanel eventsPanel;
    private JSplitPane eventsSplitPane;
    private JPanel familiesChildPanel;
    private FamiliesReferenceTreeTablePanel familiesChildTreeTablePanel;
    private JPanel familiesSpousePanel;
    private FamiliesReferenceTreeTablePanel familiesSpouseTreeTablePanel;
    private Box.Filler filler3;
    private JPanel galleryPanel;
    private JPanel generalPanel;
    private ImageBean imageBean;
    private IndividualEventPanel individualEventEditorPanel;
    private JLabel individualIDLabel;
    private JTextField individualIDTextField;
    private JTabbedPane individualInformationTabbedPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NameEditorPanel nameEditorPanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JToggleButton privateRecordToggleButton;
    private SexBean sexBeanPanel;
    private SourceCitationsTablePanel sourceCitationsTablePanel;
    private JPanel sourcesPanel;

    public IndividualEditor() {
        this(false);
    }

    public IndividualEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.selectedEventContext = null;
        this.eventsList.getSelectionModel().addListSelectionListener(new EventsListSelectionHandler());
        this.individualEventEditorPanel.setVisible(false);
        this.nameEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.individualEventEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.familiesChildTreeTablePanel.addChangeListener((ChangeListener)this.changes);
        this.familiesSpouseTreeTablePanel.addChangeListener((ChangeListener)this.changes);
        this.sourceCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.aliasTablePanel.addChangeListener((ChangeListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.associationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.multimediaObjectCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.sexBeanPanel.addChangeListener((ChangeListener)this.changes);
        JTabbedPane nameEditorTabbedPane = this.nameEditorPanel.getNameEditorTabbedPane();
        this.namesTablePanel = new NamesTablePanel();
        nameEditorTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.namesTablePanel.TabConstraints.tabTitle"), this.namesTablePanel);
        JComboBox.KeySelectionManager manager = new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                System.out.println(aKey);
                return -1;
            }
        };
        this.eventTypeComboBox.setKeySelectionManager(manager);
        this.eventTypeComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.individualIDLabel = new JLabel();
        this.individualIDTextField = new JTextField();
        this.sexBeanPanel = new SexBean();
        this.imageBean = new ImageBean();
        this.privateRecordToggleButton = new JToggleButton();
        this.nameEditorPanel = new NameEditorPanel();
        this.SOSALabel = new JLabel();
        this.SOSATextField = new JTextField();
        this.individualInformationTabbedPane = new JTabbedPane();
        this.eventsPanel = new JPanel();
        this.eventsSplitPane = new JSplitPane();
        this.eventsListPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.eventTypeComboBox = new JComboBox();
        this.filler3 = new Box.Filler(new Dimension(12, 12), new Dimension(12, 12), new Dimension(12, 12));
        this.deleteEventButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.eventsList = new JList();
        this.jPanel1 = new JPanel();
        this.individualEventEditorPanel = new IndividualEventPanel();
        this.familiesChildPanel = new JPanel();
        this.familiesChildTreeTablePanel = new FamiliesReferenceTreeTablePanel(FamiliesReferenceTreeTablePanel.EDIT_FAMC);
        this.familiesSpousePanel = new JPanel();
        this.familiesSpouseTreeTablePanel = new FamiliesReferenceTreeTablePanel(FamiliesReferenceTreeTablePanel.EDIT_FAMS);
        this.sourcesPanel = new JPanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.galleryPanel = new JPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.aliasTablePanel = new AliasTablePanel();
        this.associationsPanel = new JPanel();
        this.associationsTablePanel = new AssociationsTablePanel();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.setMinimumSize(new Dimension(1042, 462));
        this.setName("");
        this.generalPanel.setMinimumSize(new Dimension(1018, 200));
        this.individualIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.individualIDLabel.text"), new Object[0]));
        this.individualIDTextField.setEditable(false);
        this.individualIDTextField.setColumns(8);
        this.individualIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.individualIDTextField.text"), new Object[0]));
        this.individualIDTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.individualIDTextField.toolTipText"), new Object[0]));
        this.sexBeanPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                IndividualEditor.this.sexBeanPanelStateChanged(evt);
            }
        });
        this.imageBean.setBorder(BorderFactory.createEtchedBorder(0));
        this.imageBean.setAlignmentX(0.0f);
        this.imageBean.setAlignmentY(0.0f);
        this.imageBean.setMinimumSize(new Dimension(135, 180));
        this.imageBean.setPreferredSize(new Dimension(130, 173));
        this.imageBean.setRequestFocusEnabled(true);
        this.imageBean.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndividualEditor.this.imageBeanMouseClicked(evt);
            }
        });
        GroupLayout imageBeanLayout = new GroupLayout(this.imageBean);
        this.imageBean.setLayout(imageBeanLayout);
        imageBeanLayout.setHorizontalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        imageBeanLayout.setVerticalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.privateRecordToggleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setMaximumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setMinimumSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setPreferredSize(new Dimension(26, 26));
        this.privateRecordToggleButton.setRolloverIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock_open.png")));
        this.privateRecordToggleButton.setRolloverSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        this.privateRecordToggleButton.setSelectedIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/lock.png")));
        this.nameEditorPanel.setMinimumSize(null);
        this.nameEditorPanel.setPreferredSize(null);
        this.SOSALabel.setText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.SOSALabel.text"));
        this.SOSATextField.setEditable(false);
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.imageBean, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addComponent(this.sexBeanPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.SOSALabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SOSATextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualIDTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.privateRecordToggleButton, -2, -1, -2)).addComponent(this.nameEditorPanel, -1, -1, Short.MAX_VALUE))));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageBean, -2, -1, -2).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sexBeanPanel, -2, -1, -2).addComponent(this.individualIDLabel).addComponent(this.individualIDTextField, -2, -1, -2).addComponent(this.privateRecordToggleButton, -2, -1, -2).addComponent(this.SOSALabel).addComponent(this.SOSATextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameEditorPanel, -2, -1, -2))).addContainerGap()));
        this.individualInformationTabbedPane.setTabLayoutPolicy(1);
        this.individualInformationTabbedPane.setMinimumSize(new Dimension(1018, 219));
        this.eventsSplitPane.setBorder(null);
        this.eventsSplitPane.setDividerSize(1);
        this.eventsListPanel.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.eventTypeComboBox.setModel(this.mEventsModel);
        this.eventTypeComboBox.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.eventTypeComboBox.toolTipText"), new Object[0]));
        this.eventTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEditor.this.eventTypeComboBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.eventTypeComboBox);
        this.jToolBar1.add(this.filler3);
        this.deleteEventButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteEventButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.deleteEventButton.toolTipText"), new Object[0]));
        this.deleteEventButton.setFocusable(false);
        this.deleteEventButton.setHorizontalTextPosition(0);
        this.deleteEventButton.setVerticalTextPosition(3);
        this.deleteEventButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualEditor.this.deleteEventButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.deleteEventButton);
        this.eventsListPanel.add((Component)this.jToolBar1, "North");
        this.eventsList.setModel(this.mEventsListModel);
        this.eventsList.setSelectionMode(0);
        this.eventsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IndividualEditor.this.eventsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.eventsList);
        this.eventsListPanel.add((Component)this.jScrollPane1, "Center");
        this.eventsSplitPane.setLeftComponent(this.eventsListPanel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.individualEventEditorPanel, -1, -1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.individualEventEditorPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.eventsSplitPane.setRightComponent(this.jPanel1);
        GroupLayout eventsPanelLayout = new GroupLayout(this.eventsPanel);
        this.eventsPanel.setLayout(eventsPanelLayout);
        eventsPanelLayout.setHorizontalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eventsSplitPane, GroupLayout.Alignment.TRAILING));
        eventsPanelLayout.setVerticalGroup(eventsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(eventsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.eventsSplitPane).addContainerGap()));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.eventsPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/event.png")), this.eventsPanel);
        GroupLayout familiesChildPanelLayout = new GroupLayout(this.familiesChildPanel);
        this.familiesChildPanel.setLayout(familiesChildPanelLayout);
        familiesChildPanelLayout.setHorizontalGroup(familiesChildPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesChildTreeTablePanel, -1, -1, Short.MAX_VALUE));
        familiesChildPanelLayout.setVerticalGroup(familiesChildPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, familiesChildPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.familiesChildTreeTablePanel, -1, -1, Short.MAX_VALUE)));
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.familiesChildPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/family.png")), this.familiesChildPanel);
        GroupLayout familiesSpousePanelLayout = new GroupLayout(this.familiesSpousePanel);
        this.familiesSpousePanel.setLayout(familiesSpousePanelLayout);
        familiesSpousePanelLayout.setHorizontalGroup(familiesSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesSpouseTreeTablePanel, -1, -1, Short.MAX_VALUE));
        familiesSpousePanelLayout.setVerticalGroup(familiesSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesSpouseTreeTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.familiesSpousePanel.TabConstraints.tabTitle"), new Object[0]), this.familiesSpousePanel);
        GroupLayout sourcesPanelLayout = new GroupLayout(this.sourcesPanel);
        this.sourcesPanel.setLayout(sourcesPanelLayout);
        sourcesPanelLayout.setHorizontalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        sourcesPanelLayout.setVerticalGroup(sourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.sourcesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/source.png")), this.sourcesPanel);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.notesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Note.png")), this.notesPanel);
        GroupLayout galleryPanelLayout = new GroupLayout(this.galleryPanel);
        this.galleryPanel.setLayout(galleryPanelLayout);
        galleryPanelLayout.setHorizontalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        galleryPanelLayout.setVerticalGroup(galleryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multimediaObjectCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"FamilyEditor.galleryPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Media.png")), this.galleryPanel);
        this.individualInformationTabbedPane.addTab(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.aliasTablePanel.TabConstraints.tabTitle"), this.aliasTablePanel);
        GroupLayout associationsPanelLayout = new GroupLayout(this.associationsPanel);
        this.associationsPanel.setLayout(associationsPanelLayout);
        associationsPanelLayout.setHorizontalGroup(associationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationsTablePanel, -1, -1, Short.MAX_VALUE));
        associationsPanelLayout.setVerticalGroup(associationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.associationsTablePanel, -1, -1, Short.MAX_VALUE));
        this.individualInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("IndividualEditor.associationsPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.associationsPanel);
        this.changeDateLabel.setHorizontalAlignment(4);
        this.changeDateLabel.setText(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -2, 173, -2)).addComponent(this.generalPanel, -1, -1, Short.MAX_VALUE).addComponent(this.individualInformationTabbedPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.generalPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualInformationTabbedPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changeDateLabeldate, -2, 15, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.changeDateLabel).addContainerGap()))));
    }

    private void imageBeanMouseClicked(MouseEvent evt) {
        block17: {
            block15: {
                Gedcom gedcom;
                block16: {
                    gedcom = this.mIndividual.getGedcom();
                    this.mMultiMediaObject = this.mIndividual.getProperty("OBJE");
                    if (this.mMultiMediaObject != null) break block15;
                    gedcom.doMuteUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            if (gedcom.getGrammar().getVersion().equals("5.5.1")) {
                                IndividualEditor.this.mMultiMediaObject = (Property)IndividualEditor.this.mIndividual.getGedcom().createEntity("OBJE");
                            } else {
                                IndividualEditor.this.mMultiMediaObject = IndividualEditor.this.mIndividual.addProperty("OBJE", "");
                            }
                        }
                    });
                    MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
                    multiMediaObjectEditor.setContext(new Context(this.mMultiMediaObject));
                    if (!multiMediaObjectEditor.showPanel()) break block16;
                    if (!(this.mMultiMediaObject instanceof Media)) break block17;
                    this.mIndividual.addMedia((Media)this.mMultiMediaObject);
                    this.imageBean.setImage((PropertyFile)this.mMultiMediaObject.getProperty("FILE") != null ? ((PropertyFile)this.mMultiMediaObject.getProperty("FILE")).getFile() : null, this.mIndividual.getSex());
                    this.repaint();
                    this.changes.fireChangeEvent();
                    break block17;
                }
                gedcom.doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (gedcom.getGrammar().getVersion().equals("5.5.1")) {
                            IndividualEditor.this.mIndividual.getGedcom().deleteEntity((Entity)IndividualEditor.this.mMultiMediaObject);
                        } else {
                            IndividualEditor.this.mIndividual.delProperty(IndividualEditor.this.mMultiMediaObject);
                        }
                    }
                });
                break block17;
            }
            for (Property multiMediaObject : this.mIndividual.getProperties("OBJE")) {
                Property multimediaFile;
                Property propertyFormat;
                String objetFormat = null;
                if (this.mIndividual.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                    if (multiMediaObject instanceof PropertyMedia) {
                        propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFormat = multiMediaObject.getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                } else if (multiMediaObject instanceof PropertyMedia) {
                    propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM");
                    if (propertyFormat != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                } else {
                    propertyFormat = multiMediaObject.getProperty("FORM");
                    if (propertyFormat != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                }
                if (objetFormat == null || !objetFormat.equals("bmp") && !objetFormat.equals("gif") && !objetFormat.equals("jpeg") && !objetFormat.equals("jpg") && !objetFormat.equals("png")) continue;
                MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
                multiMediaObjectEditor.setContext(new Context(multiMediaObject));
                if (!multiMediaObjectEditor.showPanel()) break;
                if (multiMediaObject instanceof Media) {
                    this.mIndividual.addMedia((Media)multiMediaObject);
                }
                if (multiMediaObject instanceof PropertyMedia) {
                    multiMediaObject = ((PropertyMedia)multiMediaObject).getTargetEntity();
                }
                if ((multimediaFile = multiMediaObject.getProperty("FILE", true)) != null && multimediaFile instanceof PropertyFile) {
                    this.imageBean.setImage(((PropertyFile)multimediaFile).getFile(), this.mIndividual.getSex());
                } else {
                    PropertyBlob propertyBlob = (PropertyBlob)multiMediaObject.getProperty("BLOB", true);
                    this.imageBean.setImage(propertyBlob != null ? propertyBlob.getBlobData() : (byte[])null, this.mIndividual.getSex());
                }
                this.repaint();
                this.changes.fireChangeEvent();
                break;
            }
        }
    }

    private void deleteEventButtonActionPerformed(ActionEvent evt) {
        Property event;
        DialogManager createYesNo;
        final int index = this.eventsList.getSelectedIndex();
        Gedcom gedcom = this.mIndividual.getGedcom();
        if (index != -1 && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventsList.deleteEventConfirmation.title", (Object)PropertyTag2Name.getTagName((event = this.mEventsListModel.getValueAt(index)).getTag())), (String)NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventsList.deleteEventConfirmation.text", (Object)PropertyTag2Name.getTagName(event.getTag()), (Object)this.mIndividual))).show() == DialogManager.YES_OPTION) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        IndividualEditor.this.mIndividual.delProperty(IndividualEditor.this.mEventsListModel.remove(index));
                    }
                });
                ArrayList<Property> eventsProperties = new ArrayList<Property>();
                for (Property property : this.mIndividual.getProperties()) {
                    if (!mIndividualEventsTags.contains(property.getTag())) continue;
                    eventsProperties.add(property);
                }
                this.seteventTypeComboBox(eventsProperties);
                this.eventsList.setSelectedIndex(0);
                this.changes.fireChangeEvent();
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void eventTypeComboBoxActionPerformed(ActionEvent evt) {
        if (!this.updateOnGoing) {
            Gedcom gedcom = this.mIndividual.getGedcom();
            this.mEvent = null;
            if (this.eventTypeComboBox.getSelectedIndex() > 0) {
                final String eventType = this.eventTypeComboBox.getSelectedItem().toString();
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            IndividualEditor.this.mEvent = IndividualEditor.this.mIndividual.addProperty(PropertyTag2Name.getPropertyTag(eventType), "");
                            Logger.getLogger("ancestris").info(IndividualEditor.this.mEvent.getTag());
                            if (IndividualEditor.this.mEvent.getTag().matches("(BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI)")) {
                                IndividualEditor.this.mEvent.setValue("y");
                            }
                        }
                    });
                    if (this.mEvent != null) {
                        ArrayList<Property> eventsProperties = new ArrayList<Property>();
                        for (Property property : this.mIndividual.getProperties()) {
                            if (!mIndividualEventsTags.contains(property.getTag())) continue;
                            eventsProperties.add(property);
                        }
                        this.seteventTypeComboBox(eventsProperties);
                        if (this.mEventsListModel.indexOf(this.mEvent) == -1) {
                            this.mEventsListModel.add(this.mEvent);
                        }
                        this.eventsList.setSelectedIndex(this.mEventsListModel.indexOf(this.mEvent));
                        this.changes.fireChangeEvent();
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void eventsListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            return;
        }
        int index = this.eventsList.getSelectedIndex();
        if (index != -1 && index < this.mEventsListModel.getSize()) {
            Property prop = this.mEventsListModel.getValueAt(index);
            this.selectedEventContext = new Context(prop);
        }
    }

    private void sexBeanPanelStateChanged(ChangeEvent evt) {
        if (this.imageBean.isDefault()) {
            this.imageBean.setImage((File)null, this.sexBeanPanel.getSelectedSex());
        }
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Indi) {
            Property prop;
            this.mIndividual = (Indi)entity;
            this.setTitle(NbBundle.getMessage(IndividualEditor.class, (String)(this.isNew() ? "IndividualEditor.create.title" : "IndividualEditor.edit.title"), (Object)this.mIndividual));
            String gedcomVersion = this.mIndividual.getGedcom().getGrammar().getVersion();
            if (!gedcomVersion.equals("5.5.1")) {
                this.privateRecordToggleButton.setVisible(false);
            }
            this.individualIDTextField.setText(this.mIndividual.getId());
            String tag = "";
            if (this.mIndividual.getProperty("_SOSADABOVILLE") != null) {
                tag = "_SOSADABOVILLE";
            } else if (this.mIndividual.getProperty("_SOSA") != null) {
                tag = "_SOSA";
            } else if (this.mIndividual.getProperty("_DABOVILLE") != null) {
                tag = "_DABOVILLE";
            }
            Property SOSANumber = this.mIndividual.getProperty(tag, true);
            if (SOSANumber != null) {
                this.SOSALabel.setVisible(true);
                this.SOSATextField.setVisible(true);
                this.SOSATextField.setText(SOSANumber.getValue());
            } else {
                this.SOSALabel.setVisible(false);
                this.SOSATextField.setVisible(false);
                this.SOSATextField.setText("");
            }
            Property restrictionNotice = this.mIndividual.getProperty("RESN", true);
            if (restrictionNotice != null) {
                this.privateRecordToggleButton.setSelected(true);
            } else {
                this.privateRecordToggleButton.setSelected(false);
            }
            List namesList = this.mIndividual.getProperties(PropertyName.class);
            if (namesList.size() > 0) {
                PropertyName name = (PropertyName)namesList.remove(0);
                if (name != null) {
                    this.nameEditorPanel.set(this.mIndividual, name);
                }
            } else {
                this.nameEditorPanel.set(this.mIndividual, null);
            }
            this.namesTablePanel.set(this.mIndividual, namesList);
            PropertySex sex = (PropertySex)this.mIndividual.getProperty("SEX", true);
            if (sex == null) {
                this.mIndividual.setSex(0);
                sex = (PropertySex)this.mIndividual.getProperty("SEX", true);
            }
            this.sexBeanPanel.set((Property)this.mIndividual, sex);
            ArrayList<Property> individualEvents = new ArrayList<Property>();
            for (Property property : this.mIndividual.getProperties()) {
                if (!mIndividualEventsTags.contains(property.getTag())) continue;
                individualEvents.add(property);
            }
            Collections.sort(individualEvents, new Comparator<Property>(){

                @Override
                public int compare(Property p1, Property p2) {
                    PropertyDate pDate1 = (PropertyDate)p1.getProperty("DATE");
                    PropertyDate pDate2 = (PropertyDate)p2.getProperty("DATE");
                    if (pDate1 == null && pDate2 == null) {
                        return 0;
                    }
                    if (pDate1 != null && pDate2 == null) {
                        return 1;
                    }
                    if (pDate1 == null && pDate2 != null) {
                        return -1;
                    }
                    return pDate1.compareTo((Property)pDate2);
                }
            });
            this.mEventsListModel.clear();
            this.mEventsListModel.addAll(individualEvents);
            this.seteventTypeComboBox(individualEvents);
            int index = 0;
            Property property = prop = this.selectedEventContext == null ? context.getProperty() : this.selectedEventContext.getProperty();
            if (prop != null && (index = this.mEventsListModel.indexOf(prop)) == -1) {
                index = 0;
            }
            this.eventsList.setSelectedIndex(index);
            this.familiesChildTreeTablePanel.setFamiliesList((Property)this.mIndividual, this.mIndividual.getProperties(PropertyFamilyChild.class));
            this.familiesSpouseTreeTablePanel.setFamiliesList((Property)this.mIndividual, this.mIndividual.getProperties(PropertyFamilySpouse.class));
            this.associationsTablePanel.setAssociationsList((Entity)this.mIndividual, this.mIndividual.getProperties(PropertyAssociation.class));
            this.aliasTablePanel.set(this.mIndividual, this.mIndividual.getProperties(PropertyAlias.class));
            Property changeDate = this.mIndividual.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
            this.noteCitationsTablePanel.set((Property)this.mIndividual, Arrays.asList(this.mIndividual.getProperties("NOTE")));
            this.sourceCitationsTablePanel.set((Property)this.mIndividual, Arrays.asList(this.mIndividual.getProperties("SOUR")));
            Property[] multiMediaObjects = this.mIndividual.getProperties("OBJE");
            boolean found = false;
            for (Property multiMediaObject : this.mIndividual.getProperties("OBJE")) {
                Property multimediaFile;
                Property propertyFormat;
                String objetFormat = null;
                if (this.mIndividual.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                    if (multiMediaObject instanceof PropertyMedia) {
                        propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    } else {
                        propertyFormat = multiMediaObject.getPropertyByPath(".:FILE:FORM");
                        if (propertyFormat != null) {
                            objetFormat = propertyFormat.getValue();
                        }
                    }
                } else if (multiMediaObject instanceof PropertyMedia) {
                    propertyFormat = ((Media)((PropertyMedia)multiMediaObject).getTargetEntity()).getProperty("FORM");
                    if (propertyFormat != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                } else {
                    propertyFormat = multiMediaObject.getProperty("FORM");
                    if (propertyFormat != null) {
                        objetFormat = propertyFormat.getValue();
                    }
                }
                if (objetFormat == null || !objetFormat.equals("bmp") && !objetFormat.equals("gif") && !objetFormat.equals("jpeg") && !objetFormat.equals("jpg") && !objetFormat.equals("png")) continue;
                if (multiMediaObject instanceof PropertyMedia) {
                    multiMediaObject = ((PropertyMedia)multiMediaObject).getTargetEntity();
                }
                if ((multimediaFile = multiMediaObject.getProperty("FILE", true)) != null && multimediaFile instanceof PropertyFile) {
                    this.imageBean.setImage(((PropertyFile)multimediaFile).getFile(), this.mIndividual.getSex());
                } else {
                    PropertyBlob propertyBlob = (PropertyBlob)multiMediaObject.getProperty("BLOB", true);
                    this.imageBean.setImage(propertyBlob != null ? propertyBlob.getBlobData() : (byte[])null, this.mIndividual.getSex());
                }
                found = true;
                break;
            }
            if (!found) {
                this.imageBean.setImage((File)null, this.mIndividual.getSex());
            }
            this.multimediaObjectCitationsTablePanel.set((Property)this.mIndividual, Arrays.asList(multiMediaObjects));
        }
    }

    public void commit() {
        Property restrictionNotice = this.mIndividual.getProperty("RESN", true);
        if (this.privateRecordToggleButton.isSelected()) {
            if (restrictionNotice == null) {
                this.mIndividual.addProperty("RESN", "confidential");
            }
        } else if (restrictionNotice != null) {
            this.mIndividual.delProperty(restrictionNotice);
        }
        this.nameEditorPanel.commit();
        this.sexBeanPanel.commit();
        this.individualEventEditorPanel.commit();
    }

    private void seteventTypeComboBox(List<Property> eventsList) {
        ArrayList<String> localizedEventsList = new ArrayList<String>();
        for (String tag : mIndividualEventsTags) {
            localizedEventsList.add(PropertyTag2Name.getTagName(tag));
        }
        for (Property event : eventsList) {
            if (event.getTag().equals("CENS") || event.getTag().equals("EMIG") || event.getTag().equals("EVEN") || event.getTag().equals("GRAD") || event.getTag().equals("IMMI") || event.getTag().equals("NATI") || event.getTag().equals("NATU") || event.getTag().equals("OCCU") || event.getTag().equals("PROB") || event.getTag().equals("PROP") || event.getTag().equals("RELI") || event.getTag().equals("RESI") || event.getTag().equals("TITL")) continue;
            localizedEventsList.remove(PropertyTag2Name.getTagName(event.getTag()));
        }
        Collections.sort(localizedEventsList);
        this.updateOnGoing = true;
        this.mEventsModel.removeAllElements();
        this.mEventsModel.addElement(NbBundle.getMessage(IndividualEditor.class, (String)"IndividualEditor.eventTypeComboBox.firstElement.title"));
        for (String tag : localizedEventsList) {
            this.mEventsModel.addElement(tag);
        }
        this.updateOnGoing = false;
    }

    public Entity getEditedEntity() {
        return this.mIndividual;
    }

    private class EventsListSelectionHandler
    implements ListSelectionListener {
        private EventsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            ListSelectionModel lsm = (ListSelectionModel)lse.getSource();
            if (!lse.getValueIsAdjusting() && !lsm.isSelectionEmpty() && lsm.getMinSelectionIndex() < IndividualEditor.this.mEventsListModel.getSize()) {
                IndividualEditor.this.individualEventEditorPanel.set((Property)IndividualEditor.this.mIndividual, IndividualEditor.this.mEventsListModel.getValueAt(lsm.getMinSelectionIndex()));
                IndividualEditor.this.individualEventEditorPanel.setVisible(true);
            }
        }
    }
}

