/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.swing.Updateable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

public class ChoiceWidget
extends JComboBox {
    private boolean isTemplate = false;
    private Model model = new Model();
    private boolean isIgnoreCase = false;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        @Override
        public void fireChangeEvent() {
            ChoiceWidget.this.isTemplate = false;
            super.fireChangeEvent();
        }
    };
    private AutoCompleteSupport autoComplete;
    private Updateable updater = null;
    private boolean valuesAreLoaded = false;

    public ChoiceWidget() {
        this(new Object[0], null);
    }

    public ChoiceWidget(List<?> values) {
        this(values.toArray(), null);
    }

    public ChoiceWidget(Object[] values, Object selection) {
        this.setEditable(true);
        this.setMaximumRowCount(8);
        this.setModel(this.model);
        this.model.setValues(values);
        this.setAlignmentX(0.0f);
        this.setSelectedItem(selection);
    }

    private void updateValues() {
        if (!this.valuesAreLoaded && this.updater != null) {
            this.setValues(this.updater.getValues());
        }
        this.valuesAreLoaded = true;
    }

    public void setUpdater(Updateable updater) {
        this.updater = updater;
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ChoiceWidget.this.updateValues();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setValues(List<?> values) {
        this.setValues(values.toArray());
    }

    public void setValues(Object[] set) {
        if (set == null) {
            return;
        }
        try {
            this.autoComplete.disable();
            this.model.setValues(set);
        }
        finally {
            this.autoComplete.enable();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        result.width = Math.min(128, result.width);
        return result;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean set) {
    }

    public void setTemplate(boolean set) {
        this.isTemplate = set;
    }

    public String getText() {
        if (this.isTemplate) {
            return "";
        }
        if (this.isEditable()) {
            return this.getEditor().getItem().toString();
        }
        return super.getSelectedItem().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        if (!this.isEditable) {
            throw new IllegalArgumentException("setText && !isEditable n/a");
        }
        this.model.setSelectedItem(null);
        try {
            this.autoComplete.disable();
            try {
                JTextField t = this.getTextEditor();
                t.setText(text);
                t.setCaretPosition(0);
            }
            catch (Throwable t) {
                try {
                    PlainDocument doc = new PlainDocument(new StringContent(255));
                    doc.insertString(0, text, null);
                    this.getTextEditor().setDocument(doc);
                }
                catch (Throwable retry) {
                    Logger.getLogger("ancestris.util.swing").log(Level.FINE, "Couldn't retry " + this.getTextEditor().getClass() + ".setText(" + text + ")", retry);
                    Logger.getLogger("ancestris.util.swing").log(Level.WARNING, "Couldn't call " + this.getTextEditor().getClass() + ".setText(" + text + ") - giving up", t);
                }
            }
        }
        finally {
            this.autoComplete.enable();
        }
    }

    public JTextField getTextEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public void setIgnoreCase(boolean set) {
        this.isIgnoreCase = set;
    }

    @Override
    public void setPopupVisible(boolean v) {
        super.setPopupVisible(v);
        if (v) {
            String pre = this.getText();
            for (int i = 0; i < this.getItemCount(); ++i) {
                String item = this.getItemAt(i).toString();
                if (!item.regionMatches(this.isIgnoreCase, 0, pre, 0, pre.length())) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEditable()) {
            return this.getEditor().getEditorComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void setEditor(final ComboBoxEditor editor) {
        if (!(editor.getEditorComponent() instanceof JTextField)) {
            throw new IllegalArgumentException("Only JTextEditor editor components are allowed");
        }
        ((JTextField)editor.getEditorComponent()).setColumns(4);
        super.setEditor(new ComboBoxEditor(){

            @Override
            public void setItem(Object anObject) {
                try {
                    ChoiceWidget.this.autoComplete.disable();
                    editor.setItem(anObject);
                }
                finally {
                    ChoiceWidget.this.autoComplete.enable();
                }
            }

            @Override
            public void selectAll() {
                editor.selectAll();
            }

            @Override
            public void removeActionListener(ActionListener l) {
                editor.removeActionListener(l);
            }

            @Override
            public Object getItem() {
                return editor.getItem();
            }

            @Override
            public Component getEditorComponent() {
                return editor.getEditorComponent();
            }

            @Override
            public void addActionListener(ActionListener l) {
                editor.addActionListener(l);
            }
        });
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteSupport();
        }
        this.autoComplete.attach(this.getTextEditor());
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.getEditor().addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.getEditor().removeActionListener(l);
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object[] values = new Object[0];
        private Object selection = null;

        private Model() {
        }

        private void setValues(Object[] set) {
            this.selection = null;
            if (this.values.length > 0) {
                this.fireIntervalRemoved(this, 0, this.values.length - 1);
            }
            this.values = set;
        }

        @Override
        public Object getSelectedItem() {
            return this.selection;
        }

        private String setSelectedPrefix(String prefix) {
            if (this.values.length == 0) {
                ChoiceWidget.this.updateValues();
            }
            for (int i = 0; i < this.values.length; ++i) {
                String value = this.values[i].toString();
                if (!value.regionMatches(ChoiceWidget.this.isIgnoreCase, 0, prefix, 0, prefix.length())) continue;
                this.setSelectedItem(value);
                return value;
            }
            return "";
        }

        @Override
        public void setSelectedItem(Object seLection) {
            this.selection = seLection;
            try {
                ChoiceWidget.this.autoComplete.disable();
                ChoiceWidget.this.getEditor().setItem(this.selection);
            }
            finally {
                ChoiceWidget.this.autoComplete.enable();
            }
            ChoiceWidget.this.fireItemStateChanged(new ItemEvent(ChoiceWidget.this, 701, this.selection, 1));
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getElementAt(int index) {
            return this.values[index];
        }

        @Override
        public int getSize() {
            return this.values.length;
        }
    }

    private class AutoCompleteSupport
    extends KeyAdapter
    implements DocumentListener,
    ActionListener,
    FocusListener,
    PropertyChangeListener {
        private JTextField text;
        private Timer timer = new Timer(250, this);
        private boolean enabled = true;

        private AutoCompleteSupport() {
            this.timer.setRepeats(false);
        }

        private void disable() {
            this.enabled = false;
            this.timer.stop();
        }

        private void enable() {
            this.enabled = true;
        }

        private void attach(JTextField set) {
            if (this.text != null) {
                this.text.getDocument().removeDocumentListener(this);
                this.text.removeFocusListener(this);
                this.text.removeKeyListener(this);
                this.text.removePropertyChangeListener(this);
            }
            this.text = set;
            this.text.getDocument().addDocumentListener(this);
            this.text.addFocusListener(this);
            this.text.addKeyListener(this);
            this.text.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("document")) {
                ((Document)evt.getOldValue()).removeDocumentListener(this);
                ((Document)evt.getNewValue()).addDocumentListener(this);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String prefix = this.text.getText();
            if (prefix.length() == 0) {
                return;
            }
            int caretPos = this.text.getCaretPosition();
            String match = ChoiceWidget.this.model.setSelectedPrefix(prefix);
            if (match.length() == 0) {
                ChoiceWidget.this.hidePopup();
                return;
            }
            try {
                this.disable();
                this.text.setText(prefix);
            }
            finally {
                this.enable();
            }
            this.text.setCaretPosition(caretPos);
            if (match.length() >= prefix.length() && ChoiceWidget.this.isShowing()) {
                ChoiceWidget.this.showPopup();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.text.getDocument() != null) {
                this.text.setCaretPosition(this.text.getDocument().getLength());
                this.text.moveCaretPosition(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && ChoiceWidget.this.isPopupVisible()) {
                ChoiceWidget.this.model.setSelectedItem(ChoiceWidget.this.model.getSelectedItem());
                ChoiceWidget.this.setPopupVisible(false);
                e.consume();
            }
        }
    }
}

