/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintEditor;
import genj.renderer.DPI;
import genj.renderer.MediaRenderer;
import genj.util.Dimension2d;
import genj.util.EnvironmentChecker;
import genj.util.swing.ImageIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;

public class BlueprintRenderer {
    private static final ImageIcon BROKEN = new ImageIcon(BlueprintEditor.class, "Broken.png");
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    public static final String HINT_KEY_TXT = "txt";
    public static final String HINT_KEY_IMG = "img";
    public static final String HINT_KEY_SHORT = "short";
    public static final String HINT_VALUE_TRUE = "yes";
    public static final String HINT_VALUE_FALSE = "no";
    private static final String STARS = "*****";
    private static final int IMAGE_GAP = 4;
    private static final Stroke DEBUG_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private static final int PROP_IMAGE_WIDTH;
    private static final int PROP_IMAGE_HEIGHT;
    private static final Segment EMPTY_SEGMENT;
    private RootView root;
    private HTMLDocument doc = new MyHTMLDocument();
    private MyHTMLFactory factory = new MyHTMLFactory();
    private static DTD dtd;
    private Property entity;
    private List<MyView> volatileViews = new ArrayList<MyView>(64);
    private List<View> tableViews = new ArrayList<View>(4);
    private boolean isDebug = false;
    private Graphics2D graphics;
    private Font plain;
    private Font bold;
    private Font italic;
    private Font bolditalic;

    public BlueprintRenderer(Blueprint bp) {
        StringBuffer html = new StringBuffer();
        html.append("<html<body>");
        html.append(bp.getHTML());
        html.append("</body></html>");
        try {
            MyHTMLReader reader = new MyHTMLReader(this.doc);
            new MyDocumentParser(DTD.getDTD("html32")).parse(new StringReader(html.toString()), reader, false);
            reader.flush();
        }
        catch (Throwable t) {
            Logger.getLogger("ancestris.renderer").log(Level.WARNING, "can't parse blueprint " + bp, t);
        }
        this.root = new RootView(this.factory.create(this.doc.getDefaultRootElement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, Property e, Rectangle r) {
        this.entity = e;
        this.graphics = (Graphics2D)g;
        Font font = g.getFont();
        if (EnvironmentChecker.isWindows()) {
            float factor = (float)DPI.get(this.graphics).vertical() / 72.0f;
            font = font.deriveFont(factor * font.getSize2D());
        }
        this.plain = font;
        this.bold = font.deriveFont(1);
        this.italic = font.deriveFont(2);
        this.bolditalic = font.deriveFont(3);
        try {
            for (MyView pv : this.volatileViews) {
                pv.invalidate();
            }
            for (View tv : this.tableViews) {
                tv.replace(0, 0, null);
            }
            this.root.setSize((float)r.getWidth(), (float)r.getHeight());
            Rectangle oc = g.getClipBounds();
            g.clipRect(r.x, r.y, r.width, r.height);
            try {
                this.root.paint(g, r);
            }
            finally {
                g.setClip(oc.x, oc.y, oc.width, oc.height);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "can't render", t);
        }
    }

    public void setDebug(boolean set) {
        this.isDebug = set;
    }

    protected Property getProperty(Property entity, TagPath path) {
        return entity.getProperty(path);
    }

    static {
        new ParserDelegator();
        PROP_IMAGE_WIDTH = Indi.IMG_MALE.getIconWidth() + 4;
        PROP_IMAGE_HEIGHT = Indi.IMG_MALE.getIconHeight();
        EMPTY_SEGMENT = new Segment();
        dtd = null;
    }

    private class PropertyView
    extends MyView {
        private Map<String, String> attributes;
        private TagPath path;
        private Property cachedProperty;
        private Dimension2D cachedSize;

        PropertyView(Element elem) {
            block4: {
                super(elem);
                this.path = null;
                this.cachedProperty = null;
                this.cachedSize = null;
                this.attributes = new HashMap<String, String>();
                Enumeration<?> as = elem.getAttributes().getAttributeNames();
                while (as.hasMoreElements()) {
                    Object key = as.nextElement();
                    if (!(key instanceof String)) continue;
                    this.attributes.put((String)key, (String)elem.getAttributes().getAttribute(key));
                }
                Object p = elem.getAttributes().getAttribute("path");
                if (p != null) {
                    try {
                        this.path = new TagPath((String)p);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOG.isLoggable(Level.FINER)) break block4;
                        LOG.log(Level.FINER, "got wrong path " + p);
                    }
                }
            }
        }

        private int getAttribute(String key, int min, int max, int def) {
            String val = this.attributes.get(key);
            if (val != null) {
                try {
                    return Math.max(min, Math.min(max, Integer.parseInt(val)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return def;
        }

        private Property getProperty() {
            if (this.cachedProperty != null) {
                return this.cachedProperty;
            }
            if (BlueprintRenderer.this.entity == null || this.path == null) {
                return null;
            }
            this.cachedProperty = BlueprintRenderer.this.getProperty(BlueprintRenderer.this.entity, this.path);
            return this.cachedProperty;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Property prop = this.getProperty();
            if (prop == null) {
                return;
            }
            Graphics2D graphics = (Graphics2D)g;
            Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            Color fg = super.getForeground();
            if (BlueprintRenderer.this.isDebug) {
                Stroke stroke = graphics.getStroke();
                graphics.setStroke(DEBUG_STROKE);
                g.setColor(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 32));
                graphics.draw(r);
                graphics.setStroke(stroke);
            }
            Shape old = graphics.getClip();
            graphics.clip(r);
            g.setColor(fg);
            g.setFont(super.getFont());
            this.render(prop, graphics, r);
            g.setClip(old);
        }

        private void render(Property prop, Graphics2D g, Rectangle r) {
            if (!(prop instanceof Entity) && prop instanceof MultiLineProperty) {
                this.render((MultiLineProperty)((Object)prop), g, r);
                return;
            }
            if (prop instanceof PropertyFile || prop instanceof PropertyBlob) {
                MediaRenderer.render(g, r, prop);
                return;
            }
            if (BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_IMG))) {
                this.render(prop instanceof PropertyDate ? prop.getParent().getImage(false) : prop.getImage(false), g, r);
            }
            if (!BlueprintRenderer.HINT_VALUE_FALSE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_TXT))) {
                this.render(this.getText(prop), g, r);
            }
        }

        private void render(MultiLineProperty mle, Graphics2D g, Rectangle r) {
            MultiLineProperty.Iterator line = mle.getLineIterator();
            Graphics2D graphics = g;
            Font font = g.getFont();
            FontRenderContext context = graphics.getFontRenderContext();
            float x = (float)r.getX();
            float y = (float)r.getY();
            do {
                String txt = line.getValue();
                LineMetrics lm = font.getLineMetrics(txt, context);
                graphics.drawString(txt, x, (y += lm.getHeight()) - lm.getDescent());
            } while (!((double)y > r.getMaxY()) && line.next());
        }

        private void render(ImageIcon img, Graphics2D g, Rectangle bounds) {
            if (bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0) {
                return;
            }
            int w = img.getIconWidth();
            int max = g.getFontMetrics().getHeight();
            AffineTransform at = AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY());
            if (max < img.getIconHeight()) {
                float scale = (float)max / (float)img.getIconHeight();
                at.scale(scale, scale);
                w = (int)Math.ceil((float)w * scale);
            }
            g.drawImage(img.getImage(), at, null);
            bounds.x += w + 4;
            bounds.width -= w + 4;
        }

        private String getText(Property prop) {
            if (prop instanceof Entity) {
                return this.getText((Entity)prop);
            }
            if (prop.isPrivate()) {
                return BlueprintRenderer.STARS;
            }
            if (prop instanceof PropertyPlace) {
                return this.getText((PropertyPlace)prop);
            }
            if (prop instanceof PropertySex) {
                return this.getText((PropertySex)prop);
            }
            if (this.attributes.get("format") != null) {
                return prop.format(this.attributes.get("format"));
            }
            return prop.getDisplayValue();
        }

        private String getText(Entity entity) {
            return entity.getId();
        }

        private String getText(PropertySex sex) {
            String result;
            if (!this.attributes.containsKey(BlueprintRenderer.HINT_KEY_TXT)) {
                this.attributes.put(BlueprintRenderer.HINT_KEY_TXT, BlueprintRenderer.HINT_VALUE_FALSE);
            }
            if (!this.attributes.containsKey(BlueprintRenderer.HINT_KEY_IMG)) {
                this.attributes.put(BlueprintRenderer.HINT_KEY_IMG, BlueprintRenderer.HINT_VALUE_TRUE);
            }
            if ((result = sex.getDisplayValue()).length() > 0 && BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_SHORT))) {
                result = result.substring(0, 1);
            }
            return result;
        }

        private String getText(PropertyPlace place) {
            return Utilities.html2text(place.format(this.attributes.get("format")));
        }

        @Override
        protected Dimension2D getPreferredSpan() {
            if (this.cachedSize != null) {
                return this.cachedSize;
            }
            this.cachedSize = this.getSize();
            return this.cachedSize;
        }

        private Dimension2D getSize() {
            Property prop = this.getProperty();
            if (prop == null) {
                return new Dimension();
            }
            if (!(prop instanceof Entity) && prop instanceof MultiLineProperty) {
                return this.getSize((MultiLineProperty)((Object)prop));
            }
            if (prop instanceof PropertyFile || prop instanceof PropertyBlob) {
                return MediaRenderer.getSize(prop, this.getGraphics());
            }
            return this.getSize(prop);
        }

        private Dimension2D getSize(Property prop) {
            String txt = this.getText(prop);
            double w = 0.0;
            double h = 0.0;
            BlueprintRenderer.this.graphics.setFont(super.getFont());
            FontMetrics fm = BlueprintRenderer.this.graphics.getFontMetrics();
            if (!BlueprintRenderer.HINT_VALUE_FALSE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_TXT)) && txt.length() > 0) {
                w += (double)fm.stringWidth(txt);
                h = Math.max(h, (double)(fm.getAscent() + fm.getDescent()));
            }
            if (BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_IMG))) {
                ImageIcon img = prop.getImage(false);
                float max = fm.getHeight();
                float scale = 1.0f;
                if (max < (float)img.getIconHeight()) {
                    scale = max / (float)img.getIconHeight();
                }
                w += (double)((int)Math.ceil((float)img.getIconWidth() * scale) + 4);
                h = Math.max(h, (double)fm.getHeight());
            }
            return new Dimension2d(w, h);
        }

        private Dimension2D getSize(MultiLineProperty mle) {
            BlueprintRenderer.this.graphics.setFont(super.getFont());
            FontMetrics fm = BlueprintRenderer.this.graphics.getFontMetrics();
            int lines = 0;
            double width = 0.0;
            double height = 0.0;
            MultiLineProperty.Iterator line = mle.getLineIterator();
            do {
                ++lines;
                width = Math.max(width, (double)fm.stringWidth(line.getValue()));
                height += (double)fm.getHeight();
            } while (line.next());
            return new Dimension2d(width, height);
        }

        @Override
        protected void invalidate() {
            this.cachedProperty = null;
            this.cachedSize = null;
            super.invalidate();
        }
    }

    private class MediaView
    extends MyView {
        private TagPath path2root;

        MediaView(Element elem) {
            block3: {
                super(elem);
                this.path2root = null;
                Object p = elem.getAttributes().getAttribute("path");
                if (p != null) {
                    try {
                        this.path2root = new TagPath((String)p);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOG.isLoggable(Level.FINER)) break block3;
                        LOG.log(Level.FINER, "got wrong path " + p);
                    }
                }
            }
        }

        private Property getRoot() {
            Property result = null;
            if (this.path2root != null) {
                result = BlueprintRenderer.this.entity.getProperty(this.path2root);
            }
            return result != null ? result : BlueprintRenderer.this.entity;
        }

        @Override
        protected Dimension2D getPreferredSpan() {
            Dimension size = MediaRenderer.getSize(this.getRoot(), BlueprintRenderer.this.graphics);
            if (BlueprintRenderer.this.isDebug && ((Dimension2D)size).getWidth() == 0.0 && ((Dimension2D)size).getHeight() == 0.0) {
                return BROKEN.getSizeInPoints(DPI.get(BlueprintRenderer.this.graphics));
            }
            return size;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Dimension size;
            Rectangle r = allocation.getBounds();
            if (BlueprintRenderer.this.isDebug && ((Dimension2D)(size = MediaRenderer.getSize(this.getRoot(), BlueprintRenderer.this.graphics))).getWidth() == 0.0 && ((Dimension2D)size).getHeight() == 0.0) {
                BROKEN.paintIcon(g, r.x, r.y);
                return;
            }
            MediaRenderer.render(g, r, this.getRoot());
        }
    }

    private class I18NView
    extends MyView {
        private String txt;
        private TagPath path;

        private I18NView(Element elem) {
            super(elem);
            this.txt = "?";
            this.path = null;
            Object o = elem.getAttributes().getAttribute("tag");
            if (o != null) {
                this.txt = Gedcom.getName(o.toString());
            } else {
                o = elem.getAttributes().getAttribute("path");
                if (o != null) {
                    this.path = new TagPath(o.toString());
                } else {
                    o = elem.getAttributes().getAttribute("entity");
                    if (o != null) {
                        this.txt = Gedcom.getName(o.toString());
                    }
                }
            }
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
            g.setFont(this.getFont());
            g.setColor(this.getForeground());
            this.render(this.getRenderedText(), (Graphics2D)g, r);
        }

        @Override
        protected Dimension2D getPreferredSpan() {
            FontMetrics fm = BlueprintRenderer.this.graphics.getFontMetrics(this.getFont());
            return new Dimension(fm.stringWidth(this.getRenderedText()), fm.getAscent() + fm.getDescent());
        }

        private String getRenderedText() {
            if (this.path != null) {
                String txt = BlueprintRenderer.this.entity.getProperty(this.path).getTag();
                if ("EVEN".equals(txt)) {
                    txt = BlueprintRenderer.this.entity.getProperty(this.path).getPropertyValue("TYPE");
                    if (txt.isEmpty()) {
                        txt = Gedcom.getName("EVEN");
                    }
                    return txt;
                }
                return Gedcom.getName(BlueprintRenderer.this.entity.getProperty(this.path).getTag());
            }
            return this.txt;
        }
    }

    private class RootView
    extends View {
        private View view;
        private float width;
        private float height;

        RootView(View view) {
            super(null);
            this.view = view;
            view.setParent(this);
        }

        @Override
        public float getPreferredSpan(int axis) {
            throw new RuntimeException("getPreferredSpan() is not supported");
        }

        @Override
        public int viewToModel(float arg0, float arg1, Shape arg2, Position.Bias[] arg3) {
            throw new RuntimeException("viewToModel() is not supported");
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            throw new RuntimeException("modelToView() is not supported");
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            this.view.paint(g, allocation);
        }

        @Override
        public Document getDocument() {
            return BlueprintRenderer.this.doc;
        }

        @Override
        public Graphics getGraphics() {
            return BlueprintRenderer.this.graphics;
        }

        @Override
        public void setSize(float wIdth, float heIght) {
            this.width = wIdth;
            this.height = heIght;
            try {
                this.view.setSize(this.width, this.height);
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "unexpected", t);
            }
        }

        @Override
        public ViewFactory getViewFactory() {
            return BlueprintRenderer.this.factory;
        }
    }

    private abstract class MyView
    extends View {
        private Font font;
        private Color foreground;
        private Dimension2D preferredSpan;
        private int max;

        MyView(Element elem) {
            super(elem);
            this.font = null;
            this.foreground = null;
            this.preferredSpan = null;
            this.max = 0;
            try {
                this.max = Integer.parseInt((String)elem.getAttributes().getAttribute("max"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public int viewToModel(float arg0, float arg1, Shape arg2, Position.Bias[] arg3) {
            throw new RuntimeException("viewToModel() is not supported");
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            throw new RuntimeException("modelToView() is not supported");
        }

        @Override
        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 1) {
                return 0;
            }
            if (len > this.getPreferredSpan(0)) {
                return 1000;
            }
            return 0;
        }

        @Override
        public View breakView(int axis, int offset, float pos, float len) {
            return this;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (this.preferredSpan == null) {
                this.preferredSpan = this.getPreferredSpan();
                if (this.max > 0) {
                    double maxWidth = BlueprintRenderer.this.root.width * (float)this.max / 100.0f;
                    if (this.preferredSpan.getWidth() > maxWidth) {
                        this.preferredSpan = new Dimension2d(maxWidth, this.preferredSpan.getHeight() * maxWidth / this.preferredSpan.getWidth());
                    }
                }
            }
            return (float)(axis == 0 ? this.preferredSpan.getWidth() : this.preferredSpan.getHeight());
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getAlignment(int axis) {
            if (0 == axis) {
                return super.getAlignment(axis);
            }
            float height = (float)this.getPreferredSpan().getHeight();
            FontMetrics fm = this.getGraphics().getFontMetrics();
            float h = fm.getHeight();
            float d = fm.getDescent();
            return (h - d) / height;
        }

        @Override
        public Graphics getGraphics() {
            BlueprintRenderer.this.graphics.setFont(this.getFont());
            return BlueprintRenderer.this.graphics;
        }

        protected Color getForeground() {
            if (this.foreground == null) {
                this.foreground = BlueprintRenderer.this.doc.getForeground(BlueprintRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.foreground;
        }

        protected Font getFont() {
            if (this.font == null) {
                this.font = BlueprintRenderer.this.doc.getFont(BlueprintRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.font;
        }

        protected abstract Dimension2D getPreferredSpan();

        protected void invalidate() {
            this.preferredSpan = null;
            this.font = null;
            super.preferenceChanged(this, true, true);
        }

        @Override
        public ViewFactory getViewFactory() {
            return BlueprintRenderer.this.factory;
        }

        protected void render(String txt, Graphics2D g, Rectangle r) {
            if (txt.length() == 0) {
                return;
            }
            TextLayout layout = new TextLayout(txt, g.getFont(), g.getFontRenderContext());
            layout.draw(g, (float)r.getX(), (float)r.getY() + layout.getAscent());
        }
    }

    private class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyHTMLFactory() {
        }

        @Override
        public View create(Element elem) {
            String name = elem.getName();
            if ("prop".equals(name)) {
                PropertyView result = new PropertyView(elem);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            if ("name".equals(name) || "i18n".equals(name)) {
                return new I18NView(elem);
            }
            if ("media".equals(name)) {
                MediaView result = new MediaView(elem);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            View result = super.create(elem);
            if ("table".equals(elem.getName())) {
                BlueprintRenderer.this.tableViews.add(result);
            }
            return result;
        }
    }

    private static class MyHTMLReader
    extends HTMLDocument.HTMLReader {
        private boolean skipContent;

        protected MyHTMLReader(HTMLDocument doc) {
            HTMLDocument hTMLDocument = doc;
            hTMLDocument.getClass();
            super(hTMLDocument, 0);
            this.skipContent = false;
        }

        @Override
        protected void blockClose(HTML.Tag t) {
            this.skipContent = true;
            super.blockClose(t);
            this.skipContent = false;
        }

        @Override
        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            if (!this.skipContent) {
                super.addContent(data, offs, length, generateImpliedPIfNecessary);
            }
        }
    }

    private class MyDocumentParser
    extends DocumentParser {
        private MyDocumentParser(DTD dtd) {
            super(dtd);
            this.strict = true;
        }
    }

    private class MyHTMLDocument
    extends HTMLDocument {
        private MyHTMLDocument() {
        }

        @Override
        public Font getFont(AttributeSet attr) {
            Font result = BlueprintRenderer.this.plain;
            if (StyleConstants.isBold(attr) && StyleConstants.isItalic(attr)) {
                result = BlueprintRenderer.this.bolditalic;
            } else if (StyleConstants.isBold(attr)) {
                result = BlueprintRenderer.this.bold;
            } else if (StyleConstants.isItalic(attr)) {
                result = BlueprintRenderer.this.italic;
            }
            if (attr.isDefined(StyleConstants.FontSize)) {
                result = result.deriveFont((float)StyleConstants.getFontSize(attr));
            }
            return result;
        }
    }
}

