/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlueprintManager {
    private static final String SUFFIX = ".html";
    private static final Registry REGISTRY = Registry.get(BlueprintManager.class);
    private static final Resources RESOURCES = Resources.get(BlueprintManager.class);
    public static final String TXT_BLUEPRINT = RESOURCES.getString("blueprint");
    private static final String[][] DEFAULTS = new String[][]{{"INDI", "default", "complete", "verbose", "colorful", "professional", "simple", "pastel", "light", "small"}, {"FAM", "default", "complete", "simple", "pastel", "light", "small"}, {"OBJE", "default", "complete", "55"}, {"NOTE", "default", "complete"}, {"SOUR", "default", "complete"}, {"SUBM", "default", "complete"}, {"REPO", "default", "complete"}};
    static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private Map<String, List<Blueprint>> tag2blueprints = new HashMap<String, List<Blueprint>>();
    private static BlueprintManager instance;

    public static BlueprintManager getInstance() {
        if (instance == null) {
            instance = new BlueprintManager();
        }
        return instance;
    }

    private BlueprintManager() {
        for (int t = 0; t < DEFAULTS.length; ++t) {
            String[] defaults = DEFAULTS[t];
            String tag = defaults[0];
            for (int i = 1; i < defaults.length; ++i) {
                String key = defaults[i];
                String name = RESOURCES.getString("blueprints." + key, false);
                if (name == null) {
                    name = key;
                }
                try {
                    this.addBlueprint(this.loadBlueprint(this.getClass().getResourceAsStream("blueprints/" + tag + "/" + key + SUFFIX), tag, name, true));
                    continue;
                }
                catch (Throwable e) {
                    LOG.warning("can't read pre-defined blueprint " + tag + "/" + key);
                }
            }
        }
        this.loadBlueprints();
    }

    private File getBlueprintDirectory() {
        return new File(EnvironmentChecker.getProperty("user.home.ancestris/blueprints", "?", "Looking for blueprints"));
    }

    private File getBlueprintFile(Blueprint blueprint) throws IOException {
        if (blueprint.getName().indexOf(34) >= 0) {
            throw new IOException("Quotes are not allowed in blueprint names");
        }
        return new File(this.getBlueprintDirectory(), "/" + blueprint.getTag() + "/" + blueprint.getName() + SUFFIX).getCanonicalFile();
    }

    void saveBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isDirty()) {
            return;
        }
        File file = this.getBlueprintFile(blueprint);
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs() || !parent.isDirectory()) {
            throw new IOException("Cannot create folder for blueprint " + blueprint.getName());
        }
        this.readwrite(new StringReader(blueprint.getHTML()), new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        blueprint.clearDirty();
        LOG.log(Level.INFO, "saved blueprint " + file);
    }

    private void loadBlueprints() {
        File dir = this.getBlueprintDirectory();
        try {
            if (!dir.isDirectory() || !dir.exists()) {
                return;
            }
            for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                this.loadBlueprints(dir, Gedcom.ENTITIES[i]);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "unexpected throwable loading blueprints from " + dir, t);
        }
    }

    private void loadBlueprints(File dir, String tag) throws IOException {
        if (!(dir = new File(dir, tag)).isDirectory() || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int b = 0; b < files.length; ++b) {
            File file = files[b];
            String name = file.getName();
            if (!name.endsWith(SUFFIX) || file.isDirectory()) continue;
            name = name.substring(0, name.length() - SUFFIX.length());
            Blueprint blueprint = this.loadBlueprint(new FileInputStream(file), tag, name, false);
            blueprint.clearDirty();
            this.addBlueprint(blueprint);
        }
    }

    private Blueprint loadBlueprint(InputStream in, String tag, String name, boolean readOnly) throws IOException {
        StringWriter html = new StringWriter(512);
        this.readwrite(new InputStreamReader(in, "UTF8"), html);
        in.close();
        return new Blueprint(tag, name, html.toString(), readOnly);
    }

    private void readwrite(Reader in, Writer out) throws IOException {
        String line;
        BufferedReader bin = new BufferedReader(in);
        BufferedWriter bout = new BufferedWriter(out);
        while ((line = bin.readLine()) != null) {
            bout.write(line);
            bout.newLine();
        }
        bin.close();
        bout.close();
    }

    public Blueprint getBlueprint(String tag, String name) {
        if (name.length() == 0) {
            name = "Default";
        }
        List<Blueprint> bps = this.getBlueprints(tag);
        for (int i = 0; i < bps.size(); ++i) {
            Blueprint bp = bps.get(i);
            if (!bp.getName().equals(name)) continue;
            return bp;
        }
        if (bps.isEmpty()) {
            return new Blueprint("<html></html>");
        }
        return bps.get(0);
    }

    public List<Blueprint> getBlueprints(String tag) {
        return Collections.unmodifiableList(this.getBlueprintsInternal(tag));
    }

    private List<Blueprint> getBlueprintsInternal(String tag) {
        List<Blueprint> result = this.tag2blueprints.get(tag);
        if (result == null) {
            result = new ArrayList<Blueprint>();
            this.tag2blueprints.put(tag, result);
        }
        return result;
    }

    public Blueprint addBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isReadOnly()) {
            this.getBlueprintFile(blueprint);
        }
        List<Blueprint> blueprints = this.getBlueprintsInternal(blueprint.getTag());
        ListIterator<Blueprint> it = blueprints.listIterator();
        while (it.hasNext()) {
            Blueprint other = it.next();
            if (!other.getName().equalsIgnoreCase(blueprint.getName())) continue;
            if (other.isReadOnly()) {
                throw new IOException("Can't overwrite read-only blueprint");
            }
            it.remove();
            break;
        }
        if (!blueprint.isReadOnly()) {
            this.saveBlueprint(blueprint);
        }
        blueprints.add(blueprint);
        return blueprint;
    }

    public void delBlueprint(Blueprint blueprint) throws IOException {
        if (blueprint.isReadOnly()) {
            throw new IOException("Can't delete read-only Blueprint");
        }
        if (!blueprint.isReadOnly() && !this.getBlueprintFile(blueprint).delete()) {
            throw new IOException("Couldn't delete blueprint " + blueprint);
        }
        this.getBlueprintsInternal(blueprint.getTag()).remove(blueprint);
    }
}

