/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileAssociation {
    private static Logger LOG = Logger.getLogger("ancestris.io");
    private static List<FileAssociation> associations = new LinkedList<FileAssociation>();
    private Set<String> suffixes = new HashSet<String>();
    private String name = "";
    private String executable = "";
    private boolean usedesktop = false;

    public FileAssociation() {
    }

    public FileAssociation(String s) throws IllegalArgumentException {
        StringTokenizer tokens = new StringTokenizer(s, "*");
        if (tokens.countTokens() != 3) {
            throw new IllegalArgumentException("need three *-separators");
        }
        this.setSuffixes(tokens.nextToken());
        this.name = tokens.nextToken();
        this.executable = tokens.nextToken();
    }

    public FileAssociation(String suffixes, String name, String executable) throws IllegalArgumentException {
        this.setSuffixes(suffixes);
        this.name = name;
        this.executable = executable;
    }

    public String toString() {
        return this.getSuffixes() + "*" + this.name + "*" + this.executable;
    }

    public void setName(String set) {
        this.name = set;
    }

    public String getName() {
        return this.name;
    }

    public void useDesktop(boolean use) {
        this.usedesktop = use;
    }

    public boolean useDesktop() {
        return this.usedesktop;
    }

    public void setExecutable(String set) {
        this.executable = set;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setSuffixes(String set) {
        StringTokenizer ss = new StringTokenizer(set, ",");
        if (ss.countTokens() == 0) {
            throw new IllegalArgumentException("need at least one suffix");
        }
        this.suffixes.clear();
        while (ss.hasMoreTokens()) {
            this.suffixes.add(ss.nextToken().trim());
        }
    }

    public String getSuffixes() {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = this.suffixes.iterator();
        while (it.hasNext()) {
            result.append((Object)it.next());
            if (!it.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    public void execute(URL url) {
        new Thread(new Sequence(url)).start();
    }

    public void execute(File file) {
        new Thread(new Sequence(file.getAbsolutePath())).start();
    }

    public void execute(String command) {
        new Thread(new Sequence(command)).start();
    }

    public static String[] parse(String cmd) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer token = new StringBuffer(32);
        boolean quoted = false;
        block4: for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    if (quoted) {
                        token.append(c);
                        continue block4;
                    }
                    if (token.length() > 0) {
                        tokens.add(token.toString());
                    }
                    token.setLength(0);
                    continue block4;
                }
                case '\"': {
                    if (quoted) {
                        tokens.add(token.toString());
                        token.setLength(0);
                        quoted = false;
                        continue block4;
                    }
                    if (token.length() > 0) {
                        tokens.add(token.toString());
                    }
                    token.setLength(0);
                    quoted = true;
                    continue block4;
                }
                default: {
                    token.append(c);
                }
            }
        }
        if (quoted) {
            LOG.warning("Umatched quotes in " + cmd);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static List<FileAssociation> getAll() {
        return new ArrayList<FileAssociation>(associations);
    }

    public static List<FileAssociation> getAll(String suffix) {
        ArrayList<FileAssociation> result = new ArrayList<FileAssociation>();
        for (FileAssociation fa : associations) {
            if (!fa.suffixes.contains(suffix)) continue;
            result.add(fa);
        }
        return result;
    }

    public static String getSuffix(File file) {
        return FileAssociation.getSuffix(file.getName());
    }

    public static String getSuffix(String file) {
        Matcher m = Pattern.compile(".*\\.(.*)$").matcher(file);
        return m.matches() ? m.group(1) : "";
    }

    public static FileAssociation get(File file, String name, Component owner) {
        if (file.isDirectory()) {
            return FileAssociation.get("[dir]", "[dir]", "Directory", owner);
        }
        String suffix = FileAssociation.getSuffix(file);
        if (suffix.length() == 0) {
            return null;
        }
        return FileAssociation.get(suffix, suffix, name, owner);
    }

    public static void open(URL url, Component owner) {
        if ("file".equals(url.getProtocol())) {
            try {
                String decodedFileName = URLDecoder.decode(url.getFile(), "UTF-8");
                File file = new File(decodedFileName);
                FileAssociation fa = FileAssociation.get(file, "Open", owner);
                if (fa != null) {
                    fa.execute(file);
                }
            }
            catch (UnsupportedEncodingException decodedFileName) {}
        } else {
            FileAssociation fa = FileAssociation.get("html", "html, htm, xml", "Browse", owner);
            if (fa != null) {
                fa.execute(url);
            }
        }
    }

    public static FileAssociation get(String suffix, String suffixes, String name, Component owner) {
        FileAssociation fa2;
        for (FileAssociation fa2 : associations) {
            if (!fa2.suffixes.contains(suffix)) continue;
            return fa2;
        }
        fa2 = new FileAssociation();
        fa2.setName("Ouvrir");
        fa2.useDesktop(true);
        return fa2;
    }

    public static boolean del(FileAssociation fa) {
        return associations.remove(fa);
    }

    public static FileAssociation add(FileAssociation fa) {
        if (!associations.contains(fa)) {
            associations.add(fa);
        }
        return fa;
    }

    private class Sequence
    implements Runnable {
        private Object param;

        Sequence(String file) {
            this.param = file;
        }

        Sequence(URL url) {
            this.param = url;
        }

        @Override
        public void run() {
            this.runCommands();
        }

        private void runCommands() {
            if (FileAssociation.this.useDesktop() || this.param instanceof URL) {
                try {
                    if (this.param instanceof URL) {
                        Desktop.getDesktop().browse(((URL)this.param).toURI());
                    } else {
                        Desktop.getDesktop().open(new File((String)this.param));
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FileAssociation.class.getName()).log(Level.SEVERE, null, ex);
                }
                return;
            }
            StringTokenizer cmds = new StringTokenizer(FileAssociation.this.getExecutable(), "&");
            while (cmds.hasMoreTokens()) {
                this.runCommand(cmds.nextToken().trim());
            }
        }

        private void runCommand(String cmd) {
            String file = (String)this.param;
            if (cmd.indexOf(37) < 0) {
                cmd = cmd + " " + (file.indexOf(32) < 0 ? "%" : "\"%\"");
            }
            String suffix = FileAssociation.getSuffix(file);
            String pathRegEx = file.replaceAll("\\\\", "\\\\\\\\");
            String pathNoSuffixRegEx = pathRegEx.substring(0, pathRegEx.length() - suffix.length() - 1);
            cmd = Pattern.compile("%(\\.[a-zA-Z]*)").matcher(cmd).replaceAll(pathNoSuffixRegEx + "$1");
            cmd = Pattern.compile("%").matcher(cmd).replaceAll(pathRegEx);
            String[] cmdarray = FileAssociation.parse(cmd);
            LOG.info("Running command: " + Arrays.asList(cmdarray));
            try {
                int rc = Runtime.getRuntime().exec(cmdarray).waitFor();
                if (rc != 0) {
                    LOG.log(Level.INFO, "External returned " + rc);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "External threw " + t.getMessage(), t);
            }
        }
    }
}

