/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.List;

public abstract class PropertyXRef
extends Property {
    private PropertyXRef target = null;
    private String value = "";

    protected PropertyXRef(String tag) {
        super(tag);
    }

    @Override
    void beforeDelNotify() {
        if (this.target != null) {
            PropertyXRef other = this.target;
            Property pother = other.getParent();
            this.unlink();
            pother.delProperty(other);
        }
        super.beforeDelNotify();
    }

    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    public Property getTargetParent() {
        return this.target == null ? null : this.target.getParent();
    }

    protected Entity getCandidate() throws GedcomException {
        if (this.target != null) {
            throw new IllegalArgumentException("Already linked");
        }
        Entity entity = this.getGedcom().getEntity(this.getTargetType(), this.value);
        if (entity == null) {
            throw new GedcomException(resources.getString("error.notfound", Gedcom.getName(this.getTargetType()), this.value));
        }
        return entity;
    }

    protected boolean isCandidate(Entity entity) {
        if (this.target != null) {
            return false;
        }
        return this.value.length() == 0 || entity.getId().equals(this.value);
    }

    @Override
    public String getValue() {
        return this.target != null ? '@' + this.target.getEntity().getId() + '@' : '@' + this.value + '@';
    }

    @Override
    public boolean isValid() {
        return this.target != null;
    }

    public abstract void link() throws GedcomException;

    protected void link(PropertyXRef target) {
        if (this.target != null) {
            throw new IllegalArgumentException("can't link while target!=null");
        }
        if (target == null) {
            throw new IllegalArgumentException("can't link to targe null");
        }
        this.target = target;
        target.target = this;
        this.propagateXRefLinked(this, target);
    }

    public void unlink() {
        if (this.target == null) {
            throw new IllegalArgumentException("can't unlink without target");
        }
        PropertyXRef old = this.target;
        this.target.target = null;
        this.target = null;
        this.propagateXRefUnlinked(this, old);
    }

    @Override
    public String getDisplayValue() {
        if (this.target == null) {
            return this.getValue();
        }
        return this.target.getEntity().toString();
    }

    protected String getForeignDisplayValue() {
        Entity entity = this.getEntity();
        Property parent = this.getParent();
        String by = parent != entity ? entity.toString() + " - " + parent.getPropertyName() : entity.toString();
        return resources.getString("foreign.xref", by);
    }

    public PropertyXRef getTarget() {
        return this.target;
    }

    @Override
    public void setValue(String set) {
        if (this.target != null) {
            return;
        }
        String old = this.getParent() == null ? null : this.getValue();
        this.value = set.replace('@', ' ').trim();
        if (old != null) {
            this.propagatePropertyChanged(this, old);
        }
    }

    @Override
    public String toString() {
        Entity e = this.getTargetEntity();
        if (e == null) {
            return super.toString();
        }
        return e.toString();
    }

    public abstract String getTargetType();

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        String key = "prop." + this.getTag().toLowerCase() + ".veto";
        String result = resources.getString(key, false);
        if (result == null) {
            result = resources.getString("prop.xref.veto");
        }
        return result;
    }

    public static Entity[] getReferences(Entity ent) {
        ArrayList<Entity> result = new ArrayList<Entity>(10);
        List<PropertyXRef> ps = ent.getProperties(PropertyXRef.class);
        for (PropertyXRef px : ps) {
            PropertyXRef target = px.getTarget();
            if (target == null) continue;
            result.add(target.getEntity());
        }
        return result.toArray(new Entity[result.size()]);
    }

    @Override
    public ImageIcon getImage(boolean checkValid) {
        return this.overlay(super.getImage(false));
    }

    protected ImageIcon overlay(ImageIcon img) {
        ImageIcon overlay = this.target != null ? MetaProperty.IMG_LINK : MetaProperty.IMG_ERROR;
        return img.getOverLayed(overlay);
    }

    @Override
    public void setPrivate(boolean set, boolean recursively) {
    }

    @Override
    public PropertyComparator2 getComparator() {
        return XREFComparator.getInstance();
    }

    private static class XREFComparator
    extends PropertyComparator2.Default<PropertyXRef> {
        private static final XREFComparator INSTANCE = new XREFComparator();

        private XREFComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public String getSortGroup(PropertyXRef p) {
            Entity e = p.getTargetEntity();
            if (e == null) {
                return "";
            }
            return e.getDisplayComparator().getSortGroup(e);
        }

        @Override
        public int compare(PropertyXRef p1, PropertyXRef p2) {
            Entity e2;
            int r = this.compareNull(p1, p2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            Entity e1 = p1.getTargetEntity();
            r = this.compareNull(e1, e2 = p2.getTargetEntity());
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            if (e1.getClass() != e2.getClass()) {
                return e1.toString().compareTo(e2.toString());
            }
            return e1.getDisplayComparator().compare(e1, e2);
        }
    }
}

