/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;

public class PropertyQuality
extends Property {
    private String value = "";
    public static final String[] QUALITIES = Gedcom.resources.getString("QUAY.vals", false).split(",");

    public PropertyQuality(String tag) {
        super(tag);
    }

    public PropertyQuality() {
        this("QUAY");
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public void setQuality(int quality) {
        if (quality < -1 || quality > 3) {
            throw new IllegalArgumentException("invalid quality value " + quality);
        }
        String old = this.getValue();
        this.value = quality < 0 ? "" : String.valueOf(quality);
        super.propagatePropertyChanged(this, old);
    }

    public int getQuality() {
        try {
            int result = Integer.parseInt(this.value);
            if (result >= 0 && result <= 3) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

