/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.renderer.RenderOptions;
import genj.util.Registry;
import genj.util.Resources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JToolTip;

public class BpToolTip
extends JToolTip {
    static final Resources resources = Resources.get(BpToolTip.class);
    private static final Blueprint BLUEPRINT_SELECT = new Blueprint(resources.getString("html.select"));
    private static final Registry REGISTRY = Registry.get(BpToolTip.class);
    private BlueprintRenderer renderer = null;
    private Map<String, Blueprint> type2blueprint = new HashMap<String, Blueprint>();
    private boolean isAntialiasing = true;
    private Entity entity;
    private static BpToolTip instance;

    public BpToolTip() {
        this.setOpaque(false);
        BlueprintManager bpm = BlueprintManager.getInstance();
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.type2blueprint.put(tag, bpm.getBlueprint(tag, ""));
        }
        this.isAntialiasing = REGISTRY.get("antial", false);
    }

    public static BpToolTip getdefault() {
        if (instance == null) {
            instance = new BpToolTip();
        }
        return instance;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        Blueprint blueprint = entity == null ? BLUEPRINT_SELECT : this.getBlueprint(entity.getTag());
        this.renderer = new BlueprintRenderer(blueprint);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(256, 256);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.entity == null || this.renderer == null) {
            return;
        }
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(4.0f, 4.0f, this.getWidth() - 1 - 8, this.getHeight() - 1 - 8, 15.0f, 15.0f);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(this.getBounds());
        g2.fill(round);
        g2.setColor(new Color(0, 0, 0));
        g2.setStroke(new BasicStroke(2.0f));
        g2.draw(round);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setColor(Color.BLACK);
        g2.setFont(RenderOptions.getInstance().getDefaultFont());
        this.renderer.render(g2, this.entity, new Rectangle(4, 4, this.getWidth() - 9, this.getHeight() - 9));
    }

    private Blueprint getBlueprint(String tag) {
        Blueprint result = this.type2blueprint.get(tag);
        if (result != null && "tooltip".equals(result.getName())) {
            return result;
        }
        result = BlueprintManager.getInstance().getBlueprint(tag, "tooltip");
        if (result == null) {
            result = BlueprintManager.getInstance().getBlueprint(tag, "complete");
        }
        this.type2blueprint.put(tag, result);
        return result;
    }

    public void setAntialiasing(boolean set) {
        this.isAntialiasing = set;
        this.repaint();
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }
}

