/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.narrative;

import ancestris.reports.narrative.Utterance;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public class ReportNarrative
extends Report {
    public static final int DETAIL_NO_SHOW = 0;
    public static final int DETAIL_NAME = 1;
    public static final int DETAIL_BRIEF = 2;
    public static final int DETAIL_DATES = 3;
    public static final int DETAIL_BRIEF_WITH_DATES = 2;
    public static final int DETAIL_FULL = 5;
    public static final int DETAIL_EVERYTHING = 6;
    public boolean ancestors = true;
    public boolean showIds = false;
    public boolean showRefns = false;
    public boolean withNameIndex = true;
    public boolean withPlaceIndex = true;
    private boolean withBibliography = false;
    public boolean showImages = true;
    public boolean includePersonalTags = false;
    public boolean includeUnknownTags = false;
    public boolean useAbbrevations = false;
    public int maxGenerations = 99;
    public String htmlStylesheet = null;
    private boolean alignImages = true;
    public boolean noAds = false;
    private String nameIndexTitle;
    private String placeIndexTitle;
    private String sourceIndexTitle;

    public Object start(Gedcom gedcom) {
        String resource = this.ancestors ? "ancestors.of" : "descendants.of";
        Indi indi = (Indi)this.getEntityFromUser(this.translate(resource), gedcom, "INDI");
        if (indi == null) {
            return null;
        }
        return this.start(indi);
    }

    public Object startTest(Gedcom gedcom, String startingIndiTag) {
        Indi indi = (Indi)gedcom.getEntity("INDI", startingIndiTag);
        return this.start(indi);
    }

    public Entity getStartingEntity(String msg, Gedcom gedcom, String tag) {
        return this.getEntityFromUser(msg, gedcom, tag);
    }

    public Document start(Indi indi) {
        Set nextGen;
        this.println("indi = " + indi.getName());
        this.nameIndexTitle = this.withNameIndex ? this.translate("index.names") : null;
        this.placeIndexTitle = this.withPlaceIndex ? this.translate("index.places") : null;
        this.sourceIndexTitle = this.withBibliography ? this.translate("bibliography") : null;
        String title = this.getUtterance(this.ancestors ? "doc.ancestors.title" : "doc.descendants.title", new String[]{new IndiWriter(indi, null).getName(indi)}).toString();
        Document doc = new Document(title);
        doc.startSection(title, 1);
        if (!this.noAds) {
            Utterance ad = this.getUtterance("doc.ad.1");
            PropertyDate dateFormatter = new PropertyDate();
            dateFormatter.setValue(PropertyDate.DATE, PointInTime.getPointInTime((long)System.currentTimeMillis()), null, "");
            ad.set("DATE", dateFormatter.getDisplayValue());
            doc.addText(ad.toString());
            doc.addText(" ");
            doc.addExternalLink("Ancestris", "http://www.ancestris.org");
            ad = this.getUtterance("doc.ad.2");
            ad.set("DATE", new Date().toString());
            doc.addText(ad.toString());
        }
        HashSet printed = new HashSet();
        Set gen = new HashSet<Indi>();
        gen.add(indi);
        int generationNumber = 1;
        do {
            nextGen = this.printGenerations(doc, generationNumber, gen, printed);
        } while ((gen = nextGen).size() > 0 && ++generationNumber <= this.maxGenerations);
        if (this.withNameIndex) {
            this.println(this.translate("log.printingNameIndex"));
        }
        if (this.withPlaceIndex) {
            this.println(this.translate("log.printingPlaceIndex"));
        }
        if (this.withBibliography) {
            // empty if block
        }
        this.println(this.translate("log.finished"));
        return doc;
    }

    private Utterance getUtterance(String key) {
        return this.getUtterance(key, new String[0]);
    }

    private Utterance getUtterance(String key, String[] params) {
        String template1 = this.translate(key);
        if (template1 == null) {
            template1 = key;
        }
        return Utterance.forTemplate(this.getResources(), template1, params);
    }

    private Set printGenerations(Document doc, int n, Set gen, Set printed) {
        Utterance generations = this.getUtterance("individuals.in.generation", new String[]{Integer.toString(gen.size()), Integer.toString(n)});
        this.println(generations.toString());
        LinkedHashSet nextGen = new LinkedHashSet();
        Utterance docTitle = this.getUtterance("section.title", new String[]{Integer.toString(n)});
        doc.startSection(docTitle.toString(), 2);
        for (Indi indi : gen) {
            IndiWriter writer = new IndiWriter(indi, doc);
            String sectionTitle = indi.getName();
            Property title = indi.getProperty("TITL");
            if (title != null) {
                sectionTitle = title.getValue().indexOf(" of ") != -1 || title.getValue().startsWith("of ") ? sectionTitle + ", " + title : title + " " + sectionTitle;
            }
            if (printed.contains(indi)) {
                doc.startSection(sectionTitle, 3);
                doc.addLink("Refer to entry via different lineage", indi.getAnchor());
            } else {
                doc.startSection(sectionTitle, indi.getAnchor(), 3);
                if (this.withNameIndex) {
                    doc.addIndexTerm(this.nameIndexTitle, indi.getLastName(), indi.getFirstName());
                }
                boolean showKids = indi.getSex() == 1;
                writer.writeEntry(showKids, 5, true, false, this.showImages);
            }
            this.addNextGeneration(nextGen, indi);
            printed.add(indi);
        }
        return nextGen;
    }

    private void addNextGeneration(Set indis, Indi indi) {
        if (this.ancestors) {
            Indi parent = indi.getBiologicalFather();
            if (parent != null) {
                indis.add(parent);
            }
            if ((parent = indi.getBiologicalMother()) != null) {
                indis.add(parent);
            }
        } else {
            Indi[] children = indi.getChildren();
            for (int j = 0; j < children.length; ++j) {
                indis.add(children[j]);
            }
        }
    }

    public class IndiWriter {
        private Indi indi;
        private Document doc;
        private final Set INDIVIDUAL_ATTRIBUTES = new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "PROP", "RELI", "SSN"));

        public IndiWriter(Indi indi, Document doc) {
            this.indi = indi;
            this.doc = doc;
        }

        public String getNamePlusIdAndReference(Indi i) {
            boolean doShowRefn;
            StringBuffer name = new StringBuffer(i.getFirstName());
            this.appendName(name, i.getLastName());
            this.appendName(name, i.getNameSuffix());
            boolean bl = doShowRefn = ReportNarrative.this.showRefns && i.getProperties("REFN").length > 0;
            if (ReportNarrative.this.showIds || doShowRefn) {
                name.append(" (");
                if (ReportNarrative.this.showIds) {
                    name.append(i.getId());
                    if (doShowRefn) {
                        name.append("; ");
                    }
                }
                if (doShowRefn) {
                    Property[] refns = i.getProperties("REFN");
                    for (int j = 0; j < refns.length; ++j) {
                        Property refn = refns[j];
                        if (j > 0) {
                            name.append(", ");
                        }
                        name.append(refn.getValue());
                    }
                }
                name.append(")");
            }
            return name.toString();
        }

        public String getName(Indi i) {
            StringBuffer name = new StringBuffer(i.getFirstName());
            this.appendName(name, i.getLastName());
            this.appendName(name, i.getNameSuffix());
            return name.toString();
        }

        private void appendName(StringBuffer name, String element) {
            if (element != null && element.length() > 0) {
                name.append(' ');
                name.append(element);
            }
        }

        public void writeEntry(boolean withChildren, int defaultDetailLevel, boolean withParents, boolean linkToIndi, boolean showImages) {
            int detailLevel = defaultDetailLevel;
            try {
                Indi[] children;
                if (ReportNarrative.this.withNameIndex) {
                    this.doc.addIndexTerm(ReportNarrative.this.nameIndexTitle, this.indi.getLastName(), this.indi.getFirstName());
                }
                if (showImages && ReportNarrative.this.alignImages && detailLevel >= 5) {
                    this.insertImages();
                }
                if (linkToIndi) {
                    this.doc.addLink(this.getNamePlusIdAndReference(this.indi), this.indi.getAnchor());
                } else {
                    this.doc.addText(this.getNamePlusIdAndReference(this.indi));
                }
                if (detailLevel >= 3) {
                    String date = this.getDateString((Property)this.indi.getBirthDate());
                    if (date.length() > 0) {
                        this.doc.addText(", ");
                        this.addGenderSpecificUtterance("born", this.indi, date);
                    }
                    Indi father = this.indi.getBiologicalFather();
                    Indi mother = this.indi.getBiologicalMother();
                    if (withParents && (father != null || mother != null)) {
                        Utterance parenPhrase = null;
                        if (this.indi.getBiologicalFather() != null && this.indi.getBiologicalMother() != null) {
                            parenPhrase = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.childof.parents", new String[]{this.getName(this.indi.getBiologicalFather()), this.getName(this.indi.getBiologicalMother())}, new Entity[]{this.indi.getBiologicalFather(), this.indi.getBiologicalMother()});
                        } else {
                            Indi parent = this.indi.getBiologicalFather() != null ? this.indi.getBiologicalFather() : this.indi.getBiologicalMother();
                            parenPhrase = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.childof.parent", new String[]{this.getName(parent)}, new Entity[]{parent});
                        }
                        if (parenPhrase != null) {
                            parenPhrase.setSubject(this.indi);
                            this.doc.addText(" (");
                            parenPhrase.addText(this.doc);
                            this.doc.addText(")");
                        }
                    }
                    Fam[] fams = this.indi.getFamiliesWhereSpouse();
                    for (int i = 0; i < fams.length; ++i) {
                        Indi spouse;
                        Property age;
                        Fam fam = fams[i];
                        PropertyDate marriage = fam.getMarriageDate();
                        this.doc.addText(", ");
                        if (!ReportNarrative.this.useAbbrevations) {
                            this.addUtterance(this.indi, this.genderSpecificKey("phrase.married", this.indi.getSex()), date);
                        } else {
                            this.addUtterance("abbrev.married");
                        }
                        this.doc.addText(" ");
                        if (fams.length > 1) {
                            this.doc.addText("(" + (i + 1) + ") ");
                        }
                        if (marriage != null) {
                            this.doc.addText(this.getDateString((Property)marriage));
                        }
                        Property property = age = this.indi.getSex() == 1 ? fam.getProperty(new TagPath("FAM:HUSB:AGE")) : fam.getProperty(new TagPath("FAM:WIFE:AGE"));
                        if (age != null) {
                            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.at_age", new String[]{age.getValue()}).toString());
                        }
                        if ((spouse = fam.getOtherSpouse(this.indi)) == null) {
                            this.addUtterance("phrase.spouses_name_unknown");
                            continue;
                        }
                        if (marriage != null) {
                            this.doc.addText(" ");
                            this.addUtterance("prep.married_to");
                        }
                        this.doc.addText(" ");
                        this.doc.addLink(this.getNamePlusIdAndReference(spouse), spouse.getAnchor());
                    }
                    date = this.getDateString((Property)this.indi.getDeathDate());
                    if (date.length() > 0) {
                        this.doc.addText(", ");
                        if (!ReportNarrative.this.useAbbrevations) {
                            this.addUtterance(this.indi, this.genderSpecificKey("phrase.died", this.indi.getSex()), date);
                        } else {
                            this.addUtterance("abbrev.died", date);
                        }
                    }
                    this.doc.addText(".");
                    HashSet<String> tagsProcessed = new HashSet<String>(Arrays.asList("REFN", "CHAN", "SEX", "BIRT", "DEAT", "FAMC", "FAMS", "NAME", "OBJE", "ASSO"));
                    if (detailLevel >= 5) {
                        Property[] props = this.indi.getProperties();
                        for (int i = 0; i < props.length; ++i) {
                            Property prop = props[i];
                            if (tagsProcessed.contains(prop.getTag())) continue;
                            int numberOfLikeProperties = 0;
                            for (int j = i + 1; j < props.length && props[j].getPropertyName().equals(props[i].getPropertyName()); ++j) {
                                ++numberOfLikeProperties;
                            }
                            Property[] likeProps = new Property[numberOfLikeProperties + 1];
                            numberOfLikeProperties = 0;
                            for (int j = i; j < props.length && props[j].getPropertyName().equals(props[i].getPropertyName()); ++j) {
                                likeProps[numberOfLikeProperties] = props[j];
                                ++numberOfLikeProperties;
                            }
                            this.doc.nextParagraph();
                            if (prop instanceof PropertyEvent) {
                                i += this.writeEvents(likeProps) - 1;
                                continue;
                            }
                            if (this.INDIVIDUAL_ATTRIBUTES.contains(prop.getTag())) {
                                i += this.writeEvents(likeProps) - 1;
                                continue;
                            }
                            if (prop.getTag().equals("RESI") || prop.getTag().equals("ADDR")) {
                                i += this.writeEvents(likeProps) - 1;
                                continue;
                            }
                            if (prop.getTag().equals("OCCU")) {
                                Delta age;
                                if (prop.getValue().length() <= 0) continue;
                                this.doc.addText(" ");
                                this.doc.nextParagraph();
                                boolean past = true;
                                if (this.indi.getDeathDate() == null && (age = this.indi.getAge(PointInTime.getPointInTime((long)System.currentTimeMillis()))) != null && age.getYears() < 65) {
                                    past = false;
                                }
                                Utterance u = Utterance.forProperty(ReportNarrative.this.getResources(), "sentence.OCCU", new String[]{prop.getValue()});
                                u.setSubject(this.indi);
                                u.set("tense", past ? "past" : "present");
                                this.doc.addText(u.toString());
                                this.writeNodeSource(prop);
                                continue;
                            }
                            if (prop.getTag().equals("NOTE")) {
                                this.doc.addText(" ");
                                this.doc.nextParagraph();
                                if (prop instanceof PropertyXRef) {
                                    Entity ref = ((PropertyXRef)prop).getTargetEntity();
                                    this.addUtterance("phrase.note", ref.getValue());
                                    Property source = ref.getProperty("SOUR");
                                    if (source == null) continue;
                                    this.writeSource((Source)((PropertySource)source).getTargetEntity());
                                    continue;
                                }
                                this.addUtterance("phrase.note", prop.getValue());
                                continue;
                            }
                            if (prop.getTag().equals("SOUR") && prop instanceof PropertySource) {
                                this.writeSource((Source)((PropertySource)prop).getTargetEntity());
                                continue;
                            }
                            if (prop.getTag().equals("SOUR")) {
                                this.addUtterance("phrase.source", prop.getValue());
                                continue;
                            }
                            if (prop.getTag().startsWith("_")) {
                                if (detailLevel < 6) continue;
                                this.addUtterance("phrase.property", prop.getValue());
                                continue;
                            }
                            this.addUtterance("phrase.property", prop.getValue());
                        }
                    } else if (detailLevel <= 2) {
                        // empty if block
                    }
                }
                if (withChildren && (children = this.indi.getChildren()).length > 0) {
                    Fam[] families = this.indi.getFamiliesWhereSpouse();
                    if (families.length > 1) {
                        this.doc.startList();
                    }
                    for (int i = 0; i < families.length; ++i) {
                        Fam family = families[i];
                        if (families.length > 1) {
                            this.doc.nextListItem("genj:label=" + (i + 1) + ".");
                            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.children.of.parents", new String[]{this.getName(family.getHusband()), this.getName(family.getWife())}, new Entity[]{family.getHusband(), family.getWife()}).toString());
                        }
                        children = family.getChildren();
                        this.doc.startList();
                        for (int j = 0; j < children.length; ++j) {
                            this.doc.nextListItem("genj:label=" + (j + 1) + ".");
                            Indi child = children[j];
                            IndiWriter w = new IndiWriter(child, this.doc);
                            w.writeEntry(false, 3, false, true, false);
                        }
                        this.doc.endList();
                    }
                    if (families.length > 1) {
                        this.doc.endList();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addUtterance("sentence.error");
            }
        }

        private void addGenderSpecificUtterance(String key, Indi indi, String param1) {
            String abbrevKey = "abbrev" + key;
            if (ReportNarrative.this.useAbbrevations && Utterance.isTranslatable(abbrevKey, ReportNarrative.this.getResources())) {
                this.addUtterance(indi, abbrevKey, param1);
            } else {
                this.addUtterance(indi, this.genderSpecificKey("phrase." + key, indi.getSex()), param1);
            }
        }

        private void addUtterance(String key) {
            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), key).toString());
        }

        private void addUtterance(String key, String value1) {
            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), key, new String[]{value1}).toString());
        }

        private void addUtterance(String key, String[] values) {
            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), key, values).toString());
        }

        private void addUtterance(Indi indi, String key) {
            Utterance u = Utterance.forProperty(ReportNarrative.this.getResources(), key);
            u.setSubject(indi);
            this.doc.addText(u.toString());
        }

        private void addUtterance(Indi indi, String key, String value1) {
            Utterance u = Utterance.forProperty(ReportNarrative.this.getResources(), key, new String[]{value1});
            u.setSubject(indi);
            this.doc.addText(u.toString());
        }

        private void addUtterance(Indi indi, String key, String[] values) {
            Utterance u = Utterance.forProperty(ReportNarrative.this.getResources(), key, values);
            u.setSubject(indi);
            this.doc.addText(u.toString());
        }

        private String getDateString(Property prop) {
            if (prop == null || !prop.isValid()) {
                return "";
            }
            return prop.getDisplayValue();
        }

        private void insertImages() {
            Property[] props = this.indi.getProperties(new TagPath("INDI:OBJE"));
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                if (prop.getProperty("FILE") == null || !this.isImagePath(prop.getProperty("FILE")) && !this.isImagePath(prop.getProperty("FORM"))) continue;
                if (!ReportNarrative.this.alignImages) {
                    this.doc.nextParagraph();
                    this.addImage(prop.getProperty("FILE").getValue());
                    if (prop.getProperty("NOTE") != null) {
                        this.doc.addText(prop.getProperty("NOTE").getValue());
                    }
                    this.doc.nextParagraph();
                    continue;
                }
                this.addImage(prop.getProperty("FILE").getValue());
            }
        }

        private void addImage(String urlOrPath) {
            String attrs = "";
            if (urlOrPath.startsWith("file:///")) {
                this.doc.addImage(new File(urlOrPath.substring(8)), attrs);
            } else {
                this.doc.addImage(new File(urlOrPath), attrs);
            }
        }

        private boolean isImagePath(Property property) {
            if (property == null) {
                return false;
            }
            String path = property.getValue();
            return path.endsWith("jpg") || path.endsWith("JPG") || path.endsWith("gif") || path.endsWith("GIF");
        }

        private void writeNodeSource(Property node) {
            Property prop = node.getProperty("SOUR");
            if (prop != null && prop instanceof PropertySource) {
                this.writeSource((Source)((PropertySource)prop).getTargetEntity());
            }
        }

        private void writeSource(Source prop) {
            String date;
            if (ReportNarrative.this.sourceIndexTitle != null) {
                String key = prop.getProperty("REFN") != null ? prop.getProperty("REFN").getValue() : prop.getId();
                this.doc.addLink("[" + key + "]", prop.getAnchor());
            }
            Utterance u = this.getSentenceForTag("phrase.SOUR");
            String[] tags = new String[]{"REFN", "TYPE", "TITL", "AUTH", "EDIT", "INTV", "INFT", "OWNR"};
            for (int i = 0; i < tags.length; ++i) {
                this.addOptionalParam(u, prop, tags[i]);
            }
            if (prop.getProperty("PAGE") != null) {
                u.set("OPTIONAL_PAGE", ", " + Utterance.forProperty(ReportNarrative.this.getResources(), "abbrev.page") + " " + prop.getProperty("PAGE").getValue());
            }
            if ((date = this.getDatePhrase((Property)prop)).length() > 0) {
                u.set("OPTIONAL_DATE", date);
            }
            this.doc.addText(" " + u.toString() + "");
        }

        private void addOptionalParam(Utterance u, Source prop, String tag) {
            if (prop.getProperty(tag) != null) {
                String value;
                String phraseKey = "phrase." + prop.getTag() + "." + tag;
                if (ReportNarrative.this.translate(phraseKey) != null) {
                    Utterance phrase = Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(phraseKey), new String[]{prop.getProperty(tag).getValue()});
                    value = phrase.toString();
                } else {
                    value = prop.getProperty(tag).getValue();
                }
                if (tag.equals("TYPE")) {
                    value = "(" + value + ")";
                } else if (tag.equals("TITL")) {
                    value = "\"" + value + "\"";
                }
                u.set("OPTIONAL_" + tag, value);
            }
        }

        private void writeOptionalProperty(Property prop, String tag, String prolog) {
            this.writeOptionalProperty(prop, tag, prolog, "");
        }

        private void writeOptionalProperty(Property prop, String tag, String prolog, String epilog) {
            if (prop.getProperty(tag) != null) {
                this.doc.addText(prolog);
                if (tag.equals("DATE")) {
                    this.doc.addText(this.getDateString(prop));
                } else {
                    this.doc.addText(prop.getProperty(tag).getValue());
                }
                this.doc.addText(epilog);
            }
        }

        private int writeEvents(Property[] likeProps) {
            return this.printEventUtterance(likeProps);
        }

        private void writeDate(Property prop) {
            String date = this.getDatePhrase(prop);
            if (date.length() > 0) {
                this.doc.addText(date);
            }
        }

        private String getDatePhrase(Property prop) {
            String date = "";
            PropertyDate propDate = null;
            if (prop instanceof PropertyEvent) {
                propDate = ((PropertyEvent)prop).getDate(true);
                date = this.getDateString(prop.getProperty("DATE"));
            }
            if (date.length() > 0) {
                if (date.startsWith("FROM")) {
                    date = " " + date;
                } else if (propDate != null && propDate.getStart().getDay() == Integer.MAX_VALUE) {
                    Utterance phrase = propDate.getStart().getMonth() == Integer.MAX_VALUE ? Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.date.year", new String[]{date}) : Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.date.month", new String[]{date});
                    date = phrase.toString();
                } else {
                    Utterance phrase = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.date.day", new String[]{date});
                    date = phrase.toString();
                }
            }
            return date;
        }

        private boolean propertyDefined(String key) {
            return !ReportNarrative.this.translate(key).equals(key);
        }

        private boolean propertyDefined(String key, int gender) {
            String suffix;
            String string = gender == 1 ? ".male" : (suffix = gender == 2 ? ".female" : ".genderUnknown");
            if (this.propertyDefined(key + suffix)) {
                return true;
            }
            return this.propertyDefined(key);
        }

        private String genderSpecificKey(String key, int gender) {
            String suffix;
            String string = gender == 1 ? ".male" : (suffix = gender == 2 ? ".female" : ".genderUnknown");
            if (this.propertyDefined(key + suffix)) {
                return key + suffix;
            }
            return key;
        }

        private int printEventUtterance(Property[] props) {
            String seriesKey = "listFirst." + props[0].getTag();
            String itemKey = "listItem." + props[0].getTag();
            if (props.length == 1 || !this.propertyDefined(seriesKey) && !this.propertyDefined(itemKey)) {
                this.printEventUtterance(props[0]);
                return 1;
            }
            String list = this.getListUtterance(props);
            Property prop = props[0];
            Utterance s = this.getSentenceForTag(prop.getTag(), new String[]{list});
            s.setSubject(this.indi);
            this.doc.addText(" " + s.toString());
            return props.length;
        }

        private String getListUtterance(Property[] props) {
            String listLastKey;
            String listNextKey;
            StringBuffer result = new StringBuffer(100);
            Property prop = props[0];
            String listFirst = "listFirst." + prop.getTag();
            if (ReportNarrative.this.translate(listFirst).equals(listFirst)) {
                listFirst = "listFirst";
            }
            if (ReportNarrative.this.translate(listNextKey = "listNext." + prop.getTag()).equals(listNextKey)) {
                listNextKey = "listNext";
            }
            if (ReportNarrative.this.translate(listLastKey = "listLast." + prop.getTag()).equals(listLastKey)) {
                listLastKey = "listLast";
            }
            Utterance item = this.getListItemUtterance(prop);
            result.append(Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(listFirst), new String[]{item.toString()}));
            for (int i = 1; i < props.length - 1; ++i) {
                prop = props[i];
                item = this.getListItemUtterance(prop);
                result.append(Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(listNextKey), new String[]{item.toString()}));
            }
            prop = props[props.length - 1];
            item = this.getListItemUtterance(prop);
            result.append(Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(listLastKey), new String[]{item.toString()}));
            return result.toString();
        }

        private Utterance getListItemUtterance(Property prop) {
            String listItemKey = "listItem." + prop.getTag();
            Utterance s = Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(listItemKey), new String[]{prop.getValue()});
            this.completeEventUtterance(s, prop);
            return s;
        }

        private void printEventUtterance(Property prop) {
            Utterance s = this.getSentenceForTag(prop.getTag(), new String[]{prop.getValue()});
            s.setSubject(this.indi);
            this.completeEventUtterance(s, prop);
            this.doc.addText(" " + s.toString());
        }

        private void completeEventUtterance(Utterance s, Property prop) {
            String place = this.getPlaceString(prop, null);
            if (place.length() > 0) {
                s.set("OPTIONAL_PP_PLACE", place);
            }
            if (prop.getProperty("AGNC") != null) {
                Utterance agency = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase." + prop.getTag() + ".AGENCY", new String[]{prop.getProperty("AGNC").getValue()});
                s.set("OPTIONAL_AGENCY", agency.toString());
            }
            String date = "";
            if (prop instanceof PropertyEvent) {
                date = this.getDateString(prop.getProperty("DATE"));
            }
            if (date.length() > 0) {
                s.set("OPTIONAL_PP_DATE", date);
            }
        }

        private Utterance getSentenceForTag(String tag) {
            return this.getSentenceForTag(tag, new String[0]);
        }

        private Utterance getSentenceForTag(String tag, String[] params) {
            String template1 = ReportNarrative.this.translate("sentence." + tag);
            if (template1 == null) {
                template1 = "{SUBJECT} " + tag + "{OPTIONAL_AGENCY}{OPTIONAL_PP_PLACE}{OPTIONAL_PP_DATE}.";
            }
            Utterance u = Utterance.forTemplate(ReportNarrative.this.getResources(), template1, params);
            u.setSubject(this.indi);
            return u;
        }

        private Utterance getPhraseForTag(String tag, String[] params) {
            String template1 = ReportNarrative.this.translate("phrase." + tag);
            if (template1 == null) {
                template1 = tag + "{OPTIONAL_AGENCY}{OPTIONAL_PP_PLACE}{OPTIONAL_PP_DATE}.";
            }
            Utterance u = Utterance.forTemplate(ReportNarrative.this.getResources(), template1, params);
            return u;
        }

        private String getPlaceString(Property prop, String preposition) {
            StringBuffer result = new StringBuffer();
            Property addr = prop.getProperty("ADDR");
            if (addr != null) {
                this.appendToPlace(result, addr);
                this.appendToPlace(result, addr.getProperty("ADR1"));
                this.appendToPlace(result, addr.getProperty("ADR2"));
                this.appendToPlace(result, addr.getProperty("CITY"));
                this.appendToPlace(result, addr.getProperty("STAE"));
                this.appendToPlace(result, addr.getProperty("CTRY"));
            } else if (prop.getProperty("PLAC") != null) {
                String county;
                String place = prop.getProperty("PLAC").getValue();
                String[] parts = place.split(",\\s*");
                if (parts.length == 0) {
                    return "";
                }
                String lastPart = parts[parts.length - 1];
                if (!(parts.length < 4 || !lastPart.equalsIgnoreCase("us") && !lastPart.equalsIgnoreCase("usa") || (county = parts[parts.length - 3]).endsWith(" County") || county.endsWith("Co") || county.endsWith(" Co."))) {
                    int n = parts.length - 3;
                    parts[n] = parts[n] + " Co.";
                }
                int nParts = parts.length;
                if (lastPart.equals("US") || lastPart.equals("GB")) {
                    --nParts;
                } else {
                    parts[parts.length - 1] = new Locale("en", lastPart).getDisplayCountry();
                }
                boolean firstWritten = true;
                for (int i = 0; i < nParts; ++i) {
                    String part = parts[i];
                    if (part.length() == 0) continue;
                    if (firstWritten) {
                        firstWritten = false;
                    } else {
                        result.append(", ");
                    }
                    result.append(part);
                }
            }
            if (result.length() == 0) {
                return "";
            }
            this.doc.addIndexTerm(ReportNarrative.this.placeIndexTitle, result.toString());
            if (preposition == null) {
                String key = "prep.in_city";
                if (Character.isDigit(result.charAt(0))) {
                    key = "prep.at_street_address";
                }
                preposition = ReportNarrative.this.translate(key);
            }
            return " " + preposition + " " + result;
        }

        private void writePlace(Property prop, String preposition) {
            String result = this.getPlaceString(prop, preposition);
            if (result.length() == 0) {
                return;
            }
            this.doc.addText(result);
            this.doc.addIndexTerm(ReportNarrative.this.placeIndexTitle, result, null);
        }

        private void appendToPlace(StringBuffer result, Property prop) {
            if (prop != null) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(prop.getValue());
            }
        }

        private String getPersonalPronoun(boolean asSubject) {
            String pronoun;
            if (asSubject) {
                pronoun = this.indi.getSex() == 1 ? ReportNarrative.this.translate("pronoun.nom.male") : ReportNarrative.this.translate("pronoun.nom.female");
                pronoun = Character.toUpperCase(pronoun.charAt(0)) + pronoun.substring(1);
            } else {
                pronoun = this.indi.getSex() == 1 ? ReportNarrative.this.translate("pronoun.acc.male") : ReportNarrative.this.translate("pronoun.acc.female");
            }
            return pronoun;
        }
    }
}

