/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.gedart.DocReport;
import ancestris.reports.gedart.GedartTemplate;
import ancestris.reports.gedart.GedartTemplates;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class ReportGedart
extends Report {
    private GedartTemplates gedartTemplates = null;
    private GedartTemplate[] gedartTemplatesOption = null;
    private String todoTag = "NOTE";
    private String todoStart = "TODO:";
    public boolean includeIndi = true;
    public boolean includeFam = true;
    public boolean includeTOC = false;
    public boolean includeIndex = false;
    private boolean outputSummary = false;
    public boolean showID = true;
    private boolean isTodo = false;
    public boolean includeBlankCells = false;
    private boolean isOneFile = true;
    public boolean saveReportToFile = true;
    private int iTemplate = 0;
    public String[] templates = null;
    private DocReport mydoc;
    private Gedcom theGedcom;

    public File start(Gedcom gedcom, GedartTemplate template) {
        this.theGedcom = gedcom;
        return this.process(gedcom.getEntities("INDI", "INDI:NAME"), gedcom.getEntities("FAM", "FAM:HUSB:*:..:NAME"), template);
    }

    public File start(Indi indi, GedartTemplate template) {
        this.theGedcom = indi.getGedcom();
        return this.process((Entity[])new Indi[]{indi}, (Entity[])new Fam[0], template);
    }

    public File start(Indi[] indis, GedartTemplate template) {
        this.theGedcom = indis[0].getGedcom();
        return this.process((Entity[])indis, (Entity[])new Fam[0], template);
    }

    public File start(Fam fam, GedartTemplate template) {
        this.theGedcom = fam.getGedcom();
        return this.process((Entity[])new Indi[0], (Entity[])new Fam[]{fam}, template);
    }

    public File start(Fam[] fams, GedartTemplate template) {
        this.theGedcom = fams[0].getGedcom();
        return this.process((Entity[])new Indi[0], (Entity[])fams, template);
    }

    public String accepts(Object context) {
        return this.getName();
    }

    public File start(Object context) throws Throwable {
        if (context instanceof Gedcom) {
            return this.start((Gedcom)context, null);
        }
        if (context instanceof Indi) {
            return this.start((Indi)context, null);
        }
        if (context instanceof Fam) {
            return this.start((Fam)context, null);
        }
        if (context instanceof Indi[]) {
            return this.start((Indi[])context, null);
        }
        if (context instanceof Fam[]) {
            return this.start((Fam[])context, null);
        }
        return null;
    }

    private File process(Entity[] indis, Entity[] fams, GedartTemplate usetemplate) {
        File file;
        boolean isOneEntity;
        this.gedartTemplates = new GedartTemplates();
        this.gedartTemplatesOption = this.gedartTemplates.toArray();
        this.templates = GedartTemplate.getDescription(this.gedartTemplatesOption);
        String extension = null;
        if (usetemplate == null && this.gedartTemplatesOption.length > this.iTemplate) {
            usetemplate = this.gedartTemplatesOption[this.iTemplate];
        }
        if (usetemplate == null) {
            return null;
        }
        String thetemplate = usetemplate.getPath();
        LOG.log(Level.INFO, "template:{0}", thetemplate);
        extension = usetemplate.getFormat();
        if (extension != null && !extension.isEmpty()) {
            extension = "html";
        }
        boolean bl = isOneEntity = indis.length + fams.length <= 1;
        if (isOneEntity) {
            this.isTodo = false;
        }
        LOG.log(Level.INFO, "tofile=" + this.saveReportToFile);
        if (!this.saveReportToFile) {
            try {
                file = File.createTempFile("Ancestris-", null);
            }
            catch (IOException ioe) {
                file = null;
            }
        } else {
            file = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, extension);
        }
        if (file == null) {
            LOG.log(Level.INFO, "file = null");
            return null;
        }
        LOG.log(Level.INFO, "file=" + file);
        try {
            this.mydoc = new DocReport(file, this.gedartTemplates, this.theGedcom.getEncoding());
            this.mydoc.put("options", this);
            this.mydoc.put("TEMPLATE", thetemplate);
        }
        catch (IOException ioe) {
            System.err.println("IO Exception!");
            ioe.printStackTrace();
            return null;
        }
        this.mydoc.put("INDIS", indis);
        this.mydoc.put("FAMS", fams);
        this.mydoc.put("GEDCOM", this.theGedcom);
        this.mydoc.render(thetemplate + "/index.vm");
        this.mydoc.close();
        this.println("Completed");
        return file;
    }
}

