/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.core.TextOptions;
import ancestris.reports.gedart.GedartTemplates;
import ancestris.reports.gedart.ReportGedart;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.SortTool;
import org.openide.modules.Places;

public class DocReport {
    private VelocityContext context;
    private static VelocityEngine engine = new VelocityEngine();
    private Writer out;
    public Charset CHARSET;
    private static final File TEMPLATE_DIR = Places.getUserDirectory();

    DocReport(GedartTemplates template, String encoding) {
        try {
            this.CHARSET = Charset.forName(encoding);
        }
        catch (Exception e) {
            this.CHARSET = Charset.forName("ISO-8859-1");
        }
        try {
            engine.setProperty("resource.loader", (Object)"file,class");
            engine.setProperty("file.resource.loader.path", (Object)TEMPLATE_DIR.getPath());
            engine.setProperty("file.resource.loader.cache", (Object)"true");
            engine.setProperty("directive.set.null.allowed", (Object)"true");
            engine.setProperty("runtime.interpolate.string.literals", (Object)"true");
            engine.init();
        }
        catch (Exception e) {
            System.out.println("Problem initializing Velocity : " + e);
        }
        this.restart();
    }

    DocReport(File file, GedartTemplates template, String encoding) throws IOException {
        this(template, encoding);
        this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.CHARSET);
    }

    void restart() {
        this.context = new VelocityContext();
        this.context.put("gedcom", (Object)new Gedcom());
        this.context.put("list", (Object)new ListTool());
        this.context.put("sorter", (Object)new SortTool());
        this.context.put("date", (Object)new DateTool());
        this.context.put("docindex", (Object)new reportIndex());
        this.context.put("null", null);
        this.context.put("encoding", (Object)this.CHARSET);
    }

    void put(String key, Object o) {
        this.context.put(key, o);
    }

    void put(String key, Gedcom e) {
        this.context.put(key, (Object)new reportGedcom(e));
    }

    void put(String key, ReportGedart r) {
        this.put(key, new reportOptions(r));
    }

    void put(String key, Fam f) {
        reportFam rf = null;
        if (f != null) {
            rf = new reportFam(f);
        }
        this.put(key, rf);
    }

    void put(String key, Indi i) {
        this.context.put(key, (Object)new reportIndi(i));
    }

    void put(String key, Entity[] entities) {
        if (entities.length == 0) {
            this.put(key, new Object[0]);
        } else if (entities[0] instanceof Indi) {
            reportIndi[] reportIndis = new reportIndi[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportIndis[i] = new reportIndi((Indi)entities[i]);
            }
            this.put(key, reportIndis);
        } else if (entities[0] instanceof Fam) {
            reportFam[] reportFams = new reportFam[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportFams[i] = new reportFam((Fam)entities[i]);
            }
            this.put(key, reportFams);
        } else {
            this.put(key, (Object)null);
        }
    }

    void render(String template) {
        try {
            engine.mergeTemplate(template, "ISO-8859-1", (Context)this.context, this.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.restart();
    }

    void close() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class reportOptions {
        private ReportGedart report;

        reportOptions(ReportGedart rep) {
            this.report = rep;
        }

        public boolean getShowBlankCells() {
            return this.report.includeBlankCells;
        }

        public boolean getShowID() {
            return this.report.showID;
        }

        public boolean getShowTOC() {
            return this.report.includeTOC;
        }

        public boolean getShowIndex() {
            return this.report.includeIndex;
        }

        public boolean getShowIndis() {
            return this.report.includeIndi;
        }

        public boolean getShowFams() {
            return this.report.includeFam;
        }
    }

    public class reportProperty
    implements Comparable<reportProperty> {
        Property property;

        reportProperty(Property prop) {
            this.property = prop;
            if (prop == null) {
                return;
            }
        }

        reportProperty create(Property p) {
            if (p == null) {
                return null;
            }
            if (p instanceof Indi) {
                return new reportIndi((Indi)p);
            }
            if (p instanceof Fam) {
                return new reportFam((Fam)p);
            }
            if (p instanceof PropertyAge) {
                return new reportPropertyAge((PropertyAge)p);
            }
            if (p instanceof PropertyXRef) {
                return new reportPropertyXRef((PropertyXRef)p);
            }
            if (p instanceof PropertyPlace) {
                return new reportPropertyPlace((PropertyPlace)p);
            }
            if (p instanceof PropertyFile) {
                return new reportPropertyFile((PropertyFile)p);
            }
            if (p instanceof PropertyName) {
                return new reportPropertyName((PropertyName)p);
            }
            return new reportProperty(p);
        }

        @Override
        public int compareTo(reportProperty that) {
            return this.property.compareTo(that.property);
        }

        public reportProperty getProperty(String tagPath) {
            if (this.property == null) {
                return null;
            }
            Property subProp = this.property.getPropertyByPath(this.property.getTag() + ":" + tagPath);
            return this.create(subProp);
        }

        public reportProperty getParent() {
            if (this.property == null) {
                return null;
            }
            return this.create(this.property.getParent());
        }

        public Object get(String tag) {
            return this.getProperty(tag.toUpperCase());
        }

        public reportProperty[] getProperties(String tagPath) {
            Property[] props = this.property.getProperties(new TagPath(this.property.getTag() + ":" + tagPath));
            if (props.length == 0) {
                return null;
            }
            reportProperty[] reportProps = new reportProperty[props.length];
            for (int i = 0; i < props.length; ++i) {
                reportProps[i] = this.create(props[i]);
            }
            return reportProps;
        }

        public String getPath() {
            return this.property.getPath().toString();
        }

        public String getDate() {
            return this.format("{$D}");
        }

        public String getValue() {
            return this.property == null ? "" : this.property.getDisplayValue();
        }

        public String getName() {
            return this.format("{$T}");
        }

        public String getPlace() {
            return this.format("{$P}");
        }

        public String toString() {
            return this.getValue();
        }

        public String format(String fmtstr) {
            return this.property == null ? "" : this.property.format(fmtstr);
        }
    }

    public class reportPropertyName
    extends reportProperty {
        reportPropertyName(PropertyName p) {
            super((Property)p);
        }

        public String getLastName() {
            return ((PropertyName)this.property).getLastName();
        }

        public String getFirstName() {
            return ((PropertyName)this.property).getFirstName();
        }
    }

    public class reportPropertyFile
    extends reportProperty {
        reportPropertyFile(PropertyFile p) {
            super((Property)p);
        }

        public String getAbsolutePath() {
            try {
                return ((PropertyFile)this.property).getFile().getAbsolutePath();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public class reportPropertyPlace
    extends reportProperty {
        reportPropertyPlace(PropertyPlace p) {
            super((Property)p);
        }

        public String[] getHierarchy() {
            String hierarchy = ((PropertyPlace)this.property).getFormatAsString();
            return hierarchy.split(",");
        }

        public String getJuridiction(int level) {
            return ((PropertyPlace)this.property).getJurisdiction(level);
        }

        public String getFirstAvailableJurisdiction() {
            return ((PropertyPlace)this.property).getFirstAvailableJurisdiction();
        }

        public String getCity() {
            return ((PropertyPlace)this.property).getCity();
        }

        public String getJuridiction(String f) {
            String[] values = ((PropertyPlace)this.property).getValue().split(",");
            String[] hierarchy = this.getHierarchy();
            for (int i = 0; i < hierarchy.length; ++i) {
                if (!hierarchy[i].trim().equalsIgnoreCase(f.trim())) continue;
                return values[i];
            }
            return null;
        }
    }

    public class reportPropertyXRef
    extends reportProperty {
        reportPropertyXRef(PropertyXRef p) {
            super((Property)p);
        }

        public reportEntity getTarget() {
            Entity e = ((PropertyXRef)this.property).getTargetEntity();
            return (reportEntity)this.create((Property)e);
        }
    }

    public class reportPropertyAge
    extends reportProperty {
        reportPropertyAge(PropertyAge p) {
            super((Property)p);
        }

        @Override
        public String get(String what) {
            Matcher temp = Pattern.compile("(([0-9]+)y *)?(([0-9]+)m *)?(([0-9]+)d)?").matcher(this.getValue());
            if (temp.matches()) {
                if (what.equals("Years")) {
                    return temp.group(2);
                }
                if (what.equals("Months")) {
                    return temp.group(4);
                }
                if (what.equals("Days")) {
                    return temp.group(6);
                }
                return null;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.get("Years");
        }
    }

    public class reportGedcom {
        Gedcom theGedcom;

        reportGedcom(Gedcom g) {
            this.theGedcom = g;
        }

        public reportEntity getSubmitter() {
            return new reportEntity((Entity)this.theGedcom.getSubmitter());
        }
    }

    public class reportEntity
    extends reportProperty {
        TextOptions OPTIONS;

        reportEntity(Entity e) {
            super((Property)e);
            this.OPTIONS = TextOptions.getInstance();
        }

        public String getId() {
            return ((Entity)this.property).getId();
        }
    }

    public class reportIndi
    extends reportEntity {
        reportIndi(Indi i) {
            super((Entity)i);
        }

        public String getShortValue() {
            return this.toString();
        }

        @Override
        public String toString() {
            if (this.property == null) {
                return "";
            }
            String birth = ((Entity)this.property).format("BIRT", this.OPTIONS.getBirthSymbol() + " {$V }{$D}{ $P}");
            String death = ((Entity)this.property).format("DEAT", this.OPTIONS.getDeathSymbol() + " {$V }{$D}{ $P}");
            return this.property.toString() + " " + birth + " " + death;
        }

        public String getString(String male, String female, String unknown) {
            if (((Indi)this.property).getSex() == 1) {
                return male;
            }
            if (((Indi)this.property).getSex() == 2) {
                return female;
            }
            return unknown;
        }

        public String getString(String male, String female) {
            return this.getString(male, female, male);
        }

        public reportProperty getFamc() {
            Fam famc = ((Indi)this.property).getFamilyWhereBiologicalChild();
            return this.create((Property)famc);
        }

        public reportFam[] getFams() {
            Fam[] fams = ((Indi)this.property).getFamiliesWhereSpouse();
            reportFam[] reportFams = new reportFam[fams.length];
            for (int f = 0; f < fams.length; ++f) {
                reportFams[f] = new reportFam(fams[f], (Indi)this.property);
            }
            return reportFams;
        }
    }

    public class reportFam
    extends reportEntity {
        private Indi refIndi;

        reportFam(Fam f, Indi indi) {
            this(f);
            this.refIndi = indi;
        }

        reportFam(Fam f) {
            super((Entity)f);
            this.refIndi = null;
        }

        public reportProperty getOtherSpouse() {
            if (this.refIndi == null) {
                return null;
            }
            Indi i = ((Fam)this.property).getOtherSpouse(this.refIndi);
            return this.create((Property)i);
        }

        public String getShortValue() {
            return this.toString();
        }

        @Override
        public String toString() {
            if (this.property == null) {
                return "";
            }
            return this.property.toString() + ((Entity)this.property).format("MARR", "{ le $D}{ \ufffd $P}");
        }

        public reportProperty[] getChildren() {
            Indi[] ch = ((Fam)this.property).getChildren();
            reportProperty[] result = new reportProperty[ch.length];
            for (int c = 0; c < ch.length; ++c) {
                result[c] = this.create((Property)ch[c]);
            }
            return result;
        }

        public reportProperty getHusband() {
            Indi i = ((Fam)this.property).getHusband();
            return this.create((Property)i);
        }

        public reportProperty getWife() {
            Indi i = ((Fam)this.property).getWife();
            return this.create((Property)i);
        }
    }

    public class reportIndex {
        private Map index2primary2secondary2elements = new TreeMap();

        private String getKey(Entity e, String tagPath) {
            Property p;
            String tp = tagPath;
            boolean isFirst = false;
            boolean isLast = false;
            isFirst = tp.endsWith("NAME:FIRST");
            isLast = tp.endsWith("NAME:LAST");
            if (isFirst || isLast) {
                tp = tp.substring(0, tp.lastIndexOf(58));
            }
            if ((p = e.getPropertyByPath(e.getTag() + ":" + tp)) == null) {
                return "?";
            }
            String result = isFirst ? ((PropertyName)p).getFirstName().split(" ", 1)[0] : (isLast ? ((PropertyName)p).getLastName() : p.toString());
            if (result.length() == 0) {
                return "?";
            }
            return result;
        }

        public Map buildIndexes(reportEntity[] entities, String tagpathPrimary, String tagpathSecondary) {
            this.index2primary2secondary2elements = new TreeMap();
            return this.addIndexes(entities, tagpathPrimary, tagpathSecondary);
        }

        public Map addIndexes(reportEntity[] entities, String tagpathPrimary, String tagpathSecondary) {
            for (int i = 0; i < entities.length; ++i) {
                Entity e = (Entity)entities[i].property;
                String prim = this.getKey(e, tagpathPrimary);
                String sec = this.getKey(e, tagpathSecondary);
                this.addIndexTerm(prim.substring(0, 1), prim, sec, e);
            }
            return this.index2primary2secondary2elements;
        }

        public void addIndexTerm(String index, String primary, Entity entity) {
            this.addIndexTerm(index, primary, "", entity);
        }

        public void addIndexTerm(String index, String primary, String secondary, Entity entity) {
            ArrayList<Entity> elements;
            TreeMap secondary2elements;
            if (index == null) {
                return;
            }
            if ((index = index.trim()).length() == 0) {
                return;
            }
            if ((primary = this.trimIndexTerm(primary)).length() == 0) {
                return;
            }
            if ((secondary = this.trimIndexTerm(secondary)).length() == 0) {
                return;
            }
            TreeMap primary2secondary2elements = (TreeMap)this.index2primary2secondary2elements.get(index);
            if (primary2secondary2elements == null) {
                primary2secondary2elements = new TreeMap();
                this.index2primary2secondary2elements.put(index, primary2secondary2elements);
            }
            if ((secondary2elements = (TreeMap)primary2secondary2elements.get(primary)) == null) {
                secondary2elements = new TreeMap();
                primary2secondary2elements.put(primary, secondary2elements);
            }
            if ((elements = (ArrayList<Entity>)secondary2elements.get(secondary)) == null) {
                elements = new ArrayList<Entity>();
                secondary2elements.put(secondary, elements);
            }
            if (!elements.contains(entity)) {
                elements.add(entity);
            }
        }

        private String trimIndexTerm(String term) {
            int comma;
            if (term == null) {
                return "";
            }
            int bracket = term.indexOf(40);
            if (bracket >= 0) {
                term = term.substring(0, bracket);
            }
            if ((comma = term.indexOf(40)) >= 0) {
                term = term.substring(0, comma);
            }
            return term.trim();
        }
    }
}

