/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.modules.document.view.AbstractDocumentView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DocumentViewTopComponent
extends TopComponent {
    private static DocumentViewTopComponent instance = null;
    private transient boolean isVisible = false;
    private JPopupMenu pop;
    private PopupListener listener;
    private CloseListener closeL;
    private static Image DOC_ICON = ImageUtilities.loadImage((String)"ancestris/modules/document/view/View.png", (boolean)true);
    private static final String PREFERRED_ID = "DocumentViewTopComponent";
    InstanceContent ic = new InstanceContent();
    Lookup tcLookup = new AbstractLookup((AbstractLookup.Content)this.ic);

    public DocumentViewTopComponent() {
        this(NbBundle.getMessage(DocumentViewTopComponent.class, (String)"LBL_Documents"));
    }

    private DocumentViewTopComponent(String name) {
        this.associateLookup(this.tcLookup);
        this.setName(name);
        this.setToolTipText(name);
        this.setIcon(DOC_ICON);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(1, 1));
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.listener = new PopupListener();
        this.closeL = new CloseListener();
        this.setFocusCycleRoot(true);
        JLabel label = new JLabel(NbBundle.getMessage(DocumentViewTopComponent.class, (String)"LBL_NoOutput"));
        label.setHorizontalAlignment(0);
        label.setEnabled(false);
        this.add(label, "Center");
    }

    public void addPanel(AbstractDocumentView panel) {
        if (this.getComponentCount() == 0) {
            this.add(panel, "Center");
            this.ic.set(new ArrayList(), null);
            this.ic.add((Object)panel.getContext());
        } else {
            Component comp = this.getComponent(0);
            if (comp instanceof JTabbedPane) {
                ((JTabbedPane)comp).addTab(panel.getName(), null, panel, panel.getToolTipText());
                ((JTabbedPane)comp).setSelectedComponent(panel);
                comp.validate();
            } else if (comp instanceof JLabel) {
                this.remove(comp);
                this.add(panel, "Center");
                if (panel instanceof AbstractDocumentView) {
                    this.ic.set(new ArrayList(), null);
                    this.ic.add((Object)panel.getContext());
                }
            } else {
                this.remove(comp);
                JTabbedPane pane = TabbedPaneFactory.createCloseButtonTabbedPane();
                pane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
                        Component c = sourceTabbedPane.getSelectedComponent();
                        if (c instanceof AbstractDocumentView) {
                            DocumentViewTopComponent.this.ic.set(new ArrayList(), null);
                            DocumentViewTopComponent.this.ic.add((Object)((AbstractDocumentView)c).getContext());
                        }
                    }
                });
                pane.addMouseListener((MouseListener)((Object)this.listener));
                pane.addPropertyChangeListener(this.closeL);
                this.add(pane, "Center");
                pane.addTab(comp.getName(), null, comp, ((JPanel)comp).getToolTipText());
                pane.addTab(panel.getName(), null, panel, panel.getToolTipText());
                pane.setSelectedComponent(panel);
                pane.validate();
            }
        }
        if (!this.isVisible) {
            this.isVisible = true;
            this.open();
        }
        this.validate();
        this.requestActive();
    }

    protected void componentActivated() {
        super.componentActivated();
        JPanel panel = this.getCurrentPanel();
        if (panel != null) {
            panel.requestFocus();
        }
    }

    public void removePanel(JPanel panel) {
        Component comp;
        Component component = comp = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (comp instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)comp;
            if (panel == null) {
                panel = (JPanel)tabs.getSelectedComponent();
            }
            tabs.remove(panel);
            if (tabs.getTabCount() == 1) {
                Component c = tabs.getComponentAt(0);
                tabs.removeMouseListener((MouseListener)((Object)this.listener));
                tabs.removePropertyChangeListener(this.closeL);
                this.remove(tabs);
                this.add(c, "Center");
            }
        } else {
            if (comp != null) {
                this.remove(comp);
            }
            this.isVisible = false;
            this.close();
        }
        this.validate();
    }

    public JPanel getCurrentPanel() {
        if (this.getComponentCount() > 0) {
            Component comp = this.getComponent(0);
            if (comp instanceof JTabbedPane) {
                JTabbedPane tabs = (JTabbedPane)comp;
                return (JPanel)tabs.getSelectedComponent();
            }
            if (comp instanceof JPanel) {
                return (JPanel)comp;
            }
        }
        return null;
    }

    private void closeAllButCurrent() {
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            int i;
            JTabbedPane tabs = (JTabbedPane)comp;
            Component current = tabs.getSelectedComponent();
            int tabCount = tabs.getTabCount();
            Component[] c = new Component[tabCount - 1];
            int j = 0;
            for (i = 0; i < tabCount; ++i) {
                Component tab = tabs.getComponentAt(i);
                if (tab == current) continue;
                c[j++] = tab;
            }
            for (i = 0; i < c.length; ++i) {
                ((AbstractDocumentView)c[i]).close();
            }
        }
    }

    public static synchronized DocumentViewTopComponent getDefault() {
        if (instance == null) {
            instance = new DocumentViewTopComponent();
        }
        return instance;
    }

    public static synchronized DocumentViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DocumentViewTopComponent.class.getName()).warning("Cannot find DocumentViewTopComponent component. It will not be located properly in the window system.");
            return DocumentViewTopComponent.getDefault();
        }
        if (win instanceof DocumentViewTopComponent) {
            return (DocumentViewTopComponent)win;
        }
        Logger.getLogger(DocumentViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'DocumentViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DocumentViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    protected void componentClosed() {
        this.isVisible = false;
        if (this.getComponentCount() == 0) {
            return;
        }
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            int i;
            JTabbedPane pane = (JTabbedPane)comp;
            Component[] c = new Component[pane.getTabCount()];
            for (i = 0; i < c.length; ++i) {
                c[i] = pane.getComponentAt(i);
            }
            for (i = 0; i < c.length; ++i) {
                ((AbstractDocumentView)c[i]).close();
            }
        } else if (comp instanceof AbstractDocumentView) {
            ((AbstractDocumentView)comp).close();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(DocumentViewTopComponent.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentViewTopComponent.this.closeAllButCurrent();
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(DocumentViewTopComponent.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentViewTopComponent.this.close();
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(DocumentViewTopComponent.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentViewTopComponent.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            DocumentViewTopComponent.this.pop.show((Component)((Object)DocumentViewTopComponent.this), e.getX(), e.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                DocumentViewTopComponent.this.removePanel((JPanel)evt.getNewValue());
            }
        }
    }
}

