/*
 * Decompiled with CFR 0.152.
 */
package ancestris.renderer.velocity;

import ancestris.renderer.Renderer;
import ancestris.renderer.velocity.EntityWrapper;
import ancestris.renderer.velocity.FamWrapper;
import ancestris.renderer.velocity.GedcomWrapper;
import ancestris.renderer.velocity.IndiWrapper;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.io.File;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.SortTool;
import org.openide.modules.Places;

public class VelocityRenderer
implements Renderer {
    private VelocityContext context;
    RuntimeInstance engine = new RuntimeInstance();
    private static final File TEMPLATE_DIR = Places.getUserDirectory();

    public VelocityRenderer() {
        try {
            this.engine.setProperty("resource.loader", (Object)"file,class");
            this.engine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            this.engine.setProperty("class.resource.loader.cache", (Object)"true");
            this.engine.setProperty("file.resource.loader.path", (Object)TEMPLATE_DIR.getPath());
            this.engine.setProperty("file.resource.loader.cache", (Object)"false");
            this.engine.setProperty("directive.set.null.allowed", (Object)"true");
            this.engine.setProperty("runtime.interpolate.string.literals", (Object)"true");
            this.engine.init();
        }
        catch (Exception e) {
            System.out.println("Problem initializing Velocity : " + e);
        }
        this.restart();
    }

    private void restart() {
        this.context = new VelocityContext();
        this.context.put("gedcom", (Object)new Gedcom());
        this.context.put("sorter", (Object)new SortTool());
        this.context.put("date", (Object)new DateTool());
        this.context.put("null", null);
    }

    public void put(String key, Object o) {
        if (o instanceof Entity) {
            this.put(key, (Entity)o);
        } else if (o instanceof Gedcom) {
            this.put(key, (Gedcom)o);
        } else if (o instanceof Entity[]) {
            this.put(key, (Entity[])o);
        } else {
            this.context.put(key, o);
        }
    }

    private void put(String key, Gedcom e) {
        this.context.put(key, (Object)new GedcomWrapper(e));
    }

    private void put(String key, Fam f) {
        FamWrapper rf = null;
        if (f != null) {
            rf = new FamWrapper(f);
        }
        this.put(key, rf);
    }

    private void put(String key, Indi i) {
        this.context.put(key, (Object)new IndiWrapper(i));
    }

    private void put(String key, Entity e) {
        if (e instanceof Indi) {
            this.put(key, (Indi)e);
        } else if (e instanceof Fam) {
            this.put(key, (Fam)e);
        } else {
            this.put(key, new EntityWrapper(e));
        }
    }

    private void put(String key, Entity[] entities) {
        if (entities.length == 0) {
            this.put(key, new Object[0]);
        } else if (entities[0] instanceof Indi) {
            IndiWrapper[] reportIndis = new IndiWrapper[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportIndis[i] = new IndiWrapper((Indi)entities[i]);
            }
            this.put(key, reportIndis);
        } else if (entities[0] instanceof Fam) {
            FamWrapper[] reportFams = new FamWrapper[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                reportFams[i] = new FamWrapper((Fam)entities[i]);
            }
            this.put(key, reportFams);
        } else {
            this.put(key, (Object)null);
        }
    }

    public void render(String template, Writer out) {
        try {
            Template t = this.engine.getTemplate(template + ".vm", "ISO-8859-1");
            if (t != null) {
                t.merge((Context)this.context, out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.restart();
    }
}

