/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSRenderer;
import org.apache.fop.render.ps.PSRendererContextConstants;
import org.apache.fop.render.ps.PSTextElementBridge;
import org.apache.fop.render.ps.PSTextPainter;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PSSVGHandler
implements XMLHandler,
PSRendererContextConstants {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$ps$PSSVGHandler == null ? (class$org$apache$fop$render$ps$PSSVGHandler = PSSVGHandler.class$("org.apache.fop.render.ps.PSSVGHandler")) : class$org$apache$fop$render$ps$PSSVGHandler));
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSSVGHandler;

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        PSInfo psi = PSSVGHandler.getPSInfo(context);
        if ("http://www.w3.org/2000/svg".equals(ns)) {
            this.renderSVGDocument(context, doc, psi);
        }
    }

    public static PSInfo getPSInfo(RendererContext context) {
        PSInfo psi = new PSInfo();
        psi.psGenerator = (PSGenerator)context.getProperty("psGenerator");
        psi.fontInfo = (FontInfo)context.getProperty("psFontInfo");
        psi.width = (Integer)context.getProperty("width");
        psi.height = (Integer)context.getProperty("height");
        psi.currentXPosition = (Integer)context.getProperty("xpos");
        psi.currentYPosition = (Integer)context.getProperty("ypos");
        psi.cfg = (Configuration)context.getProperty("cfg");
        return psi;
    }

    protected void renderSVGDocument(RendererContext context, Document doc, PSInfo psInfo) {
        GraphicsNode root;
        int xOffset = psInfo.currentXPosition;
        int yOffset = psInfo.currentYPosition;
        PSGenerator gen = psInfo.psGenerator;
        boolean strokeText = false;
        Configuration cfg = psInfo.getHandlerConfiguration();
        if (cfg != null) {
            strokeText = cfg.getChild("stroke-text", true).getValueAsBoolean(strokeText);
        }
        SVGUserAgent ua = new SVGUserAgent(context.getUserAgent().getSourcePixelUnitToMillimeter(), new AffineTransform());
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext((UserAgent)ua);
        if (!strokeText) {
            PSTextPainter textPainter = new PSTextPainter(psInfo.getFontInfo());
            ctx.setTextPainter((TextPainter)textPainter);
            PSTextElementBridge tBridge = new PSTextElementBridge(textPainter);
            ctx.putBridge((Bridge)tBridge);
        }
        try {
            root = builder.build(ctx, doc);
        }
        catch (Exception e) {
            log.error((Object)("SVG graphic could not be built: " + e.getMessage()), (Throwable)e);
            return;
        }
        float w = (float)ctx.getDocumentSize().getWidth() * 1000.0f;
        float h = (float)ctx.getDocumentSize().getHeight() * 1000.0f;
        float sx = (float)psInfo.getWidth() / w;
        float sy = (float)psInfo.getHeight() / h;
        ctx = null;
        builder = null;
        try {
            gen.commentln("%FOPBeginSVG");
            gen.saveGraphicsState();
            gen.writeln("newpath");
            gen.defineRect((float)xOffset / 1000.0f, (float)yOffset / 1000.0f, (float)psInfo.getWidth() / 1000.0f, (float)psInfo.getHeight() / 1000.0f);
            gen.writeln("clip");
            gen.concatMatrix(sx, 0.0, 0.0, sy, (float)xOffset / 1000.0f, (float)yOffset / 1000.0f);
            SVGSVGElement svg = ((SVGDocument)doc).getRootElement();
            AffineTransform at = ViewBox.getPreserveAspectRatioTransform((Element)svg, (float)((float)psInfo.getWidth() / 1000.0f), (float)((float)psInfo.getHeight() / 1000.0f));
            boolean textAsShapes = false;
            PSGraphics2D graphics = new PSGraphics2D(false, gen);
            graphics.setGraphicContext(new GraphicContext());
            AffineTransform transform = new AffineTransform();
            transform.translate(xOffset, yOffset);
            gen.getCurrentState().concatMatrix(transform);
            try {
                root.paint((Graphics2D)((Object)graphics));
            }
            catch (Exception e) {
                log.error((Object)("SVG graphic could not be rendered: " + e.getMessage()), (Throwable)e);
            }
            gen.restoreGraphicsState();
            gen.commentln("%FOPEndSVG");
        }
        catch (IOException ioe) {
            log.error((Object)("SVG graphic could not be rendered: " + ioe.getMessage()), (Throwable)ioe);
        }
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer instanceof PSRenderer;
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/svg";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PSInfo {
        private PSGenerator psGenerator;
        private FontInfo fontInfo;
        private int width;
        private int height;
        private int currentXPosition;
        private int currentYPosition;
        private Configuration cfg;

        public PSGenerator getPSGenerator() {
            return this.psGenerator;
        }

        public void setPsGenerator(PSGenerator psGenerator) {
            this.psGenerator = psGenerator;
        }

        public FontInfo getFontInfo() {
            return this.fontInfo;
        }

        public void setFontInfo(FontInfo fontInfo) {
            this.fontInfo = fontInfo;
        }

        public int getCurrentXPosition() {
            return this.currentXPosition;
        }

        public void setCurrentXPosition(int currentXPosition) {
            this.currentXPosition = currentXPosition;
        }

        public int getCurrentYPosition() {
            return this.currentYPosition;
        }

        public void setCurrentYPosition(int currentYPosition) {
            this.currentYPosition = currentYPosition;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public Configuration getHandlerConfiguration() {
            return this.cfg;
        }

        public void setHandlerConfiguration(Configuration cfg) {
            this.cfg = cfg;
        }
    }
}

