/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class TableLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private TableContentLayoutManager contentLM;
    private ColumnSetup columns = null;
    private Block curBlockArea;
    private int referenceBPD;
    private double tableUnits;
    private boolean autoLayout = true;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    private int halfBorderSeparationBPD;
    private int halfBorderSeparationIPD;

    public TableLayoutManager(Table node) {
        super(node);
        this.columns = new ColumnSetup(node);
    }

    public Table getTable() {
        return (Table)this.fobj;
    }

    public ColumnSetup getColumns() {
        return this.columns;
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getTable().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getTable().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getTable().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getTable().getCommonMarginBlock().endIndent.getValue(this);
        if (this.getTable().isSeparateBorderModel()) {
            this.halfBorderSeparationBPD = this.getTable().getBorderSeparation().getBPD().getLength().getValue(this) / 2;
            this.halfBorderSeparationIPD = this.getTable().getBorderSeparation().getIPD().getLength().getValue(this) / 2;
        } else {
            this.halfBorderSeparationBPD = 0;
            this.halfBorderSeparationIPD = 0;
        }
        if (!this.getTable().isAutoLayout() && this.getTable().getInlineProgressionDimension().getOptimum(this).getEnum() != 9) {
            this.autoLayout = false;
        }
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public int getHalfBorderSeparationBPD() {
        return this.halfBorderSeparationBPD;
    }

    public int getHalfBorderSeparationIPD() {
        return this.halfBorderSeparationIPD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        LinkedList returnList = new LinkedList();
        if (!this.breakBeforeServed) {
            try {
                if (this.addKnuthElementsForBreakBefore(returnList, context)) {
                    LinkedList linkedList = returnList;
                    return linkedList;
                }
            }
            finally {
                this.breakBeforeServed = true;
            }
        }
        this.referenceBPD = context.getStackLimit().opt;
        this.referenceIPD = context.getRefIPD();
        if (this.getTable().getInlineProgressionDimension().getOptimum(this).getEnum() != 9) {
            int contentIPD = this.getTable().getInlineProgressionDimension().getOptimum(this).getLength().getValue(this);
            this.updateContentAreaIPDwithOverconstrainedAdjust(contentIPD);
        } else {
            if (!this.getTable().isAutoLayout()) {
                log.info((Object)"table-layout=\"fixed\" and width=\"auto\", but auto-layout not supported => assuming width=\"100%\"");
            }
            this.updateContentAreaIPDwithOverconstrainedAdjust();
        }
        int availableIPD = this.referenceIPD - this.getIPIndents();
        if (this.getContentAreaIPD() > availableIPD) {
            log.warn((Object)FONode.decorateWithContextInfo("The extent in inline-progression-direction (width) of a table is bigger than the available space (" + this.getContentAreaIPD() + "mpt > " + context.getRefIPD() + "mpt)", this.getTable()));
        }
        int sumCols = 0;
        float factors = 0.0f;
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            TableColumn column = (TableColumn)i.next();
            if (column == null) continue;
            Length width = column.getColumnWidth();
            sumCols += width.getValue(this);
            if (!(width instanceof TableColLength)) continue;
            factors = (float)((double)factors + ((TableColLength)width).getTableUnits());
        }
        if (sumCols < this.getContentAreaIPD() && this.tableUnits == 0.0) {
            this.tableUnits = (float)(this.getContentAreaIPD() - sumCols) / factors;
        }
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(returnList, alignment);
        }
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingBefore(returnList, !this.firstVisibleMarkServed);
            this.firstVisibleMarkServed = true;
        }
        this.addPendingMarks(context);
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LayoutContext childLC = new LayoutContext(0);
        childLC.setRefIPD(context.getRefIPD());
        childLC.copyPendingMarksFrom(context);
        if (this.contentLM == null) {
            this.contentLM = new TableContentLayoutManager(this);
        }
        returnedList = this.contentLM.getNextKnuthElements(childLC, alignment);
        if (childLC.isKeepWithNextPending()) {
            log.debug((Object)"TableContentLM signals pending keep-with-next");
            context.setFlags(512);
        }
        if (childLC.isKeepWithPreviousPending()) {
            log.debug((Object)"TableContentLM signals pending keep-with-previous");
            context.setFlags(1024);
        }
        Iterator iter = returnedList.iterator();
        while (iter.hasNext()) {
            ListElement el = (ListElement)iter.next();
            this.notifyPos(el.getPosition());
        }
        log.debug((Object)returnedList);
        if (returnedList.size() == 1 && ((ListElement)returnedList.getFirst()).isForcedBreak()) {
            if (returnList.size() == 0) {
                // empty if block
            }
            contentList.addAll(returnedList);
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
            return returnList;
        }
        contentList.addAll(returnedList);
        if (returnedList.size() > 0 && ((ListElement)returnedList.getLast()).isForcedBreak()) {
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
            return returnList;
        }
        this.wrapPositionElements(contentList, returnList);
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingAfter(returnList, true);
        }
        this.addKnuthElementsForSpaceAfter(returnList, alignment);
        this.addKnuthElementsForBreakAfter(returnList, context);
        this.setFinished(true);
        this.resetSpaces();
        return returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.getPSLM().addIDToPage(this.getTable().getId());
        int startXOffset = this.getTable().getCommonMarginBlock().startIndent.getValue(this);
        int tableHeight = 0;
        LayoutContext lc = new LayoutContext(0);
        lc.setRefIPD(this.getContentAreaIPD());
        this.contentLM.setStartXOffset(startXOffset);
        this.contentLM.addAreas(parentIter, lc);
        this.curBlockArea.setBPD(tableHeight += this.contentLM.getUsedBPD());
        if (this.getTable().isSeparateBorderModel()) {
            TraitSetter.addBorders(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
        }
        TraitSetter.addBackground(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this);
        TraitSetter.addMargins(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
        TraitSetter.addBreaks(this.curBlockArea, this.getTable().getBreakBefore(), this.getTable().getBreakAfter());
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.resetSpaces();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getTable().getId());
            this.curBlockArea.setIPD(this.getContentAreaIPD());
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getTable().getKeepTogether().getWithinPage().isAuto() || !this.getTable().getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getTable().getKeepWithPrevious().getWithinPage().isAuto() || !this.getTable().getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getTable().getKeepWithNext().getWithinPage().isAuto() || !this.getTable().getKeepWithNext().getWithinColumn().isAuto();
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        if (fobj instanceof TableColumn && fobj.getParent() == this.getFObj()) {
            switch (lengthBase) {
                case 5: {
                    return this.getContentAreaIPD();
                }
            }
            log.error((Object)"Unknown base type for LengthBase.");
            return 0;
        }
        switch (lengthBase) {
            case 11: {
                return (int)this.tableUnits;
            }
        }
        return super.getBaseLength(lengthBase, fobj);
    }

    public int getContentAreaBPD() {
        return this.referenceBPD;
    }

    public void notifySpace(RelSide side, MinOptMax effectiveLength) {
        if (RelSide.BEFORE == side) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceBefore + "-> " + effectiveLength));
            }
            this.effSpaceBefore = effectiveLength;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceAfter + "-> " + effectiveLength));
            }
            this.effSpaceAfter = effectiveLength;
        }
    }

    public void notifyBorder(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + side + " -> " + effectiveLength));
        }
    }

    public void notifyPadding(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + side + " -> " + effectiveLength));
        }
    }
}

