/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;

public class InlineArea
extends Area {
    protected int offset = 0;
    private Area parentArea = null;
    private int storedIPDVariation = 0;

    public void increaseIPD(int ipd) {
        this.ipd += ipd;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setParentArea(Area parentArea) {
        this.parentArea = parentArea;
        if (this.storedIPDVariation > 0) {
            this.notifyIPDVariation(this.storedIPDVariation);
            this.storedIPDVariation = 0;
        }
    }

    public Area getParentArea() {
        return this.parentArea;
    }

    public void addChildArea(Area childArea) {
        super.addChildArea(childArea);
        if (childArea instanceof InlineArea) {
            ((InlineArea)childArea).setParentArea(this);
        }
    }

    public boolean hasUnderline() {
        return this.getBooleanTrait(Trait.UNDERLINE);
    }

    public boolean hasOverline() {
        return this.getBooleanTrait(Trait.OVERLINE);
    }

    public boolean hasLineThrough() {
        return this.getBooleanTrait(Trait.LINETHROUGH);
    }

    public boolean isBlinking() {
        return this.getBooleanTrait(Trait.BLINK);
    }

    public void updateIPD(int newIPD) {
    }

    public boolean applyVariationFactor(double variationFactor, int lineStretch, int lineShrink) {
        return false;
    }

    protected void notifyIPDVariation(int ipdVariation) {
        if (this.getParentArea() instanceof InlineArea) {
            ((InlineArea)this.getParentArea()).notifyIPDVariation(ipdVariation);
        } else if (this.getParentArea() instanceof LineArea) {
            ((LineArea)this.getParentArea()).handleIPDVariation(ipdVariation);
        } else if (this.getParentArea() == null) {
            this.storedIPDVariation += ipdVariation;
        }
    }

    protected class InlineAdjustingInfo {
        protected int availableStretch;
        protected int availableShrink;
        protected int adjustment;

        protected InlineAdjustingInfo(int stretch, int shrink, int adj) {
            this.availableStretch = stretch;
            this.availableShrink = shrink;
            this.adjustment = adj;
        }
    }
}

