/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.renderer.BlueprintRenderer;
import genj.renderer.EmptyHintKey;
import genj.renderer.RenderPreviewHintKey;
import genj.tree.Model;
import genj.tree.TreeArc;
import genj.util.swing.UnitGraphics;
import gj.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public class ContentRenderer {
    Font font = null;
    Color cIndiShape = null;
    Color cFamShape = null;
    Color cArcs = null;
    Color cSelectedShape = null;
    Color cRootShape = null;
    Collection<? extends Entity> selected = new ArrayList<Entity>(0);
    Entity root = null;
    BlueprintRenderer indiRenderer;
    BlueprintRenderer famRenderer;

    public void render(UnitGraphics g, Model model) {
        Rectangle bounds = model.getBounds();
        g.translate(-bounds.getX(), -bounds.getY());
        this.renderArcs(g, model);
        this.renderNodes(g, model);
    }

    private void renderNodes(UnitGraphics g, Model model) {
        Rectangle clip = g.getClip().getBounds();
        int count = 0;
        for (Node node : model.getNodesIn(clip)) {
            Shape shape = node.getShape();
            Point2D pos = node.getPosition();
            if (shape == null) continue;
            Rectangle r = shape.getBounds();
            if (!clip.intersects(pos.getX() + r.getMinX(), pos.getY() + r.getMinY(), r.getWidth(), r.getHeight())) continue;
            ++count;
            this.renderNode(g, pos, shape, node.getContent());
        }
        if (count > 0) {
            g.getGraphics().setRenderingHint(EmptyHintKey.KEY, false);
        }
    }

    private void renderNode(UnitGraphics g, Point2D pos, Shape shape, Object content) {
        double x = pos.getX();
        double y = pos.getY();
        g.setColor(this.getColor(content));
        g.draw(shape, x, y);
        if (!Boolean.TRUE.equals(g.getGraphics().getRenderingHint(RenderPreviewHintKey.KEY))) {
            this.renderContent(g, x, y, shape, content);
        }
    }

    private Color getColor(Object content) {
        if (this.cRootShape != null && content != null && content.equals(this.root)) {
            return this.cRootShape;
        }
        if (this.cSelectedShape != null && this.selected.contains(content)) {
            return this.cSelectedShape;
        }
        if (content instanceof Fam) {
            return this.cFamShape;
        }
        return this.cIndiShape;
    }

    private void renderContent(UnitGraphics g, double x, double y, Shape shape, Object content) {
        BlueprintRenderer renderer = null;
        if (content instanceof Indi) {
            renderer = this.indiRenderer;
        }
        if (content instanceof Fam) {
            renderer = this.famRenderer;
        }
        if (renderer == null) {
            return;
        }
        Rectangle r2d = shape.getBounds();
        g.pushClip(x, y, (Rectangle2D)r2d);
        g.pushTransformation();
        g.translate(x, y);
        Rectangle r = g.getRectangle((Rectangle2D)r2d);
        r.x += 2;
        r.y += 2;
        r.width -= 4;
        r.height -= 4;
        g.setColor(Color.black);
        g.setFont(this.font);
        renderer.render((Graphics)g.getGraphics(), (Property)((Entity)content), r);
        g.popTransformation();
        g.popClip();
    }

    private void renderArcs(UnitGraphics g, Model model) {
        Rectangle clip = g.getClip().getBounds();
        g.setColor(this.cArcs);
        Collection<TreeArc> arcs = model.getArcsIn(clip);
        for (TreeArc arc : arcs) {
            g.draw((Shape)arc.getPath(), 0.0, 0.0);
        }
        if (!arcs.isEmpty()) {
            g.getGraphics().setRenderingHint(EmptyHintKey.KEY, false);
        }
    }
}

