/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.fop.image.analyser.ImageReaderFactory;
import org.apache.fop.svg.PDFGraphics2D;
import org.w3c.dom.Element;

public class PDFImageElementBridge
extends SVGImageElementBridge {
    protected GraphicsNode createImageGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        try {
            InputStream is = purl.openStream();
            if (!is.markSupported()) {
                is = new BufferedInputStream(is, 1024);
            }
            is.mark(3);
            byte[] data = new byte[3];
            is.read(data);
            is.reset();
            if (data[0] == -1 && data[1] == -40 && data[2] == -1) {
                FopImage.ImageInfo ii = ImageReaderFactory.make(purl.toString(), is, null);
                JpegImage jpeg = new JpegImage(ii);
                jpeg.load(2);
                PDFJpegNode node = new PDFJpegNode(jpeg, ctx, imageElement, purl);
                Rectangle2D imgBounds = PDFImageElementBridge.getImageBounds((BridgeContext)ctx, (Element)imageElement);
                Rectangle2D bounds = node.getPrimitiveBounds();
                float[] vb = new float[]{0.0f, 0.0f, (float)bounds.getWidth(), (float)bounds.getHeight()};
                PDFImageElementBridge.initializeViewport((BridgeContext)ctx, (Element)imageElement, (GraphicsNode)node, (float[])vb, (Rectangle2D)imgBounds);
                return node;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.superCreateGraphicsNode(ctx, imageElement, purl);
    }

    protected GraphicsNode superCreateGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        return super.createImageGraphicsNode(ctx, imageElement, purl);
    }

    public class PDFJpegNode
    extends AbstractGraphicsNode {
        private JpegImage jpeg;
        private BridgeContext ctx;
        private Element imageElement;
        private ParsedURL purl;
        private GraphicsNode origGraphicsNode = null;

        public PDFJpegNode(JpegImage j, BridgeContext ctx, Element imageElement, ParsedURL purl) {
            this.jpeg = j;
            this.ctx = ctx;
            this.imageElement = imageElement;
            this.purl = purl;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            if (g2d instanceof PDFGraphics2D) {
                PDFGraphics2D pdfg = (PDFGraphics2D)((Object)g2d);
                float x = 0.0f;
                float y = 0.0f;
                try {
                    float width = this.jpeg.getWidth();
                    float height = this.jpeg.getHeight();
                    pdfg.addJpegImage(this.jpeg, x, y, width, height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (this.origGraphicsNode == null) {
                    this.origGraphicsNode = PDFImageElementBridge.this.superCreateGraphicsNode(this.ctx, this.imageElement, this.purl);
                }
                this.origGraphicsNode.primitivePaint(g2d);
            }
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            try {
                return new Rectangle2D.Double(0.0, 0.0, this.jpeg.getWidth(), this.jpeg.getHeight());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }
}

