/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;

public class RtfTableRow
extends RtfContainer
implements ITableAttributes {
    private RtfTableCell cell;
    private int id;
    private int highestCell = 0;

    RtfTableRow(RtfTable parent, Writer w, int idNum) throws IOException {
        super(parent, w);
        this.id = idNum;
    }

    RtfTableRow(RtfTable parent, Writer w, RtfAttributes attrs, int idNum) throws IOException {
        super(parent, w, attrs);
        this.id = idNum;
    }

    public RtfTableCell newTableCell(int cellWidth) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCell(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, attrs, this.highestCell);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedVertically(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        this.cell = new RtfTableCell(this, this.writer, cellWidth, attrs, this.highestCell);
        this.cell.setVMerge(2);
        return this.cell;
    }

    public RtfTableCell newTableCellMergedHorizontally(int cellWidth, RtfAttributes attrs) throws IOException {
        ++this.highestCell;
        RtfAttributes wAttributes = null;
        if (attrs != null) {
            wAttributes = (RtfAttributes)attrs.clone();
        }
        this.cell = new RtfTableCell(this, this.writer, cellWidth, wAttributes, this.highestCell);
        this.cell.setHMerge(2);
        return this.cell;
    }

    protected void writeRtfPrefix() throws IOException {
        this.newLine();
        this.writeGroupMark(true);
    }

    protected void writeRtfContent() throws IOException {
        if (this.getTable().isNestedTable()) {
            this.writeControlWord("intbl");
            this.writeControlWord("itap2");
        } else {
            this.writeRowAndCellsDefintions();
        }
        super.writeRtfContent();
    }

    public void writeRowAndCellsDefintions() throws IOException {
        this.writeControlWord("trowd");
        if (!this.getTable().isNestedTable()) {
            this.writeControlWord("itap0");
        }
        if (this.attrib != null && this.attrib.isSet("trkeep")) {
            this.writeControlWord("trkeep");
        }
        this.writePaddingAttributes();
        RtfTable parentTable = (RtfTable)this.parent;
        this.adjustBorderProperties(parentTable);
        this.writeAttributes(this.attrib, new String[]{"trhdr"});
        this.writeAttributes(this.attrib, ITableAttributes.ROW_BORDER);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        if (this.attrib.isSet("trrh")) {
            this.writeOneAttribute("trrh", this.attrib.getValue("trrh"));
        }
        int xPos = 0;
        Object leftIndent = this.attrib.getValue("trleft");
        if (leftIndent != null) {
            xPos = (Integer)leftIndent;
        }
        RtfAttributes tableBorderAttributes = this.getTable().getBorderAttributes();
        int index = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            RtfElement e = (RtfElement)it.next();
            if (e instanceof RtfTableCell) {
                RtfTableCell rtfcell = (RtfTableCell)e;
                if (index == 0 && !rtfcell.getRtfAttributes().isSet("clbrdrl")) {
                    rtfcell.getRtfAttributes().set("clbrdrl", (RtfAttributes)tableBorderAttributes.getValue("clbrdrl"));
                }
                if (index == this.getChildCount() - 1 && !rtfcell.getRtfAttributes().isSet("clbrdrr")) {
                    rtfcell.getRtfAttributes().set("clbrdrr", (RtfAttributes)tableBorderAttributes.getValue("clbrdrr"));
                }
                if (this.isFirstRow() && !rtfcell.getRtfAttributes().isSet("clbrdrt")) {
                    rtfcell.getRtfAttributes().set("clbrdrt", (RtfAttributes)tableBorderAttributes.getValue("clbrdrt"));
                }
                if (parentTable != null && parentTable.isHighestRow(this.id) && !rtfcell.getRtfAttributes().isSet("clbrdrb")) {
                    rtfcell.getRtfAttributes().set("clbrdrb", (RtfAttributes)tableBorderAttributes.getValue("clbrdrb"));
                }
                if (index == 0 && !rtfcell.getRtfAttributes().isSet("clbrdrl")) {
                    rtfcell.getRtfAttributes().set("clbrdrl", (String)this.attrib.getValue("trbrdrl"));
                }
                if (index == this.getChildCount() - 1 && !rtfcell.getRtfAttributes().isSet("clbrdrr")) {
                    rtfcell.getRtfAttributes().set("clbrdrr", (String)this.attrib.getValue("trbrdrr"));
                }
                if (this.isFirstRow() && !rtfcell.getRtfAttributes().isSet("clbrdrt")) {
                    rtfcell.getRtfAttributes().set("clbrdrt", (String)this.attrib.getValue("trbrdrt"));
                }
                if (parentTable != null && parentTable.isHighestRow(this.id) && !rtfcell.getRtfAttributes().isSet("clbrdrb")) {
                    rtfcell.getRtfAttributes().set("clbrdrb", (String)this.attrib.getValue("trbrdrb"));
                }
                xPos = rtfcell.writeCellDef(xPos);
            }
            ++index;
        }
        this.newLine();
    }

    private void adjustBorderProperties(RtfTable parentTable) {
        if (this.attrib != null && parentTable != null) {
            if (this.isFirstRow() && parentTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrh");
            } else if (this.isFirstRow()) {
                this.attrib.unset("trbrdrb");
            } else if (parentTable.isHighestRow(this.id)) {
                this.attrib.unset("trbrdrt");
            } else {
                this.attrib.unset("trbrdrb");
                this.attrib.unset("trbrdrt");
            }
        }
    }

    protected void writeRtfSuffix() throws IOException {
        if (this.getTable().isNestedTable()) {
            this.writeGroupMark(true);
            this.writeStarControlWord("nesttableprops");
            this.writeRowAndCellsDefintions();
            this.writeControlWordNS("nestrow");
            this.writeGroupMark(false);
            this.writeGroupMark(true);
            this.writeControlWord("nonesttables");
            this.writeControlWord("par");
            this.writeGroupMark(false);
        } else {
            this.writeControlWord("row");
        }
        this.writeGroupMark(false);
    }

    private void writePaddingAttributes() throws IOException {
        if (this.attrib != null && !this.attrib.isSet("trgaph")) {
            int gaph = -1;
            try {
                Integer rightPadStr;
                Integer leftPadStr = (Integer)this.attrib.getValue("trpaddl");
                if (leftPadStr != null) {
                    gaph = leftPadStr;
                }
                if ((rightPadStr = (Integer)this.attrib.getValue("trpaddr")) != null) {
                    gaph = (gaph + rightPadStr) / 2;
                }
            }
            catch (Exception e) {
                String string = "RtfTableRow.writePaddingAttributes: " + e.toString();
            }
            if (gaph >= 0) {
                this.attrib.set("trgaph", gaph);
            }
        }
        this.writeAttributes(this.attrib, ATTRIB_ROW_PADDING);
    }

    public boolean isFirstRow() {
        return this.id == 1;
    }

    public boolean isHighestCell(int cellId) {
        return this.highestCell == cellId;
    }

    public RtfTable getTable() {
        RtfContainer e = this;
        while (e.parent != null) {
            if (e.parent instanceof RtfTable) {
                return (RtfTable)e.parent;
            }
            e = e.parent;
        }
        return null;
    }
}

