/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFMetadata
extends PDFStream {
    private Document xmpMetadata;
    private boolean readOnly = true;

    public PDFMetadata(Document xmp, boolean readOnly) {
        if (xmp == null) {
            throw new NullPointerException("DOM Document representing the metadata must no be null");
        }
        this.xmpMetadata = xmp;
        this.readOnly = readOnly;
    }

    protected void setupFilterList() {
        if (!this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), "metadata");
        }
        super.setupFilterList();
    }

    protected boolean allowEncryption() {
        return false;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = super.output(stream);
        this.xmpMetadata = null;
        return length;
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        String encoding = "UTF-8";
        out.write("<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n".getBytes("UTF-8"));
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            DOMSource src = new DOMSource(this.xmpMetadata);
            StreamResult res = new StreamResult(out);
            transformer.transform(src, res);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Error setting up Transformer for XMP stream serialization: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException("Error while serializing XMP stream: " + e.getMessage());
        }
        if (this.readOnly) {
            out.write("\n<?xpacket end=\"r\"?>".getBytes("UTF-8"));
        } else {
            StringBuffer sb = new StringBuffer(101);
            sb.append('\n');
            for (int i = 0; i < 100; ++i) {
                sb.append(" ");
            }
            byte[] padding = sb.toString().getBytes("UTF-8");
            for (int i = 0; i < 40; ++i) {
                out.write(padding);
            }
            out.write("\n<?xpacket end=\"w\"?>".getBytes("UTF-8"));
        }
    }

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        if (this.getDocumentSafely().getPDFAMode().isPDFA1LevelB() && filterEntry != null && filterEntry.length() > 0) {
            throw new PDFConformanceException("The Filter key is prohibited when PDF/A-1 is active");
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<< ");
        sb.append("/Type /Metadata");
        sb.append("\n/Subtype /XML");
        sb.append("\n/Length " + lengthEntry);
        sb.append("\n" + filterEntry);
        sb.append("\n>>\n");
        return sb.toString();
    }

    public static Document createXMPFromUserAgent(PDFDocument pdfDoc) {
        Element el;
        DOMImplementation domImplementation = ElementMapping.getDefaultDOMImplementation();
        Document doc = domImplementation.createDocument("adobe:ns:meta/", "x:xmpmeta", null);
        Element rdf = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:RDF");
        doc.getDocumentElement().appendChild(rdf);
        PDFInfo info = pdfDoc.getInfo();
        SimpleDateFormat pseudoISO8601DateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS'Z'");
        pseudoISO8601DateFormat.setTimeZone(TimeZone.getTimeZone("GMT+00"));
        if (info.getCreationDate() == null) {
            Date d = new Date();
            info.setCreationDate(d);
        }
        String xmlns = "http://www.w3.org/2000/xmlns/";
        Element desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttribute("about", "");
        desc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rdf.appendChild(desc);
        if (info.getAuthor() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:creator");
            desc.appendChild(el);
            Element seq = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Seq");
            el.appendChild(seq);
            Element li = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:li");
            seq.appendChild(li);
            li.appendChild(doc.createTextNode(info.getAuthor()));
        }
        if (info.getTitle() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:title");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getTitle()));
        }
        if (info.getSubject() != null) {
            el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:subject");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getSubject()));
        }
        el = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:date");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(pseudoISO8601DateFormat.format(info.getCreationDate())));
        desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttribute("about", "");
        desc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xmp", "http://ns.adobe.com/xap/1.0/");
        rdf.appendChild(desc);
        el = doc.createElementNS("http://ns.adobe.com/xap/1.0/", "xmp:createDate");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(pseudoISO8601DateFormat.format(info.getCreationDate())));
        if (info.getCreator() != null) {
            el = doc.createElementNS("http://ns.adobe.com/xap/1.0/", "xmp:creatorTool");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getCreator()));
        }
        desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        desc.setAttribute("about", "");
        desc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pdf", "http://ns.adobe.com/pdf/1.3/");
        rdf.appendChild(desc);
        if (info.getKeywords() != null) {
            el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:Keywords");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getKeywords()));
        }
        if (info.getProducer() != null) {
            el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:Producer");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode(info.getProducer()));
        }
        el = doc.createElementNS("http://ns.adobe.com/pdf/1.3/", "pdf:PDFVersion");
        desc.appendChild(el);
        el.appendChild(doc.createTextNode(pdfDoc.getPDFVersionString()));
        PDFAMode pdfaMode = pdfDoc.getPDFAMode();
        if (pdfaMode.isPDFA1LevelB()) {
            desc = doc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
            desc.setAttribute("about", "");
            desc.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pdfaid", "http://www.aiim.org/pdfa/ns/id");
            rdf.appendChild(desc);
            el = doc.createElementNS("http://www.aiim.org/pdfa/ns/id", "pdfaid:part");
            desc.appendChild(el);
            el.appendChild(doc.createTextNode("1"));
            el = doc.createElementNS("http://www.aiim.org/pdfa/ns/id", "pdfaid:conformance");
            desc.appendChild(el);
            if (pdfaMode == PDFAMode.PDFA_1A) {
                el.appendChild(doc.createTextNode("A"));
            } else {
                el.appendChild(doc.createTextNode("B"));
            }
        }
        return doc;
    }
}

