/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public class PageNumberCitationLayoutManager
extends LeafNodeLayoutManager {
    private PageNumberCitation fobj;
    private Font font;
    private boolean resolved = false;

    public PageNumberCitationLayoutManager(PageNumberCitation node) {
        super(node);
        this.fobj = node;
    }

    public void initialize() {
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo(), this);
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext context) {
        return new AlignmentContext(this.font, this.fobj.getLineHeight().getOptimum(this).getLength().getValue(this), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), context.getAlignmentContext());
    }

    public InlineArea get(LayoutContext context) {
        this.curArea = this.getPageNumberCitationInlineArea(this.parentLM);
        return this.curArea;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        super.addAreas(posIter, context);
        if (!this.resolved) {
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)this.curArea));
        }
    }

    private InlineArea getPageNumberCitationInlineArea(LayoutManager parentLM) {
        PageViewport page = this.getPSLM().getFirstPVWithID(this.fobj.getRefId());
        TextArea inline = null;
        if (page != null) {
            TextArea text;
            String str = page.getPageNumberString();
            inline = text = new TextArea();
            int width = this.getStringWidth(str);
            text.addWord(str, 0);
            inline.setIPD(width);
            this.resolved = true;
        } else {
            this.resolved = false;
            inline = new UnresolvedPageNumber(this.fobj.getRefId(), this.font);
            String str = "MMM";
            int width = this.getStringWidth(str);
            inline.setIPD(width);
        }
        TraitSetter.setProducerID(inline, this.fobj.getId());
        inline.setBPD(this.font.getAscender() - this.font.getDescender());
        inline.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits(inline, this.font);
        inline.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addTextDecoration(inline, this.fobj.getTextDecoration());
        return inline;
    }

    private int getStringWidth(String str) {
        int width = 0;
        for (int count = 0; count < str.length(); ++count) {
            width += this.font.getCharWidth(str.charAt(count));
        }
        return width;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

