/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDirectory;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.BatikImage;
import org.apache.fop.image.FopImage;

public class TIFFImage
extends BatikImage {
    private int compression = 0;
    private int stripCount = 0;
    private long stripOffset = 0L;
    private long stripLength = 0L;

    public TIFFImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
    }

    public int getCompression() {
        return this.compression;
    }

    public int getStripCount() {
        return this.stripCount;
    }

    protected CachableRed decodeImage(SeekableStream stream) throws IOException {
        org.apache.batik.ext.awt.image.codec.tiff.TIFFImage img = new org.apache.batik.ext.awt.image.codec.tiff.TIFFImage(stream, null, 0);
        TIFFDirectory dir = (TIFFDirectory)img.getProperty("tiff_directory");
        TIFFField fld = dir.getField(296);
        int resUnit = fld.getAsInt(0);
        fld = dir.getField(282);
        double xRes = fld.getAsDouble(0);
        fld = dir.getField(283);
        double yRes = fld.getAsDouble(0);
        switch (resUnit) {
            case 2: {
                this.dpiHorizontal = xRes;
                this.dpiVertical = yRes;
                break;
            }
            case 3: {
                this.dpiHorizontal = xRes * (double)2.54f;
                this.dpiVertical = yRes * (double)2.54f;
                break;
            }
            default: {
                log.warn((Object)("Cannot determine bitmap resolution. Unimplemented resolution unit: " + resUnit));
            }
        }
        fld = dir.getField(259);
        if (fld != null) {
            this.compression = fld.getAsInt(0);
        }
        if ((fld = dir.getField(258)) != null) {
            this.bitsPerPixel = fld.getAsInt(0);
        }
        this.stripCount = (fld = dir.getField(278)) == null ? 1 : (int)(dir.getFieldAsLong(257) / fld.getAsLong(0));
        this.stripOffset = dir.getField(273).getAsLong(0);
        this.stripLength = dir.getField(279).getAsLong(0);
        if (this.bitsPerPixel == 1) {
            this.colorSpace = ColorSpace.getInstance(1003);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadOriginalData() {
        if (this.loadDimensions()) {
            boolean bl;
            byte[] readBuf;
            block6: {
                readBuf = new byte[(int)this.stripLength];
                this.seekableInput.reset();
                this.seekableInput.skip(this.stripOffset);
                int bytesRead = this.seekableInput.read(readBuf);
                if ((long)bytesRead == this.stripLength) break block6;
                log.error((Object)"Error while loading image: length mismatch on read");
                boolean bl2 = false;
                Object var6_6 = null;
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return bl2;
            }
            try {
                this.raw = readBuf;
                bl = true;
                Object var6_7 = null;
            }
            catch (IOException ioe) {
                boolean bl3;
                try {
                    log.error((Object)"Error while loading image strip 1 (TIFF): ", (Throwable)ioe);
                    bl3 = false;
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    IOUtils.closeQuietly((InputStream)this.seekableInput);
                    IOUtils.closeQuietly((InputStream)this.inputStream);
                    this.seekableInput = null;
                    this.inputStream = null;
                    this.cr = null;
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return bl3;
            }
            IOUtils.closeQuietly((InputStream)this.seekableInput);
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.seekableInput = null;
            this.inputStream = null;
            this.cr = null;
            return bl;
        }
        return false;
    }
}

