/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.xml.sax.Locator;

public class TableBody
extends TableFObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private int visibility;
    private PropertyList savedPropertyList;
    protected boolean tableRowsFound = false;
    protected boolean tableCellsFound = false;
    protected List pendingSpans;
    protected BitSet usedColumnIndices = new BitSet();
    private int columnIndex = 1;
    private boolean firstRow = true;

    public TableBody(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.visibility = pList.get(235).getEnum();
        super.bind(pList);
        this.savedPropertyList = pList;
    }

    protected void startOfNode() throws FOPException {
        this.initPendingSpans();
        this.getFOEventHandler().startBody(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endBody(this);
        if (!this.tableRowsFound && !this.tableCellsFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (table-row+|table-cell+)");
            } else {
                this.getLogger().error((Object)"fo:table-body must not be empty. Expected: marker* (table-row+|table-cell+)");
                this.getParent().removeChild(this);
            }
        }
        this.savedPropertyList = null;
        this.pendingSpans = null;
        this.usedColumnIndices = null;
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.tableRowsFound || this.tableCellsFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-row+|table-cell+)");
                }
            } else if (localName.equals("table-row")) {
                this.tableRowsFound = true;
                if (this.tableCellsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else if (localName.equals("table-cell")) {
                this.tableCellsFound = true;
                if (this.tableRowsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (child.getNameId() == 50) {
            this.addCellNode((TableCell)child);
        } else {
            super.addChildNode(child);
        }
    }

    private void addCellNode(TableCell cell) throws FOPException {
        int i;
        if (this.firstRow && cell.startsRow() && !this.lastCellEndedRow()) {
            this.firstRow = false;
        }
        int rowSpan = cell.getNumberRowsSpanned();
        int colSpan = cell.getNumberColumnsSpanned();
        if (this.firstRow && this.getTable().columns == null) {
            if (this.pendingSpans == null) {
                this.pendingSpans = new ArrayList();
            }
            i = colSpan;
            while (--i >= 0) {
                this.pendingSpans.add(null);
            }
        }
        if (rowSpan > 1) {
            i = colSpan;
            while (--i >= 0) {
                this.pendingSpans.set(this.columnIndex - 1 + i, new TableFObj.PendingSpan(rowSpan));
            }
        }
        int startIndex = this.columnIndex - 1;
        int endIndex = startIndex + colSpan;
        if (this.getTable().columns != null) {
            List cols = this.getTable().columns;
            int tmpIndex = endIndex;
            for (int i2 = startIndex; i2 <= tmpIndex; ++i2) {
                if (i2 >= cols.size() || cols.get(i2) != null) continue;
                ++endIndex;
            }
        }
        for (int i3 = startIndex; i3 < endIndex; ++i3) {
            this.usedColumnIndices.set(i3);
        }
        this.setNextColumnIndex();
        super.addChildNode(cell);
        if (cell.endsRow()) {
            if (this.firstRow) {
                this.firstRow = false;
            }
            this.resetColumnIndex();
        }
    }

    private void convertCellsToRows() throws FOPException {
        ArrayList cells = new ArrayList(this.childNodes);
        this.childNodes.clear();
        Iterator i = cells.iterator();
        TableRow row = null;
        while (i.hasNext()) {
            TableCell cell = (TableCell)i.next();
            if (cell.startsRow() && row != null) {
                this.childNodes.add(row);
                row = null;
            }
            if (row == null) {
                row = new TableRow(this);
                StaticPropertyList pList = new StaticPropertyList(row, this.savedPropertyList);
                pList.setWritingMode();
                row.bind(pList);
            }
            row.addReplacedCell(cell);
            if (!cell.endsRow()) continue;
            this.childNodes.add(row);
            row = null;
        }
        if (row != null) {
            this.childNodes.add(row);
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-body";
    }

    public int getNameId() {
        return 48;
    }

    public boolean isFirst(TableRow obj) {
        return this.childNodes.size() > 0 && this.childNodes.get(0) == obj;
    }

    public boolean isLast(TableRow obj) {
        return this.childNodes.size() > 0 && this.childNodes.get(this.childNodes.size() - 1) == obj;
    }

    protected void initPendingSpans() {
        if (this.getTable().columns != null) {
            List tableCols = this.getTable().columns;
            this.pendingSpans = new ArrayList(tableCols.size());
            int i = tableCols.size();
            while (--i >= 0) {
                this.pendingSpans.add(null);
            }
        }
    }

    public int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    public void setCurrentColumnIndex(int newIndex) {
        this.columnIndex = newIndex;
    }

    public void resetColumnIndex() {
        this.columnIndex = 1;
        for (int i = 0; i < this.usedColumnIndices.size(); ++i) {
            this.usedColumnIndices.clear(i);
        }
        int i = this.pendingSpans.size();
        while (--i >= 0) {
            TableFObj.PendingSpan pSpan = (TableFObj.PendingSpan)this.pendingSpans.get(i);
            if (pSpan != null) {
                --pSpan.rowsLeft;
                if (pSpan.rowsLeft == 0) {
                    this.pendingSpans.set(i, null);
                }
            }
            if (this.pendingSpans.get(i) != null) {
                this.usedColumnIndices.set(i);
                continue;
            }
            this.usedColumnIndices.clear(i);
        }
        if (!this.firstRow) {
            this.setNextColumnIndex();
        }
    }

    private void setNextColumnIndex() {
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
            if (this.getTable().columns == null) continue;
            while (this.columnIndex <= this.getTable().columns.size() && !this.getTable().isColumnNumberUsed(this.columnIndex)) {
                ++this.columnIndex;
            }
        }
    }

    public boolean lastCellEndedRow() {
        FONode prevNode;
        if (this.childNodes != null && (prevNode = (FONode)this.childNodes.get(this.childNodes.size() - 1)).getNameId() == 50) {
            return ((TableCell)prevNode).endsRow();
        }
        return true;
    }

    public boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }
}

